/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.Splinex;

import org.openstreetmap.josm.Main;

public class SplineHitTest {
    double x;
    double y;
    double dist;
    double distSq;
    static final double pixTolerance = 1.0;

    public void setCoord(double x, double y, double dist) {
        this.x = x;
        this.y = y;
        this.dist = dist;
        this.distSq = dist * dist;
    }

    private double sqr(double x) {
        return x * x;
    }

    public boolean checkPoint(double x1, double y1) {
        return this.sqr(x1 - this.x) + this.sqr(y1 - this.y) <= this.distSq;
    }

    public boolean checkCurve(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        return this.checkCurve(x1, y1, x2, y2, x3, y3, x4, y4, 32);
    }

    public boolean checkCurve(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, int depth) {
        double dl3;
        double dl2;
        if (Main.isDebugEnabled()) {
            Main.debug((String)"checkCurve {0} {1} {2} {3} {4} {5} {6} {7}", (Object[])new Object[]{x1, y1, x2, y2, x3, y3, x4, y4});
        }
        double dx = x4 - x1;
        double dy = y4 - y1;
        double dl = (this.x - x1) * dx + (this.y - y1) * dy;
        double lenSq = dx * dx + dy * dy;
        double dp = (this.x - x1) * dy - (this.y - y1) * dx;
        boolean forcesplit = false;
        if (dl < 0.0) {
            dl2 = ((x2 - x1) * dx + (y2 - y1) * dy) * 0.75;
            dl3 = ((x3 - x1) * dx + (y3 - y1) * dy) * 0.75;
            if (dl2 > 0.0 && dl3 > 0.0 || dl < dl2 && this.sqr(dl - dl2) > lenSq * this.distSq && dl < dl3 && this.sqr(dl - dl3) > lenSq * this.distSq) {
                return false;
            }
            forcesplit = true;
        }
        if (dl > lenSq) {
            dl = (this.x - x4) * dx + (this.y - y4) * dy;
            dl2 = ((x2 - x4) * dx + (y2 - y4) * dy) * 0.75;
            dl3 = ((x3 - x4) * dx + (y3 - y4) * dy) * 0.75;
            if (dl2 < 0.0 && dl3 < 0.0 || dl > dl2 && this.sqr(dl - dl2) > lenSq * this.distSq && dl > dl3 && this.sqr(dl - dl3) > lenSq * this.distSq) {
                return false;
            }
            forcesplit = true;
        }
        double d2 = ((x2 - x1) * dy - (y2 - y1) * dx) * 0.75;
        double d3 = ((x3 - x1) * dy - (y3 - y1) * dx) * 0.75;
        if (this.sqr(Math.abs(d2) + Math.abs(d3)) < 1.0 * lenSq && !forcesplit) {
            return dp * dp <= this.distSq * lenSq;
        }
        if (dp * dp > this.distSq * lenSq && (Math.signum(d2) != Math.signum(dp) || Math.abs(dp) > Math.abs(d2) && this.sqr(dp - d2) > lenSq * this.distSq) && (Math.signum(d3) != Math.signum(dp) || Math.abs(dp) > Math.abs(d3) && this.sqr(dp - d3) > lenSq * this.distSq)) {
            return false;
        }
        double x12 = (x1 + x2) / 2.0;
        double x23 = (x2 + x3) / 2.0;
        double x123 = (x12 + x23) / 2.0;
        double x34 = (x3 + x4) / 2.0;
        double x234 = (x23 + x34) / 2.0;
        double x1234 = (x123 + x234) / 2.0;
        double y12 = (y1 + y2) / 2.0;
        double y23 = (y2 + y3) / 2.0;
        double y123 = (y12 + y23) / 2.0;
        double y34 = (y3 + y4) / 2.0;
        double y234 = (y23 + y34) / 2.0;
        double y1234 = (y123 + y234) / 2.0;
        if (this.checkPoint(x1234, y1234)) {
            return true;
        }
        if (depth <= 0) {
            return false;
        }
        return this.checkCurve(x1, y1, x12, y12, x123, y123, x1234, y1234, depth - 1) || this.checkCurve(x1234, y1234, x234, y234, x34, y34, x4, y4, depth - 1);
    }
}

