/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.lakewalker.DoubleConfigurer;
import org.openstreetmap.josm.plugins.lakewalker.IntConfigurer;
import org.openstreetmap.josm.plugins.lakewalker.StringConfigurer;
import org.openstreetmap.josm.plugins.lakewalker.StringEnumConfigurer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class LakewalkerPreferences
extends DefaultTabPreferenceSetting {
    public static final String[] DIRECTIONS = new String[]{I18n.marktr((String)"east"), I18n.marktr((String)"northeast"), I18n.marktr((String)"north"), I18n.marktr((String)"northwest"), I18n.marktr((String)"west"), I18n.marktr((String)"southwest"), I18n.marktr((String)"south"), I18n.marktr((String)"southeast")};
    public static final String[] WAYTYPES = new String[]{I18n.marktr((String)"water"), I18n.marktr((String)"coastline"), I18n.marktr((String)"land"), I18n.marktr((String)"none")};
    public static final String[] WMSLAYERS = new String[]{"IR1", "IR2", "IR3"};
    public static final String PREF_MAX_SEG = "lakewalker.max_segs_in_way";
    public static final String PREF_MAX_NODES = "lakewalker.max_nodes";
    public static final String PREF_THRESHOLD_VALUE = "lakewalker.thresholdvalue";
    public static final String PREF_EPSILON = "lakewalker.epsilon";
    public static final String PREF_LANDSAT_RES = "lakewalker.landsat_res";
    public static final String PREF_LANDSAT_SIZE = "lakewalker.landsat_size";
    public static final String PREF_EAST_OFFSET = "lakewalker.east_offset";
    public static final String PREF_NORTH_OFFSET = "lakewalker.north_offset";
    public static final String PREF_START_DIR = "lakewalker.startdir";
    public static final String PREF_WAYTYPE = "lakewalker.waytype";
    public static final String PREF_WMS = "lakewalker.wms";
    public static final String PREF_SOURCE = "lakewalker.source";
    public static final String PREF_MAXCACHESIZE = "lakewalker.maxcachesize";
    public static final String PREF_MAXCACHEAGE = "lakewalker.maxcacheage";
    protected IntConfigurer maxSegsConfig = new IntConfigurer();
    protected JLabel maxSegsLabel = new JLabel(I18n.tr((String)"Maximum number of segments per way", (Object[])new Object[0]));
    protected IntConfigurer maxNodesConfig = new IntConfigurer();
    protected JLabel maxNodesLabel = new JLabel(I18n.tr((String)"Maximum number of nodes in initial trace", (Object[])new Object[0]));
    protected IntConfigurer thresholdConfig = new IntConfigurer();
    protected JLabel thresholdLabel = new JLabel(I18n.tr((String)"Maximum gray value to count as water (0-255)", (Object[])new Object[0]));
    protected DoubleConfigurer epsilonConfig = new DoubleConfigurer();
    protected JLabel epsilonLabel = new JLabel(I18n.tr((String)"Line simplification accuracy (degrees)", (Object[])new Object[0]));
    protected IntConfigurer landsatResConfig = new IntConfigurer();
    protected JLabel landsatResLabel = new JLabel(I18n.tr((String)"Resolution of Landsat tiles (pixels per degree)", (Object[])new Object[0]));
    protected IntConfigurer landsatSizeConfig = new IntConfigurer();
    protected JLabel landsatSizeLabel = new JLabel(I18n.tr((String)"Size of Landsat tiles (pixels)", (Object[])new Object[0]));
    protected DoubleConfigurer eastOffsetConfig = new DoubleConfigurer();
    protected JLabel eastOffsetLabel = new JLabel(I18n.tr((String)"Shift all traces to east (degrees)", (Object[])new Object[0]));
    protected DoubleConfigurer northOffsetConfig = new DoubleConfigurer();
    protected JLabel northOffsetLabel = new JLabel(I18n.tr((String)"Shift all traces to north (degrees)", (Object[])new Object[0]));
    protected StringEnumConfigurer startDirConfig = new StringEnumConfigurer(DIRECTIONS);
    protected JLabel startDirLabel = new JLabel(I18n.tr((String)"Direction to search for land", (Object[])new Object[0]));
    protected StringEnumConfigurer lakeTypeConfig = new StringEnumConfigurer(WAYTYPES);
    protected JLabel lakeTypeLabel = new JLabel(I18n.tr((String)"Tag ways as", (Object[])new Object[0]));
    protected StringEnumConfigurer wmsConfig = new StringEnumConfigurer(WMSLAYERS);
    protected JLabel wmsLabel = new JLabel(I18n.tr((String)"WMS Layer", (Object[])new Object[0]));
    protected IntConfigurer maxCacheSizeConfig = new IntConfigurer();
    protected JLabel maxCacheSizeLabel = new JLabel(I18n.tr((String)"Maximum cache size (MB)", (Object[])new Object[0]));
    protected IntConfigurer maxCacheAgeConfig = new IntConfigurer();
    protected JLabel maxCacheAgeLabel = new JLabel(I18n.tr((String)"Maximum cache age (days)", (Object[])new Object[0]));
    protected StringConfigurer sourceConfig = new StringConfigurer();
    protected JLabel sourceLabel = new JLabel(I18n.tr((String)"Source text", (Object[])new Object[0]));

    public LakewalkerPreferences() {
        super("lakewalker.png", I18n.tr((String)"Lakewalker Plugin Preferences", (Object[])new Object[0]), I18n.tr((String)"A plugin to trace water bodies on Landsat imagery.", (Object[])new Object[0]));
    }

    public void addGui(PreferenceTabbedPane gui) {
        this.maxSegsConfig.setToolTipText(I18n.tr((String)"Maximum number of segments allowed in each generated way. Default 250.", (Object[])new Object[0]));
        this.maxNodesConfig.setToolTipText(I18n.tr((String)"Maximum number of nodes to generate before bailing out (before simplifying lines). Default 50000.", (Object[])new Object[0]));
        this.thresholdConfig.setToolTipText(I18n.tr((String)"Maximum gray value to accept as water (based on Landsat IR-1 data). Can be in the range 0-255. Default 90.", (Object[])new Object[0]));
        this.epsilonConfig.setToolTipText("<html>" + I18n.tr((String)"Accuracy of Douglas-Peucker line simplification, measured in degrees.<br>Lower values give more nodes, and more accurate lines. Default 0.0003.", (Object[])new Object[0]) + "</html>");
        this.landsatResConfig.setToolTipText(I18n.tr((String)"Resolution of Landsat tiles, measured in pixels per degree. Default 4000.", (Object[])new Object[0]));
        this.landsatSizeConfig.setToolTipText(I18n.tr((String)"Size of one landsat tile, measured in pixels. Default 2000.", (Object[])new Object[0]));
        this.eastOffsetConfig.setToolTipText(I18n.tr((String)"Offset all points in East direction (degrees). Default 0.", (Object[])new Object[0]));
        this.northOffsetConfig.setToolTipText(I18n.tr((String)"Offset all points in North direction (degrees). Default 0.", (Object[])new Object[0]));
        this.startDirConfig.setToolTipText(I18n.tr((String)"Direction to search for land. Default east.", (Object[])new Object[0]));
        this.lakeTypeConfig.setToolTipText(I18n.tr((String)"Tag ways as water, coastline, land or nothing. Default is water.", (Object[])new Object[0]));
        this.wmsConfig.setToolTipText(I18n.tr((String)"Which WMS layer to use for tracing against. Default is IR1.", (Object[])new Object[0]));
        this.maxCacheSizeConfig.setToolTipText(I18n.tr((String)"Maximum size of each cache directory in bytes. Default is 300MB", (Object[])new Object[0]));
        this.maxCacheAgeConfig.setToolTipText(I18n.tr((String)"Maximum age of each cached file in days. Default is 100", (Object[])new Object[0]));
        this.sourceConfig.setToolTipText(I18n.tr((String)"Data source text. Default is Landsat.", (Object[])new Object[0]));
        I18n.tr((String)"A plugin to trace water bodies on Landsat imagery.", (Object[])new Object[0]);
        PreferenceTabbedPane.PreferencePanel prefPanel = gui.createPreferenceTab((TabPreferenceSetting)this);
        this.buildPreferences((JPanel)prefPanel);
        this.maxSegsConfig.setValue(Main.pref.getInteger(PREF_MAX_SEG, 500));
        this.maxNodesConfig.setValue(Main.pref.getInteger(PREF_MAX_NODES, 50000));
        this.thresholdConfig.setValue(Main.pref.getInteger(PREF_THRESHOLD_VALUE, 90));
        this.epsilonConfig.setValue(Main.pref.getDouble(PREF_EPSILON, 3.0E-4));
        this.landsatResConfig.setValue(Main.pref.getInteger(PREF_LANDSAT_RES, 4000));
        this.landsatSizeConfig.setValue(Main.pref.getInteger(PREF_LANDSAT_SIZE, 2000));
        this.eastOffsetConfig.setValue(Main.pref.getDouble(PREF_EAST_OFFSET, 0.0));
        this.northOffsetConfig.setValue(Main.pref.getDouble(PREF_NORTH_OFFSET, 0.0));
        this.startDirConfig.setValue(Main.pref.get(PREF_START_DIR, "east"));
        this.lakeTypeConfig.setValue(Main.pref.get(PREF_WAYTYPE, "water"));
        this.wmsConfig.setValue(Main.pref.get(PREF_WMS, "IR1"));
        this.sourceConfig.setValue(Main.pref.get(PREF_SOURCE, "Landsat"));
        this.maxCacheSizeConfig.setValue(Main.pref.getInteger(PREF_MAXCACHESIZE, 300));
        this.maxCacheAgeConfig.setValue(Main.pref.getInteger(PREF_MAXCACHEAGE, 100));
    }

    public void buildPreferences(JPanel prefPanel) {
        GBC labelConstraints = GBC.std().insets(10, 5, 5, 0);
        GBC dataConstraints = GBC.eol().insets(0, 5, 0, 0).fill(2);
        prefPanel.add((Component)this.maxSegsLabel, labelConstraints);
        prefPanel.add(this.maxSegsConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.maxNodesLabel, labelConstraints);
        prefPanel.add(this.maxNodesConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.thresholdLabel, labelConstraints);
        prefPanel.add(this.thresholdConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.epsilonLabel, labelConstraints);
        prefPanel.add(this.epsilonConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.landsatResLabel, labelConstraints);
        prefPanel.add(this.landsatResConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.landsatSizeLabel, labelConstraints);
        prefPanel.add(this.landsatSizeConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.eastOffsetLabel, labelConstraints);
        prefPanel.add(this.eastOffsetConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.northOffsetLabel, labelConstraints);
        prefPanel.add(this.northOffsetConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.startDirLabel, labelConstraints);
        prefPanel.add(this.startDirConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.lakeTypeLabel, labelConstraints);
        prefPanel.add(this.lakeTypeConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.wmsLabel, labelConstraints);
        prefPanel.add(this.wmsConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.maxCacheSizeLabel, labelConstraints);
        prefPanel.add(this.maxCacheSizeConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.maxCacheAgeLabel, labelConstraints);
        prefPanel.add(this.maxCacheAgeConfig.getControls(), dataConstraints);
        prefPanel.add((Component)this.sourceLabel, labelConstraints);
        prefPanel.add(this.sourceConfig.getControls(), dataConstraints);
        prefPanel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    public boolean ok() {
        Main.pref.put(PREF_MAX_SEG, this.maxSegsConfig.getValueString());
        Main.pref.put(PREF_MAX_NODES, this.maxNodesConfig.getValueString());
        Main.pref.put(PREF_THRESHOLD_VALUE, this.thresholdConfig.getValueString());
        Main.pref.put(PREF_EPSILON, this.epsilonConfig.getValueString());
        Main.pref.put(PREF_LANDSAT_RES, this.landsatResConfig.getValueString());
        Main.pref.put(PREF_LANDSAT_SIZE, this.landsatSizeConfig.getValueString());
        Main.pref.put(PREF_EAST_OFFSET, this.eastOffsetConfig.getValueString());
        Main.pref.put(PREF_NORTH_OFFSET, this.northOffsetConfig.getValueString());
        Main.pref.put(PREF_START_DIR, this.startDirConfig.getValueString());
        Main.pref.put(PREF_WAYTYPE, this.lakeTypeConfig.getValueString());
        Main.pref.put(PREF_WMS, this.wmsConfig.getValueString());
        Main.pref.put(PREF_MAXCACHESIZE, this.maxCacheSizeConfig.getValueString());
        Main.pref.put(PREF_MAXCACHEAGE, this.maxCacheAgeConfig.getValueString());
        Main.pref.put(PREF_SOURCE, this.sourceConfig.getValueString());
        return false;
    }
}

