/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AreaPtgBase;
import org.apache.poi.hssf.record.formula.OperandPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.hssf.record.formula.RefPtgBase;
import org.apache.poi.hssf.util.CellRangeAddress8Bit;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class SharedFormulaRecord
extends SharedValueRecordBase {
    public static final short sid = 1212;
    private int field_5_reserved;
    private Formula field_7_parsed_expr;

    public SharedFormulaRecord() {
        this(new CellRangeAddress8Bit(0, 0, 0, 0));
    }

    private SharedFormulaRecord(CellRangeAddress8Bit cellRangeAddress8Bit) {
        super(cellRangeAddress8Bit);
        this.field_7_parsed_expr = Formula.create(Ptg.EMPTY_PTG_ARRAY);
    }

    public SharedFormulaRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this.field_5_reserved = recordInputStream.readShort();
        short s = recordInputStream.readShort();
        int n = recordInputStream.available();
        this.field_7_parsed_expr = Formula.read(s, recordInputStream, n);
    }

    @Override
    protected void serializeExtraData(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_5_reserved);
        this.field_7_parsed_expr.serialize(littleEndianOutput);
    }

    @Override
    protected int getExtraDataSize() {
        return 2 + this.field_7_parsed_expr.getEncodedSize();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SHARED FORMULA (").append(HexDump.intToHex(1212)).append("]\n");
        stringBuffer.append("    .range      = ").append(this.getRange().toString()).append("\n");
        stringBuffer.append("    .reserved    = ").append(HexDump.shortToHex(this.field_5_reserved)).append("\n");
        Ptg[] ptgArray = this.field_7_parsed_expr.getTokens();
        for (int i = 0; i < ptgArray.length; ++i) {
            stringBuffer.append("Formula[").append(i).append("]");
            Ptg ptg = ptgArray[i];
            stringBuffer.append(ptg.toString()).append(ptg.getRVAType()).append("\n");
        }
        stringBuffer.append("[/SHARED FORMULA]\n");
        return stringBuffer.toString();
    }

    @Override
    public short getSid() {
        return 1212;
    }

    public static Ptg[] convertSharedFormulas(Ptg[] ptgArray, int n, int n2) {
        Ptg[] ptgArray2 = new Ptg[ptgArray.length];
        for (int i = 0; i < ptgArray.length; ++i) {
            OperandPtg operandPtg;
            Ptg ptg = ptgArray[i];
            byte by = -1;
            if (!ptg.isBaseToken()) {
                by = ptg.getPtgClass();
            }
            if (ptg instanceof RefPtgBase) {
                operandPtg = (RefPtgBase)ptg;
                ptg = new RefPtg(SharedFormulaRecord.fixupRelativeRow(n, ((RefPtgBase)operandPtg).getRow(), ((RefPtgBase)operandPtg).isRowRelative()), SharedFormulaRecord.fixupRelativeColumn(n2, ((RefPtgBase)operandPtg).getColumn(), ((RefPtgBase)operandPtg).isColRelative()), ((RefPtgBase)operandPtg).isRowRelative(), ((RefPtgBase)operandPtg).isColRelative());
                ptg.setClass(by);
            } else if (ptg instanceof AreaPtgBase) {
                operandPtg = (AreaPtgBase)ptg;
                ptg = new AreaPtg(SharedFormulaRecord.fixupRelativeRow(n, ((AreaPtgBase)operandPtg).getFirstRow(), ((AreaPtgBase)operandPtg).isFirstRowRelative()), SharedFormulaRecord.fixupRelativeRow(n, ((AreaPtgBase)operandPtg).getLastRow(), ((AreaPtgBase)operandPtg).isLastRowRelative()), SharedFormulaRecord.fixupRelativeColumn(n2, ((AreaPtgBase)operandPtg).getFirstColumn(), ((AreaPtgBase)operandPtg).isFirstColRelative()), SharedFormulaRecord.fixupRelativeColumn(n2, ((AreaPtgBase)operandPtg).getLastColumn(), ((AreaPtgBase)operandPtg).isLastColRelative()), ((AreaPtgBase)operandPtg).isFirstRowRelative(), ((AreaPtgBase)operandPtg).isLastRowRelative(), ((AreaPtgBase)operandPtg).isFirstColRelative(), ((AreaPtgBase)operandPtg).isLastColRelative());
                ptg.setClass(by);
            } else if (ptg instanceof OperandPtg) {
                ptg = ((OperandPtg)ptg).copy();
            }
            ptgArray2[i] = ptg;
        }
        return ptgArray2;
    }

    public Ptg[] getFormulaTokens(FormulaRecord formulaRecord) {
        short s;
        int n = formulaRecord.getRow();
        if (!this.isInRange(n, s = formulaRecord.getColumn())) {
            throw new RuntimeException("Shared Formula Conversion: Coding Error");
        }
        return SharedFormulaRecord.convertSharedFormulas(this.field_7_parsed_expr.getTokens(), n, s);
    }

    private static int fixupRelativeColumn(int n, int n2, boolean bl) {
        if (bl) {
            return n2 + n & 0xFF;
        }
        return n2;
    }

    private static int fixupRelativeRow(int n, int n2, boolean bl) {
        if (bl) {
            return n2 + n & 0xFFFF;
        }
        return n2;
    }

    @Override
    public Object clone() {
        SharedFormulaRecord sharedFormulaRecord = new SharedFormulaRecord(this.getRange());
        sharedFormulaRecord.field_5_reserved = this.field_5_reserved;
        sharedFormulaRecord.field_7_parsed_expr = this.field_7_parsed_expr.copy();
        return sharedFormulaRecord;
    }
}

