/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmobjinfo;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OSMObjInfoActions {
    public static void copyUser(String user) {
        if (!user.isEmpty()) {
            String linkUser = "http://www.openstreetmap.org/user/" + user;
            StringSelection selection = new StringSelection(linkUser);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
            new Notification(I18n.tr((String)("Copy: " + linkUser), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
        }
    }

    public static void openinBrowserUser(String user) {
        if (!user.isEmpty()) {
            String url = "http://www.openstreetmap.org/user/" + user;
            new Notification(I18n.tr((String)("Open in browser " + url), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            OpenBrowser.displayUrl((String)url);
        }
    }

    public static void openinBrowserUserNeis(String user) {
        if (!user.isEmpty()) {
            String url = "http://hdyc.neis-one.org/?" + user;
            new Notification(I18n.tr((String)("Open in browser " + url), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            OpenBrowser.displayUrl((String)url);
        }
    }

    static void openinBrowserUserOsmComments(String user) {
        if (!user.isEmpty()) {
            String url = "https://www.mapbox.com/osm-comments/#/changesets/?q=users:" + user;
            new Notification(I18n.tr((String)("Open in browser " + url), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            OpenBrowser.displayUrl((String)url);
        }
    }

    public static void copyChangeset(String idChangeset) {
        if (!idChangeset.isEmpty()) {
            String linkchangeset = "https://www.openstreetmap.org/changeset/" + idChangeset;
            StringSelection selection = new StringSelection(linkchangeset);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
            new Notification(I18n.tr((String)("Copy: " + linkchangeset), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
        }
    }

    public static void openinBrowserChangeset(String idChangeset) {
        if (!idChangeset.isEmpty()) {
            String url = "https://www.openstreetmap.org/changeset/" + idChangeset;
            new Notification(I18n.tr((String)("Open in browser " + url), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            OpenBrowser.displayUrl((String)url);
        }
    }

    public static void openinBrowserChangesetMap(String idChangeset) {
        if (!idChangeset.isEmpty()) {
            String url = "https://osmcha.mapbox.com/" + idChangeset;
            new Notification(I18n.tr((String)("Open in browser " + url), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            OpenBrowser.displayUrl((String)url);
        }
    }

    public static void copyIdobj(String typeObj, String idobj) {
        if (typeObj != null && !idobj.isEmpty()) {
            String linkobjid = "https://www.openstreetmap.org/" + typeObj + "/" + idobj;
            StringSelection selection = new StringSelection(linkobjid);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
            new Notification(I18n.tr((String)("Copy: " + linkobjid), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
        }
    }

    public static void openinBrowserIdobj(String typeObj, String idobj) {
        if (typeObj != null && !idobj.isEmpty()) {
            String url = "https://www.openstreetmap.org/" + typeObj + "/" + idobj;
            new Notification(I18n.tr((String)("Open in browser " + url), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            OpenBrowser.displayUrl((String)url);
        }
    }

    public static void openinBrowserIdobjOsmDeepHistory(String typeObj, String idobj) {
        if (typeObj != null && !idobj.isEmpty()) {
            String url = "http://osmlab.github.io/osm-deep-history/#/" + typeObj + "/" + idobj;
            new Notification(I18n.tr((String)("Open in browser " + url), (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            OpenBrowser.displayUrl((String)url);
        }
    }
}

