/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix.controller;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.openstreetmap.josm.plugins.tofix.bean.ListTaskBean;
import org.openstreetmap.josm.plugins.tofix.bean.TaskBean;
import org.openstreetmap.josm.plugins.tofix.util.Request;

public class ListTaskController {
    private ListTaskBean listTasksBean = new ListTaskBean();
    private String url = "https://build-to-fix-production.mapbox.com/tasks";

    public ListTaskBean getListTasksBean() {
        LinkedList<TaskBean> tasks = new LinkedList<TaskBean>();
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(Request.sendGET(this.url)));){
            JsonObject jsonObject = jsonReader.readObject();
            JsonArray jsonArray = jsonObject.getJsonArray("tasks");
            for (JsonValue value : jsonArray) {
                TaskBean taskBean = new TaskBean();
                try (JsonReader jsonReader2 = Json.createReader((Reader)new StringReader(value.toString()));){
                    JsonObject jsontask = jsonReader2.readObject();
                    JsonObject value_jsontask = (JsonObject)jsontask.get((Object)"value");
                    JsonObject stats_jsontask = (JsonObject)value_jsontask.get((Object)"stats");
                    taskBean.setIdtask(jsontask.getString("idtask"));
                    taskBean.setIsCompleted(jsontask.getBoolean("isCompleted"));
                    taskBean.setIsAllItemsLoad(jsontask.getBoolean("isAllItemsLoad"));
                    taskBean.setName(value_jsontask.getString("name"));
                    taskBean.setDescription(value_jsontask.getString("description"));
                    taskBean.setUpdated(value_jsontask.getJsonNumber("updated").toString());
                    taskBean.setChangesetComment(value_jsontask.getString("changesetComment"));
                    taskBean.setDate(stats_jsontask.getJsonNumber("date").toString());
                    taskBean.setEdit(Integer.parseInt(stats_jsontask.getJsonNumber("edit").toString()));
                    taskBean.setFixed(Integer.parseInt(stats_jsontask.getJsonNumber("fixed").toString()));
                    taskBean.setSkip(Integer.parseInt(stats_jsontask.getJsonNumber("skip").toString()));
                    taskBean.setItems(Integer.parseInt(stats_jsontask.getJsonNumber("items").toString()));
                    taskBean.setNoterror(Integer.parseInt(stats_jsontask.getJsonNumber("noterror").toString()));
                }
                tasks.add(taskBean);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ListTaskController.class.getName()).log(Level.SEVERE, null, ex);
        }
        Collections.sort(tasks, new Comparator<TaskBean>(){

            @Override
            public int compare(TaskBean o1, TaskBean o2) {
                return Collator.getInstance().compare(o1.getName(), o2.getName());
            }
        });
        this.listTasksBean.setTasks(tasks);
        return this.listTasksBean;
    }
}

