/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.print;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class PrintableLayerManager
extends MainLayerManager {
    private static final MainLayerManager layerManager = Main.getLayerManager();

    public synchronized void removeActiveLayerChangeListener(MainLayerManager.ActiveLayerChangeListener listener) {
        layerManager.removeActiveLayerChangeListener(listener);
    }

    public void setActiveLayer(Layer layer) {
        layerManager.setActiveLayer(layer);
    }

    public synchronized Layer getActiveLayer() {
        return layerManager.getActiveLayer();
    }

    public synchronized OsmDataLayer getEditLayer() {
        return layerManager.getEditLayer();
    }

    public synchronized DataSet getEditDataSet() {
        return layerManager.getEditDataSet();
    }

    public synchronized List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer l : layerManager.getLayers()) {
            if (!l.isVisible()) continue;
            layers.add(l);
        }
        Collections.sort(layers, new Comparator<Layer>(){

            @Override
            public int compare(Layer l2, Layer l1) {
                if (l1 instanceof OsmDataLayer && l2 instanceof OsmDataLayer) {
                    if (l1 == layerManager.getActiveLayer()) {
                        return -1;
                    }
                    if (l2 == layerManager.getActiveLayer()) {
                        return 1;
                    }
                    return Integer.valueOf(layerManager.getLayers().indexOf(l1)).compareTo(layerManager.getLayers().indexOf(l2));
                }
                return Integer.valueOf(layerManager.getLayers().indexOf(l1)).compareTo(layerManager.getLayers().indexOf(l2));
            }
        });
        return layers;
    }

    public void addLayer(Layer layer) {
        layerManager.addLayer(layer);
    }

    public void removeLayer(Layer layer) {
        layerManager.removeLayer(layer);
    }

    public void moveLayer(Layer layer, int position) {
        layerManager.moveLayer(layer, position);
    }

    public List<Layer> getLayers() {
        return layerManager.getLayers();
    }

    public <T extends Layer> List<T> getLayersOfType(Class<T> ofType) {
        return layerManager.getLayersOfType(ofType);
    }

    public synchronized boolean containsLayer(Layer layer) {
        return layerManager.containsLayer(layer);
    }

    public synchronized void addLayerChangeListener(LayerManager.LayerChangeListener listener) {
        layerManager.addLayerChangeListener(listener);
    }

    public synchronized void addLayerChangeListener(LayerManager.LayerChangeListener listener, boolean fireAdd) {
        layerManager.addLayerChangeListener(listener, fireAdd);
    }

    public synchronized void removeLayerChangeListener(LayerManager.LayerChangeListener listener) {
        layerManager.removeLayerChangeListener(listener);
    }

    public synchronized void removeLayerChangeListener(LayerManager.LayerChangeListener listener, boolean fireRemove) {
        layerManager.removeLayerChangeListener(listener, fireRemove);
    }
}

