/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wikipedia.data.WikidataEntry;
import org.wikipedia.data.WikipediaEntry;
import org.wikipedia.tools.XPath;

public final class WikipediaApp {
    public static final Pattern WIKIDATA_PATTERN = Pattern.compile("Q\\d+");
    private static final XPath X_PATH = XPath.getInstance();
    private final String wikipediaLang;

    private WikipediaApp(String wikipediaLang) {
        this.wikipediaLang = wikipediaLang;
    }

    public static WikipediaApp forLanguage(String wikipediaLang) {
        return new WikipediaApp(wikipediaLang);
    }

    static String getMediawikiLocale(Locale locale) {
        if (!locale.getCountry().isEmpty()) {
            return locale.getLanguage() + "-" + locale.getCountry().toLowerCase();
        }
        return locale.getLanguage();
    }

    public String getSiteUrl() {
        if ("wikidata".equals(this.wikipediaLang)) {
            return "https://www.wikidata.org";
        }
        return "https://" + this.wikipediaLang + ".wikipedia.org";
    }

    private static HttpClient.Response connect(String url) throws IOException {
        HttpClient.Response response = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect();
        if (response.getResponseCode() != 200) {
            throw new IOException("Server responded with HTTP " + response.getResponseCode());
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WikipediaEntry> getEntriesFromCoordinates(LatLon min, LatLon max) {
        try {
            String url = this.getSiteUrl() + "/w/api.php" + "?action=query" + "&list=geosearch" + "&format=xml" + "&gslimit=500" + "&gsbbox=" + max.lat() + "|" + min.lon() + "|" + min.lat() + "|" + max.lon();
            try (InputStream in = WikipediaApp.connect(url).getContent();){
                Document doc = WikipediaApp.newDocumentBuilder().parse(in);
                List<WikipediaEntry> entries = X_PATH.evaluateNodes("//gs", doc).stream().map(node -> {
                    String name = X_PATH.evaluateString("@title", node);
                    LatLon latLon = new LatLon(X_PATH.evaluateDouble("@lat", node), X_PATH.evaluateDouble("@lon", node));
                    if ("wikidata".equals(this.wikipediaLang)) {
                        return new WikidataEntry(name, null, latLon, null);
                    }
                    return new WikipediaEntry(this.wikipediaLang, name, latLon);
                }).collect(Collectors.toList());
                if ("wikidata".equals(this.wikipediaLang)) {
                    List<WikipediaEntry> list = WikipediaApp.getLabelForWikidata(entries, Locale.getDefault(), new String[0]).stream().collect(Collectors.toList());
                    return list;
                }
                List<WikipediaEntry> list = entries;
                return list;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<WikidataEntry> getWikidataEntriesForQuery(String languageForQuery, String query, Locale localeForLabels) {
        try {
            String url = "https://www.wikidata.org/w/api.php?action=wbsearchentities&language=" + languageForQuery + "&strictlanguage=false" + "&search=" + Utils.encodeUrl((String)query) + "&limit=50" + "&format=xml";
            try (InputStream in = WikipediaApp.connect(url).getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                List r = X_PATH.evaluateNodes("//entity", xml).stream().map(node -> new WikidataEntry(X_PATH.evaluateString("@id", node), null, null, null)).collect(Collectors.toList());
                List<WikidataEntry> list = WikipediaApp.getLabelForWikidata(r, localeForLabels, new String[0]);
                return list;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<WikipediaEntry> getEntriesFromCategory(String category, int depth) {
        try {
            String url = "https://tools.wmflabs.org/cats-php/?lang=" + this.wikipediaLang + "&depth=" + depth + "&cat=" + Utils.encodeUrl((String)category);
            try (BufferedReader reader = WikipediaApp.connect(url).getContentReader();){
                List<WikipediaEntry> list = reader.lines().map(line -> new WikipediaEntry(this.wikipediaLang, line.trim().replace("_", " "))).collect(Collectors.toList());
                return list;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<WikipediaEntry> getEntriesFromClipboard(String wikipediaLang) {
        return Pattern.compile("[\\n\\r]+").splitAsStream(ClipboardUtils.getClipboardStringContent()).map(x -> new WikipediaEntry(wikipediaLang, (String)x)).collect(Collectors.toList());
    }

    public void updateWIWOSMStatus(List<WikipediaEntry> entries) {
        if (entries.size() > 20) {
            WikipediaApp.partitionList(entries, 20).forEach(chunk -> this.updateWIWOSMStatus((List<WikipediaEntry>)chunk));
            return;
        }
        HashMap status = new HashMap();
        if (!entries.isEmpty()) {
            String url = "https://tools.wmflabs.org/wiwosm/osmjson/getGeoJSON.php?action=check&lang=" + this.wikipediaLang;
            try {
                String articles = entries.stream().map(i -> i.article).collect(Collectors.joining(","));
                String requestBody = "articles=" + Utils.encodeUrl((String)articles);
                try (BufferedReader reader = HttpClient.create((URL)new URL(url), (String)"POST").setReasonForRequest("Wikipedia").setHeader("Content-Type", "application/x-www-form-urlencoded").setRequestBody(requestBody.getBytes(StandardCharsets.UTF_8)).connect().getContentReader();){
                    reader.lines().forEach(line -> {
                        String[] x = line.split("\t");
                        if (x.length == 2) {
                            status.put(x[0], "1".equals(x[1]));
                        } else {
                            Main.error((String)("Unknown element " + line));
                        }
                    });
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        for (WikipediaEntry i2 : entries) {
            i2.setWiwosmStatus((Boolean)status.get(i2.article));
        }
    }

    public Stream<String> getWikipediaArticles(OsmPrimitive p) {
        if ("wikidata".equals(this.wikipediaLang)) {
            return Stream.of(p.get("wikidata")).filter(Objects::nonNull);
        }
        return Stream.of("wikipedia", "wikipedia:" + this.wikipediaLang).map(key -> WikipediaEntry.parseTag(key, p.get(key))).filter(Objects::nonNull).filter(wp -> this.wikipediaLang.equals(wp.lang)).map(wp -> wp.article);
    }

    public Map<String, String> getWikidataForArticles(Collection<String> articles) {
        return articles.stream().distinct().collect(Collectors.groupingBy(new Function<String, Integer>(){
            final AtomicInteger group = new AtomicInteger();
            final AtomicInteger count = new AtomicInteger();
            final AtomicInteger length = new AtomicInteger();

            @Override
            public Integer apply(String o) {
                if (this.count.incrementAndGet() > 50 || this.length.addAndGet(Utils.encodeUrl((String)o).length()) > 2048) {
                    this.count.set(0);
                    this.length.set(0);
                    return this.group.incrementAndGet();
                }
                return this.group.get();
            }
        })).values().stream().flatMap(chunk -> this.resolveWikidataItems((Collection<String>)chunk).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, String> resolveWikidataItems(Collection<String> articles) {
        Map<String, String> result = this.getWikidataForArticles0(articles);
        List<String> unresolved = articles.stream().filter(title -> !result.containsKey(title)).collect(Collectors.toList());
        if (!unresolved.isEmpty()) {
            Map<String, String> redirects = this.resolveRedirectsForArticles(unresolved);
            Map<String, String> result2 = this.getWikidataForArticles0(redirects.values());
            redirects.forEach((original, resolved) -> {
                if (result2.containsKey(resolved)) {
                    result.put((String)original, (String)result2.get(resolved));
                }
            });
        }
        return result;
    }

    private Map<String, String> getWikidataForArticles0(Collection<String> articles) {
        if (articles.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=sitelinks&sites=" + this.wikipediaLang + "wiki" + "&sitefilter=" + this.wikipediaLang + "wiki" + "&format=xml" + "&titles=" + articles.stream().map(Utils::encodeUrl).collect(Collectors.joining("|"));
            TreeMap<String, String> r = new TreeMap<String, String>();
            try (InputStream in = WikipediaApp.connect(url).getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                X_PATH.evaluateNodes("//entity", xml).forEach(node -> {
                    String wikidata = X_PATH.evaluateString("./@id", node);
                    String wikipedia = X_PATH.evaluateString("./sitelinks/sitelink/@title", node);
                    if (WIKIDATA_PATTERN.matcher(wikidata).matches()) {
                        r.put(wikipedia, wikidata);
                    }
                });
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> resolveRedirectsForArticles(Collection<String> articles) {
        try {
            String url = this.getSiteUrl() + "/w/api.php" + "?action=query" + "&redirects" + "&format=xml" + "&titles=" + articles.stream().map(Utils::encodeUrl).collect(Collectors.joining("|"));
            try (InputStream in = WikipediaApp.connect(url).getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                Collector<Node, ?, Map<String, String>> fromToCollector = Collectors.toMap(node -> X_PATH.evaluateString("./@from", node), node -> X_PATH.evaluateString("./@to", node));
                Map<String, String> normalized = X_PATH.evaluateNodes("//normalized/n", xml).stream().collect(fromToCollector);
                Map<String, String> redirects = X_PATH.evaluateNodes("//redirects/r", xml).stream().collect(fromToCollector);
                Map<String, String> map = articles.stream().collect(Collectors.toMap(Function.identity(), title -> {
                    String normalizedTitle = normalized.getOrDefault(title, (String)title);
                    return redirects.getOrDefault(normalizedTitle, normalizedTitle);
                }));
                return map;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getCategoriesForPrefix(String prefix) {
        try {
            String url = this.getSiteUrl() + "/w/api.php" + "?action=query" + "&list=prefixsearch" + "&format=xml" + "&psnamespace=14" + "&pslimit=50" + "&pssearch=" + Utils.encodeUrl((String)prefix);
            try (InputStream in = WikipediaApp.connect(url).getContent();){
                Document doc = WikipediaApp.newDocumentBuilder().parse(in);
                List<String> list = X_PATH.evaluateNodes("//ps/@title", doc).stream().map(Node::getNodeValue).map(value -> value.contains(":") ? value.split(":", 2)[1] : value).collect(Collectors.toList());
                return list;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getLabelForWikidata(String wikidataId, Locale locale, String ... preferredLanguage) {
        try {
            List<WikidataEntry> entry = Collections.singletonList(new WikidataEntry(wikidataId, null, null, null));
            return WikipediaApp.getLabelForWikidata(entry, (Locale)locale, (String[])preferredLanguage).get((int)0).label;
        }
        catch (IndexOutOfBoundsException ignore) {
            return null;
        }
    }

    static List<WikidataEntry> getLabelForWikidata(List<? extends WikipediaEntry> entries, Locale locale, String ... preferredLanguage) {
        if (entries.size() > 50) {
            return WikipediaApp.partitionList(entries, 50).stream().flatMap(chunk -> WikipediaApp.getLabelForWikidata(chunk, locale, preferredLanguage).stream()).collect(Collectors.toList());
        }
        if (entries.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=labels|descriptions&ids=" + entries.stream().map(x -> x.article).collect(Collectors.joining("|")) + "&format=xml";
            ArrayList<String> languages = new ArrayList<String>();
            if (locale != null) {
                languages.add(WikipediaApp.getMediawikiLocale(locale));
                languages.add(WikipediaApp.getMediawikiLocale(new Locale(locale.getLanguage())));
            }
            languages.addAll(Arrays.asList(preferredLanguage));
            languages.add("en");
            languages.add(null);
            ArrayList<WikidataEntry> r = new ArrayList<WikidataEntry>(entries.size());
            try (InputStream in = WikipediaApp.connect(url).getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                for (WikipediaEntry wikipediaEntry : entries) {
                    Node entity = X_PATH.evaluateNode("//entity[@id='" + wikipediaEntry.article + "']", xml);
                    if (entity == null) continue;
                    r.add(new WikidataEntry(wikipediaEntry.article, WikipediaApp.getFirstField(languages, "label", entity), wikipediaEntry.coordinate, WikipediaApp.getFirstField(languages, "description", entity)));
                }
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getFirstField(Collection<String> languages, String field, Node entity) {
        return languages.stream().map(language -> X_PATH.evaluateString(language != null ? ".//" + field + "[@language='" + language + "']/@value" : ".//" + field + "/@value", entity)).filter(label -> label != null && !label.isEmpty()).findFirst().orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<WikipediaEntry> getInterwikiArticles(String article) {
        try {
            String url = this.getSiteUrl() + "/w/api.php" + "?action=query" + "&prop=langlinks" + "&titles=" + Utils.encodeUrl((String)article) + "&lllimit=500" + "&format=xml";
            try (InputStream in = WikipediaApp.connect(url).getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                Collection collection = X_PATH.evaluateNodes("//ll", xml).stream().map(node -> {
                    String lang = X_PATH.evaluateString("@lang", node);
                    String name = node.getTextContent();
                    return new WikipediaEntry(lang, name);
                }).collect(Collectors.toList());
                return collection;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LatLon getCoordinateForArticle(String article) {
        try {
            String url = this.getSiteUrl() + "/w/api.php" + "?action=query" + "&prop=coordinates" + "&titles=" + Utils.encodeUrl((String)article) + "&format=xml";
            try (InputStream in = WikipediaApp.connect(url).getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                Node node = X_PATH.evaluateNode("//coordinates/co", xml);
                if (node == null) {
                    LatLon latLon = null;
                    return latLon;
                }
                LatLon latLon = new LatLon(X_PATH.evaluateDouble("@lat", node), X_PATH.evaluateDouble("@lon", node));
                return latLon;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> List<List<T>> partitionList(final List<T> list, final int size) {
        return new AbstractList<List<T>>(){

            @Override
            public List<T> get(int index) {
                int fromIndex = index * size;
                int toIndex = Math.min(fromIndex + size, list.size());
                return list.subList(fromIndex, toIndex);
            }

            @Override
            public int size() {
                return (int)Math.ceil((float)list.size() / (float)size);
            }
        };
    }

    private static DocumentBuilder newDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Main.warn((String)"Cannot create DocumentBuilder");
            Main.warn((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

