/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SelectCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.PTAssistantPlugin;
import org.openstreetmap.josm.plugins.pt_assistant.actions.FixTask;
import org.openstreetmap.josm.plugins.pt_assistant.actions.IncompleteMembersDownloadThread;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteSegment;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.gui.IncompleteMembersDownloadDialog;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayer;
import org.openstreetmap.josm.plugins.pt_assistant.gui.ProceedDialog;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.NodeChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.RouteChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.SegmentChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.StopChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.WayChecker;
import org.openstreetmap.josm.tools.I18n;

public class PTAssistantValidatorTest
extends Test {
    public static final int ERROR_CODE_SORTING = 3711;
    public static final int ERROR_CODE_ROAD_TYPE = 3721;
    public static final int ERROR_CODE_CONSTRUCTION = 3722;
    public static final int ERROR_CODE_DIRECTION = 3731;
    public static final int ERROR_CODE_END_STOP = 3741;
    public static final int ERROR_CODE_SPLIT_WAY = 3742;
    public static final int ERROR_CODE_RELAITON_MEMBER_ROLES = 3743;
    public static final int ERROR_CODE_SOLITARY_STOP_POSITION = 3751;
    public static final int ERROR_CODE_PLATFORM_PART_OF_HIGHWAY = 3752;
    public static final int ERROR_CODE_STOP_NOT_SERVED = 3753;
    public static final int ERROR_CODE_STOP_BY_STOP = 3754;
    public static final int ERROR_CODE_NOT_PART_OF_STOP_AREA = 3761;
    public static final int ERROR_CODE_STOP_AREA_NO_STOPS = 3762;
    public static final int ERROR_CODE_STOP_AREA_NO_PLATFORM = 3763;
    public static final int ERROR_CODE_STOP_AREA_COMPARE_RELATIONS = 3764;
    private PTAssistantLayer layer = PTAssistantLayer.getLayer();

    public PTAssistantValidatorTest() {
        super(I18n.tr((String)"Public Transport Assistant tests", (Object[])new Object[0]), I18n.tr((String)"Check if route relations are compatible with public transport version 2", (Object[])new Object[0]));
        DataSet.addSelectionListener((SelectionChangedListener)this.layer);
    }

    public void visit(Node n) {
        if (n.isIncomplete()) {
            return;
        }
        NodeChecker nodeChecker = new NodeChecker(n, (Test)this);
        if (n.hasTag("public_transport", "stop_position")) {
            nodeChecker.performSolitaryStopPositionTest();
            if (Main.pref.getBoolean("pt_assistant.stop-area-tests", true)) {
                nodeChecker.performNodePartOfStopAreaTest();
            }
        }
        if (n.hasTag("public_transport", "platform")) {
            nodeChecker.performPlatformPartOfWayTest();
            if (Main.pref.getBoolean("pt_assistant.stop-area-tests", true)) {
                nodeChecker.performNodePartOfStopAreaTest();
            }
        }
        this.errors.addAll(nodeChecker.getErrors());
    }

    public void visit(Relation r) {
        boolean downloadSuccessful;
        if (r.hasIncompleteMembers() && !(downloadSuccessful = this.downloadIncompleteMembers())) {
            return;
        }
        if (r.hasIncompleteMembers()) {
            return;
        }
        if (Main.pref.getBoolean("pt_assistant.stop-area-tests", true) && StopUtils.isStopArea(r)) {
            StopChecker stopChecker = new StopChecker(r, (Test)this);
            stopChecker.performStopAreaStopPositionTest();
            stopChecker.performStopAreaPlatformTest();
            stopChecker.performStopAreaRelationsTest();
            this.errors.addAll(stopChecker.getErrors());
        }
        if (!RouteUtils.isTwoDirectionRoute(r)) {
            return;
        }
        WayChecker wayChecker = new WayChecker(r, (Test)this);
        wayChecker.performDirectionTest();
        wayChecker.performRoadTypeTest();
        this.errors.addAll(wayChecker.getErrors());
        this.proceedWithSorting(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadIncompleteMembers() {
        final int[] userSelection = new int[]{0};
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                userSelection[0] = this.showIncompleteMembersDownloadDialog();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            userSelection[0] = PTAssistantValidatorTest.this.showIncompleteMembersDownloadDialog();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            return false;
        }
        if (userSelection[0] == 0) {
            IncompleteMembersDownloadThread t = new IncompleteMembersDownloadThread();
            t.start();
            IncompleteMembersDownloadThread incompleteMembersDownloadThread = t;
            synchronized (incompleteMembersDownloadThread) {
                try {
                    t.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        return true;
    }

    private int showIncompleteMembersDownloadDialog() throws InterruptedException {
        if (Main.pref.getBoolean("pt_assistant.download-incomplete", false)) {
            return 0;
        }
        if (!Main.pref.getBoolean("pt_assistant.download-incomplete", false)) {
            return 1;
        }
        IncompleteMembersDownloadDialog incompleteMembersDownloadDialog = new IncompleteMembersDownloadDialog();
        return incompleteMembersDownloadDialog.getUserSelection();
    }

    private void proceedAfterWayCheckerErrors(Relation r) {
        int numberOfDirectionErrors = 0;
        int numberOfRoadTypeErrors = 0;
        for (TestError e : this.errors) {
            if (e.getCode() == 3731) {
                ++numberOfDirectionErrors;
            }
            if (e.getCode() != 3721) continue;
            ++numberOfRoadTypeErrors;
        }
        final int[] userInput = new int[]{0};
        final long idParameter = r.getId();
        final int directionErrorParameter = numberOfDirectionErrors;
        final int roadTypeErrorParameter = numberOfRoadTypeErrors;
        if (SwingUtilities.isEventDispatchThread()) {
            userInput[0] = this.showProceedDialog(idParameter, directionErrorParameter, roadTypeErrorParameter);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        userInput[0] = PTAssistantValidatorTest.this.showProceedDialog(idParameter, directionErrorParameter, roadTypeErrorParameter);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
        if (userInput[0] == 0) {
            this.fixErrorFromPlugin(this.errors);
            this.proceedWithSorting(r);
            return;
        }
        if (userInput[0] == 1) {
            JOptionPane.showMessageDialog(null, "This is not implemented yet!");
            return;
        }
        if (userInput[0] == 2) {
            this.proceedWithSorting(r);
        }
    }

    private int showProceedDialog(long id, int numberOfDirectionErrors, int numberOfRoadTypeErrors) {
        if (numberOfDirectionErrors == 0 && numberOfRoadTypeErrors == 0) {
            return 2;
        }
        if (!Main.pref.getBoolean("pt_assistant.proceed-without-fix", true)) {
            return 0;
        }
        if (Main.pref.getBoolean("pt_assistant.proceed-without-fix", true)) {
            return 2;
        }
        ProceedDialog proceedDialog = new ProceedDialog(id, numberOfDirectionErrors, numberOfRoadTypeErrors);
        return proceedDialog.getUserSelection();
    }

    private void proceedWithSorting(Relation r) {
        RouteChecker routeChecker = new RouteChecker(r, (Test)this);
        routeChecker.performSortingTest();
        List<TestError> routeCheckerErrors = routeChecker.getErrors();
        if (!routeCheckerErrors.isEmpty()) {
            this.errors.addAll(routeChecker.getErrors());
        }
        this.proceedAfterSorting(r);
    }

    private void proceedAfterSorting(Relation r) {
        SegmentChecker segmentChecker = new SegmentChecker(r, (Test)this);
        if (!segmentChecker.getErrors().isEmpty()) {
            this.errors.addAll(segmentChecker.getErrors());
        }
        segmentChecker.performFirstStopTest();
        segmentChecker.performLastStopTest();
        segmentChecker.performStopNotServedTest();
        boolean sortingErrorFound = false;
        for (TestError error : this.errors) {
            if (error.getCode() != 3711) continue;
            sortingErrorFound = true;
            break;
        }
        if (!sortingErrorFound) {
            segmentChecker.performStopByStopTest();
            segmentChecker.findFixes();
        }
        for (TestError error : segmentChecker.getErrors()) {
            if (error.getCode() == 3743) continue;
            this.errors.add(error);
        }
    }

    public void startTest() {
        super.startTest(this.progressMonitor);
        SegmentChecker.reset();
    }

    public void endTest() {
        SegmentChecker.modifyStopByStopErrorMessages();
        for (Map.Entry<TestError.Builder, PTRouteSegment> entry : SegmentChecker.wrongSegmentBuilders.entrySet()) {
            TestError error = entry.getKey().build();
            SegmentChecker.wrongSegments.put(error, entry.getValue());
            this.errors.add(error);
        }
        super.endTest();
    }

    private void storeCorrectRouteSegments(Relation r) {
        PTRouteDataManager manager = new PTRouteDataManager(r);
        StopToWayAssigner assigner = new StopToWayAssigner(manager.getPTWays());
        if (manager.getPTStops().size() > 1) {
            for (int i = 1; i < manager.getPTStops().size(); ++i) {
                PTStop segmentStartStop = manager.getPTStops().get(i - 1);
                PTStop segmentEndStop = manager.getPTStops().get(i);
                Way segmentStartWay = assigner.get(segmentStartStop);
                Way segmentEndWay = assigner.get(segmentEndStop);
                List<PTWay> waysBetweenStops = manager.getPTWaysBetween(segmentStartWay, segmentEndWay);
                PTRouteSegment routeSegment = new PTRouteSegment(segmentStartStop, segmentEndStop, waysBetweenStops, r);
                SegmentChecker.addCorrectSegment(routeSegment);
            }
        }
    }

    public boolean isFixable(TestError testError) {
        if (testError.getCode() == 3731 || testError.getCode() == 3721 || testError.getCode() == 3722 || testError.getCode() == 3711 || testError.getCode() == 3751 || testError.getCode() == 3752) {
            return true;
        }
        return testError.getCode() == 3754 && SegmentChecker.isFixable(testError);
    }

    public Command fixError(TestError testError) {
        if (((OsmPrimitive)testError.getPrimitives().iterator().next()).getType().equals((Object)OsmPrimitiveType.RELATION)) {
            Relation relationToBeFixed = (Relation)testError.getPrimitives().iterator().next();
            this.layer.repaint(relationToBeFixed);
        }
        PTAssistantPlugin.setLastFix(null);
        ArrayList<Command> commands = new ArrayList<Command>();
        if (testError.getCode() == 3721 || testError.getCode() == 3722) {
            commands.add(WayChecker.fixErrorByZooming(testError));
        }
        if (testError.getCode() == 3731) {
            commands.add(WayChecker.fixErrorByZooming(testError));
        }
        if (testError.getCode() == 3711) {
            commands.add(RouteChecker.fixSortingError(testError));
        }
        if (testError.getCode() == 3751 || testError.getCode() == 3752) {
            commands.add(NodeChecker.fixError(testError));
        }
        if (testError.getCode() == 3754) {
            commands.add(SegmentChecker.fixError(testError));
            ArrayList<OsmPrimitive> primitivesToSelect = new ArrayList<OsmPrimitive>();
            for (Object obj : testError.getPrimitives()) {
                primitivesToSelect.add((OsmPrimitive)obj);
            }
            final SelectCommand selectCommand = new SelectCommand(primitivesToSelect);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    selectCommand.executeCommand();
                }
            });
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Fix error", (Object[])new Object[0]), commands);
    }

    private void fixErrorFromPlugin(List<TestError> testErrors) {
        FixTask fixTask = new FixTask(testErrors);
        Thread t = new Thread((Runnable)((Object)fixTask));
        t.start();
        try {
            t.join();
            this.errors.removeAll(testErrors);
        }
        catch (InterruptedException e) {
            JOptionPane.showMessageDialog(null, "Error occurred during fixing");
        }
    }

    public void addFixVariants(List<List<PTWay>> fixVariants) {
        this.layer.addFixVariants(fixVariants);
    }

    public void clearFixVariants() {
        this.layer.clearFixVariants();
    }

    public List<PTWay> getFixVariant(Character c) {
        return this.layer.getFixVariant(c.charValue());
    }

    private void performDummyTest(Relation r) {
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(r);
        TestError.Builder builder = TestError.builder((Test)this, (Severity)Severity.WARNING, (int)3731);
        builder.message(I18n.tr((String)"PT: dummy test warning", (Object[])new Object[0]));
        builder.primitives(primitives);
        this.errors.add(builder.build());
    }
}

