/*
 * Decompiled with CFR 0.152.
 */
package pdfimport;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressRenderer;
import org.openstreetmap.josm.gui.progress.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;
import pdfimport.FilePlacement;
import pdfimport.OsmBuilder;
import pdfimport.PathOptimizer;
import pdfimport.pdfbox.PdfBoxParser;

public class LoadPdfDialog
extends JFrame {
    private File fileName;
    private PathOptimizer data;
    private OsmDataLayer layer;
    private JComboBox<ProjectionChoice> projectionCombo;
    private JButton projectionPreferencesButton;
    private JTextField minXField;
    private JTextField minYField;
    private JTextField minEastField;
    private JTextField minNorthField;
    private JButton getMinButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton getMaxButton;
    private JTextField maxNorthField;
    private JTextField maxEastField;
    private JTextField maxYField;
    private JTextField maxXField;
    private JButton loadFileButton;
    private JButton showButton;
    private JButton saveButton;
    private JCheckBox debugModeCheck;
    private JCheckBox mergeCloseNodesCheck;
    private JTextField mergeCloseNodesTolerance;
    private JCheckBox removeSmallObjectsCheck;
    private JTextField removeSmallObjectsSize;
    private JTextField colorFilterColor;
    private JCheckBox colorFilterCheck;
    private JCheckBox removeParallelSegmentsCheck;
    private JTextField removeParallelSegmentsTolerance;
    private JCheckBox removeLargeObjectsCheck;
    private JTextField removeLargeObjectsSize;
    private JProgressBar loadProgress;
    protected OsmDataLayer newLayer;
    private LoadProgressRenderer progressRenderer;
    private JCheckBox limitPathCountCheck;
    private JTextField limitPathCount;
    private JCheckBox splitOnColorChangeCheck;
    private JCheckBox splitOnShapeClosedCheck;
    private JCheckBox splitOnSingleSegmentCheck;
    private JCheckBox splitOnOrthogonalCheck;

    public LoadPdfDialog() {
        this.buildGUI();
        FilePlacement pl = new FilePlacement();
        this.setPlacement(pl);
        this.addListeners();
        this.removeLayer();
    }

    private void addListeners() {
        this.projectionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.updateProjectionPrefButton();
            }
        });
        this.projectionPreferencesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.showProjectionPreferences();
            }
        });
        this.loadFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.loadFilePressed();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.okPressed();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.savePressed();
            }
        });
        this.showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.showPressed();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.cancelPressed();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LoadPdfDialog.this.cancelPressed();
            }
        });
        this.getMinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.getMinPressed();
            }
        });
        this.getMaxButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.getMaxPressed();
            }
        });
    }

    private void buildGUI() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.projectionCombo = new JComboBox();
        for (ProjectionChoice p : ProjectionPreference.getProjectionChoices()) {
            this.projectionCombo.addItem(p);
        }
        this.projectionPreferencesButton = new JButton(I18n.tr((String)"Prefs", (Object[])new Object[0]));
        this.updateProjectionPrefButton();
        this.loadFileButton = new JButton(I18n.tr((String)"Load file...", (Object[])new Object[0]));
        this.okButton = new JButton(I18n.tr((String)"Place", (Object[])new Object[0]));
        this.saveButton = new JButton(I18n.tr((String)"Save", (Object[])new Object[0]));
        this.showButton = new JButton(I18n.tr((String)"Show target", (Object[])new Object[0]));
        this.cancelButton = new JButton(I18n.tr((String)"Discard", (Object[])new Object[0]));
        this.loadProgress = new JProgressBar();
        this.progressRenderer = new LoadProgressRenderer(this.loadProgress);
        this.minXField = new JTextField("");
        this.minYField = new JTextField("");
        this.minEastField = new JTextField("");
        this.minNorthField = new JTextField("");
        this.getMinButton = new JButton(I18n.tr((String)"Take X and Y from selected node", (Object[])new Object[0]));
        this.maxXField = new JTextField("");
        this.maxYField = new JTextField("");
        this.maxEastField = new JTextField("");
        this.maxNorthField = new JTextField("");
        this.getMaxButton = new JButton(I18n.tr((String)"Take X and Y from selected node", (Object[])new Object[0]));
        this.debugModeCheck = new JCheckBox(I18n.tr((String)"Debug info", (Object[])new Object[0]));
        this.mergeCloseNodesCheck = new JCheckBox(I18n.tr((String)"Merge close nodes", (Object[])new Object[0]));
        this.mergeCloseNodesTolerance = new JTextField("1e-3");
        this.removeSmallObjectsCheck = new JCheckBox(I18n.tr((String)"Remove objects smaller than", (Object[])new Object[0]));
        this.removeSmallObjectsSize = new JTextField("1");
        this.removeLargeObjectsCheck = new JCheckBox(I18n.tr((String)"Remove objects larger than", (Object[])new Object[0]));
        this.removeLargeObjectsSize = new JTextField("10");
        this.colorFilterCheck = new JCheckBox(I18n.tr((String)"Only this color", (Object[])new Object[0]));
        this.colorFilterColor = new JTextField("#000000");
        this.removeParallelSegmentsCheck = new JCheckBox(I18n.tr((String)"Remove parallel lines", (Object[])new Object[0]));
        this.removeParallelSegmentsTolerance = new JTextField("3");
        this.limitPathCountCheck = new JCheckBox(I18n.tr((String)"Take only first X paths", (Object[])new Object[0]));
        this.limitPathCount = new JTextField("10000");
        this.splitOnColorChangeCheck = new JCheckBox(I18n.tr((String)"Color/width change", (Object[])new Object[0]));
        this.splitOnShapeClosedCheck = new JCheckBox(I18n.tr((String)"Shape closed", (Object[])new Object[0]));
        this.splitOnSingleSegmentCheck = new JCheckBox(I18n.tr((String)"Single segments", (Object[])new Object[0]));
        this.splitOnOrthogonalCheck = new JCheckBox(I18n.tr((String)"Orthogonal shapes", (Object[])new Object[0]));
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Import settings", (Object[])new Object[0])));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        configPanel.add((Component)this.mergeCloseNodesCheck, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 12;
        configPanel.add((Component)new JLabel("Tolerance :"), c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 18;
        configPanel.add((Component)this.mergeCloseNodesTolerance, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        configPanel.add((Component)this.removeSmallObjectsCheck, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 12;
        configPanel.add((Component)new JLabel("Tolerance :"), c);
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 18;
        configPanel.add((Component)this.removeSmallObjectsSize, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        configPanel.add((Component)this.removeLargeObjectsCheck, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 12;
        configPanel.add((Component)new JLabel("Tolerance :"), c);
        c.gridx = 2;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 18;
        configPanel.add((Component)this.removeLargeObjectsSize, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        configPanel.add((Component)this.removeParallelSegmentsCheck, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.anchor = 12;
        configPanel.add((Component)new JLabel("Max distance :"), c);
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.anchor = 18;
        configPanel.add((Component)this.removeParallelSegmentsTolerance, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        configPanel.add((Component)this.limitPathCountCheck, c);
        c.gridx = 2;
        c.gridy = 4;
        c.gridwidth = 1;
        configPanel.add((Component)this.limitPathCount, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        configPanel.add((Component)this.colorFilterCheck, c);
        c.gridx = 2;
        c.gridy = 5;
        c.gridwidth = 1;
        configPanel.add((Component)this.colorFilterColor, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        configPanel.add((Component)this.debugModeCheck, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        configPanel.add((Component)new JLabel(I18n.tr((String)"Introduce separate layers for:", (Object[])new Object[0])), c);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        configPanel.add((Component)this.splitOnShapeClosedCheck, c);
        c.gridx = 2;
        c.gridy = 7;
        c.gridwidth = 1;
        configPanel.add((Component)this.splitOnSingleSegmentCheck, c);
        c.gridx = 1;
        c.gridy = 8;
        c.gridwidth = 1;
        configPanel.add((Component)this.splitOnColorChangeCheck, c);
        c.gridx = 2;
        c.gridy = 8;
        c.gridwidth = 1;
        configPanel.add((Component)this.splitOnOrthogonalCheck, c);
        JPanel projectionPanel = new JPanel(new GridBagLayout());
        projectionPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Bind to coordinates", (Object[])new Object[0])));
        JPanel projectionSubPanel = new JPanel();
        projectionSubPanel.setLayout(new BoxLayout(projectionSubPanel, 0));
        projectionSubPanel.add(new JLabel(I18n.tr((String)"Projection:", (Object[])new Object[0])));
        projectionSubPanel.add(this.projectionCombo);
        projectionSubPanel.add(this.projectionPreferencesButton);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        projectionPanel.add((Component)projectionSubPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"Bottom left (min) corner:", (Object[])new Object[0])), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"PDF X and Y", (Object[])new Object[0])), c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"East and North", (Object[])new Object[0])), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.minXField, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.minYField, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.minEastField, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.minNorthField, c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.getMinButton, c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"Top right (max) corner:", (Object[])new Object[0])), c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 1;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"PDF X and Y", (Object[])new Object[0])), c);
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 1;
        projectionPanel.add((Component)new JLabel(I18n.tr((String)"East and North", (Object[])new Object[0])), c);
        c.gridx = 0;
        c.gridy = 8;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.maxXField, c);
        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.maxYField, c);
        c.gridx = 1;
        c.gridy = 8;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.maxEastField, c);
        c.gridx = 1;
        c.gridy = 9;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.maxNorthField, c);
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 1;
        projectionPanel.add((Component)this.getMaxButton, c);
        JPanel okCancelPanel = new JPanel(new GridLayout(1, 3));
        okCancelPanel.add(this.cancelButton);
        okCancelPanel.add(this.showButton);
        okCancelPanel.add(this.okButton);
        okCancelPanel.add(this.saveButton);
        JPanel panel = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        panel.add((Component)configPanel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        panel.add((Component)this.loadFileButton, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        panel.add((Component)projectionPanel, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        panel.add((Component)okCancelPanel, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        panel.add((Component)this.loadProgress, c);
        this.setSize(450, 550);
        this.setContentPane(panel);
    }

    private void updateProjectionPrefButton() {
        this.projectionPreferencesButton.setEnabled(true);
    }

    private void showProjectionPreferences() {
        ProjectionChoice proj = (ProjectionChoice)this.projectionCombo.getSelectedItem();
        ProjectionSubPrefsDialog dlg = new ProjectionSubPrefsDialog(this, proj);
        dlg.setVisible(true);
    }

    private void loadFilePressed() {
        final File newFileName = this.chooseFile();
        if (newFileName == null) {
            return;
        }
        this.removeLayer();
        this.loadFileButton.setEnabled(false);
        this.loadFileButton.setText(I18n.tr((String)"Loading...", (Object[])new Object[0]));
        this.runAsBackgroundTask(new Runnable(){

            @Override
            public void run() {
                OsmBuilder.Mode mode;
                SwingRenderingProgressMonitor monitor = new SwingRenderingProgressMonitor((ProgressRenderer)LoadPdfDialog.this.progressRenderer);
                monitor.beginTask("Loading file", 1000);
                LoadPdfDialog.this.data = LoadPdfDialog.this.loadPDF(newFileName, monitor.createSubTaskMonitor(500, false));
                OsmBuilder.Mode mode2 = mode = LoadPdfDialog.this.debugModeCheck.isSelected() ? OsmBuilder.Mode.Debug : OsmBuilder.Mode.Draft;
                if (LoadPdfDialog.this.data != null) {
                    LoadPdfDialog.this.newLayer = LoadPdfDialog.this.makeLayer(I18n.tr((String)"PDF file preview", (Object[])new Object[0]), new FilePlacement(), mode, monitor.createSubTaskMonitor(500, false));
                }
                monitor.finishTask();
                LoadPdfDialog.this.progressRenderer.finish();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LoadPdfDialog.this.data != null) {
                    LoadPdfDialog.this.placeLayer(LoadPdfDialog.this.newLayer, new FilePlacement());
                    LoadPdfDialog.this.fileName = newFileName;
                    LoadPdfDialog.this.newLayer = null;
                    LoadPdfDialog.this.loadFileButton.setText(I18n.tr((String)"Loaded", (Object[])new Object[0]));
                    LoadPdfDialog.this.loadFileButton.setEnabled(true);
                    FilePlacement placement = LoadPdfDialog.this.loadPlacement();
                    LoadPdfDialog.this.setPlacement(placement);
                }
            }
        });
    }

    private FilePlacement preparePlacement() {
        FilePlacement placement = this.parsePlacement();
        if (placement == null) {
            return null;
        }
        String transformError = placement.prepareTransform();
        if (transformError != null) {
            JOptionPane.showMessageDialog(Main.parent, transformError);
            return null;
        }
        this.savePlacement(placement);
        return placement;
    }

    private void okPressed() {
        final FilePlacement placement = this.preparePlacement();
        if (placement == null) {
            return;
        }
        this.removeLayer();
        this.runAsBackgroundTask(new Runnable(){

            @Override
            public void run() {
                SwingRenderingProgressMonitor monitor = new SwingRenderingProgressMonitor((ProgressRenderer)LoadPdfDialog.this.progressRenderer);
                LoadPdfDialog.this.newLayer = LoadPdfDialog.this.makeLayer(I18n.tr((String)"Imported PDF: ", (Object[])new Object[0]) + LoadPdfDialog.this.fileName, placement, OsmBuilder.Mode.Final, (ProgressMonitor)monitor);
                LoadPdfDialog.this.progressRenderer.finish();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.placeLayer(LoadPdfDialog.this.newLayer, placement);
                LoadPdfDialog.this.setVisible(false);
            }
        });
    }

    private void savePressed() {
        final FilePlacement placement = this.preparePlacement();
        if (placement == null) {
            return;
        }
        final File file = this.chooseSaveFile();
        if (file == null) {
            return;
        }
        this.removeLayer();
        this.runAsBackgroundTask(new Runnable(){

            @Override
            public void run() {
                SwingRenderingProgressMonitor monitor = new SwingRenderingProgressMonitor((ProgressRenderer)LoadPdfDialog.this.progressRenderer);
                LoadPdfDialog.this.saveLayer(file, placement, (ProgressMonitor)monitor);
                LoadPdfDialog.this.progressRenderer.finish();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoadPdfDialog.this.setVisible(false);
            }
        });
    }

    private void showPressed() {
        FilePlacement placement = this.preparePlacement();
        if (placement == null) {
            return;
        }
        Main.map.mapView.zoomTo(placement.getWorldBounds(this.data));
        Main.map.repaint();
    }

    private void cancelPressed() {
        this.removeLayer();
        this.setVisible(false);
    }

    private void getMinPressed() {
        EastNorth en = this.getSelectedCoor();
        if (en != null) {
            this.minXField.setText(Double.toString(en.east()));
            this.minYField.setText(Double.toString(en.north()));
        }
    }

    private void getMaxPressed() {
        EastNorth en = this.getSelectedCoor();
        if (en != null) {
            this.maxXField.setText(Double.toString(en.east()));
            this.maxYField.setText(Double.toString(en.north()));
        }
    }

    private EastNorth getSelectedCoor() {
        Collection selected = Main.getLayerManager().getEditDataSet().getSelected();
        if (selected.size() != 1 || !(selected.iterator().next() instanceof Node)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select exactly one node.", (Object[])new Object[0]));
            return null;
        }
        LatLon ll = ((Node)selected.iterator().next()).getCoor();
        FilePlacement pl = new FilePlacement();
        return pl.reverseTransform(ll);
    }

    private File chooseFile() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setMultiSelectionEnabled(false);
        fc.setSelectedFile(this.fileName);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".pdf");
            }

            @Override
            public String getDescription() {
                return I18n.tr((String)"PDF files", (Object[])new Object[0]);
            }
        });
        int result = fc.showOpenDialog(Main.parent);
        if (result != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private File chooseSaveFile() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(true);
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".osm");
            }

            @Override
            public String getDescription() {
                return I18n.tr((String)"OSM files", (Object[])new Object[0]);
            }
        });
        int result = fc.showOpenDialog(Main.parent);
        if (result != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private void runAsBackgroundTask(final Runnable task, final ActionListener after) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                task.run();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoadPdfDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                        after.actionPerformed(null);
                    }
                });
            }
        });
        t.start();
    }

    private PathOptimizer loadPDF(File fileName, ProgressMonitor monitor) {
        monitor.beginTask("", 100);
        monitor.setTicks(0);
        monitor.setCustomText(I18n.tr((String)"Preparing", (Object[])new Object[0]));
        double nodesTolerance = 0.0;
        Color color = null;
        int maxPaths = Integer.MAX_VALUE;
        if (this.mergeCloseNodesCheck.isSelected()) {
            try {
                nodesTolerance = Double.parseDouble(this.mergeCloseNodesTolerance.getText());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Tolerance is not a number", (Object[])new Object[0]));
                return null;
            }
        }
        if (this.colorFilterCheck.isSelected()) {
            try {
                String colString = this.colorFilterColor.getText().replace("#", "");
                color = new Color(Integer.parseInt(colString, 16));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not parse color", (Object[])new Object[0]));
                return null;
            }
        }
        if (this.limitPathCountCheck.isSelected()) {
            try {
                maxPaths = Integer.parseInt(this.limitPathCount.getText());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not parse max path count", (Object[])new Object[0]));
                return null;
            }
        }
        monitor.setTicks(10);
        monitor.setCustomText(I18n.tr((String)"Parsing file", (Object[])new Object[0]));
        PathOptimizer data = new PathOptimizer(nodesTolerance, color, this.splitOnColorChangeCheck.isSelected());
        try {
            PdfBoxParser parser = new PdfBoxParser(data);
            parser.parse(fileName, maxPaths, monitor.createSubTaskMonitor(80, false));
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"File not found.", (Object[])new Object[0]));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing: {0}", (Object[])new Object[]{e.getMessage()}));
            return null;
        }
        monitor.setTicks(80);
        if (this.removeParallelSegmentsCheck.isSelected()) {
            try {
                double tolerance = Double.parseDouble(this.removeParallelSegmentsTolerance.getText());
                monitor.setCustomText(I18n.tr((String)"Removing parallel segments", (Object[])new Object[0]));
                data.removeParallelLines(tolerance);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Max distance is not a number", (Object[])new Object[0]));
                return null;
            }
        }
        if (nodesTolerance > 0.0) {
            monitor.setTicks(83);
            monitor.setCustomText(I18n.tr((String)"Joining nodes", (Object[])new Object[0]));
            data.mergeNodes();
        }
        monitor.setTicks(85);
        monitor.setCustomText(I18n.tr((String)"Joining adjacent segments", (Object[])new Object[0]));
        data.mergeSegments();
        if (this.removeSmallObjectsCheck.isSelected()) {
            try {
                double tolerance = Double.parseDouble(this.removeSmallObjectsSize.getText());
                monitor.setTicks(90);
                monitor.setCustomText(I18n.tr((String)"Removing small objects", (Object[])new Object[0]));
                data.removeSmallObjects(tolerance);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Tolerance is not a number", (Object[])new Object[0]));
                return null;
            }
        }
        if (this.removeLargeObjectsCheck.isSelected()) {
            try {
                double tolerance = Double.parseDouble(this.removeLargeObjectsSize.getText());
                monitor.setTicks(90);
                monitor.setCustomText(I18n.tr((String)"Removing large objects", (Object[])new Object[0]));
                data.removeLargeObjects(tolerance);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Tolerance is not a number", (Object[])new Object[0]));
                return null;
            }
        }
        monitor.setTicks(95);
        monitor.setCustomText(I18n.tr((String)"Finalizing layers", (Object[])new Object[0]));
        data.splitLayersByPathKind(this.splitOnShapeClosedCheck.isSelected(), this.splitOnSingleSegmentCheck.isSelected(), this.splitOnOrthogonalCheck.isSelected());
        data.finish();
        monitor.finishTask();
        return data;
    }

    private FilePlacement parsePlacement() {
        ProjectionChoice selectedProjection = (ProjectionChoice)this.projectionCombo.getSelectedItem();
        if (selectedProjection == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please set a projection.", (Object[])new Object[0]));
            return null;
        }
        FilePlacement placement = new FilePlacement();
        placement.projection = selectedProjection.getProjection();
        try {
            placement.setPdfBounds(Double.parseDouble(this.minXField.getText()), Double.parseDouble(this.minYField.getText()), Double.parseDouble(this.maxXField.getText()), Double.parseDouble(this.maxYField.getText()));
            placement.setEastNorthBounds(Double.parseDouble(this.minEastField.getText()), Double.parseDouble(this.minNorthField.getText()), Double.parseDouble(this.maxEastField.getText()), Double.parseDouble(this.maxNorthField.getText()));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not parse numbers. Please check.", (Object[])new Object[0]));
            return null;
        }
        return placement;
    }

    private void setPlacement(FilePlacement placement) {
        if (placement == null) {
            placement = new FilePlacement();
        }
        if (placement.projection != null) {
            String projectionCode = placement.projection.toCode();
            block0: for (ProjectionChoice projectionChoice : ProjectionPreference.getProjectionChoices()) {
                for (String code : projectionChoice.allCodes()) {
                    if (!code.equals(projectionCode)) continue;
                    projectionChoice.getPreferencesFromCode(projectionCode);
                    this.projectionCombo.setSelectedItem(projectionChoice);
                    break block0;
                }
            }
        }
        this.minXField.setText(Double.toString(placement.minX));
        this.maxXField.setText(Double.toString(placement.maxX));
        this.minYField.setText(Double.toString(placement.minY));
        this.maxYField.setText(Double.toString(placement.maxY));
        this.minEastField.setText(Double.toString(placement.minEast));
        this.maxEastField.setText(Double.toString(placement.maxEast));
        this.minNorthField.setText(Double.toString(placement.minNorth));
        this.maxNorthField.setText(Double.toString(placement.maxNorth));
    }

    private FilePlacement loadPlacement() {
        FilePlacement pl = null;
        File propertiesFile = new File(this.fileName.getAbsoluteFile() + ".placement");
        try {
            if (propertiesFile.exists()) {
                pl = new FilePlacement();
                Properties p = new Properties();
                p.load(new FileInputStream(propertiesFile));
                pl.fromProperties(p);
            }
        }
        catch (Exception e) {
            pl = null;
            e.printStackTrace();
        }
        return pl;
    }

    private void savePlacement(FilePlacement pl) {
        File propertiesFile = new File(this.fileName.getAbsoluteFile() + ".placement");
        try {
            Properties p = pl.toProperties();
            p.store(new FileOutputStream(propertiesFile), "PDF file placement on OSM");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private OsmDataLayer makeLayer(String name, FilePlacement placement, OsmBuilder.Mode mode, ProgressMonitor monitor) {
        monitor.beginTask(I18n.tr((String)"Building JOSM layer", (Object[])new Object[0]), 100);
        OsmBuilder builder = new OsmBuilder(placement);
        DataSet data = builder.build(this.data.getLayers(), mode, monitor.createSubTaskMonitor(50, false));
        monitor.setTicks(50);
        monitor.setCustomText(I18n.tr((String)"Postprocessing layer", (Object[])new Object[0]));
        OsmDataLayer result = new OsmDataLayer(data, name, null);
        result.onPostLoadFromFile();
        monitor.finishTask();
        return result;
    }

    private void placeLayer(OsmDataLayer _layer, FilePlacement placement) {
        this.removeLayer();
        this.layer = _layer;
        Main.getLayerManager().addLayer((Layer)this.layer);
        Main.map.mapView.zoomTo(placement.getWorldBounds(this.data));
    }

    private void removeLayer() {
        if (this.layer != null) {
            Main.getLayerManager().removeLayer((Layer)this.layer);
            this.layer.data.clear();
            this.layer = null;
        }
    }

    private void saveLayer(File file, FilePlacement placement, ProgressMonitor monitor) {
        monitor.beginTask(I18n.tr((String)"Saving to file.", (Object[])new Object[0]), 1000);
        OsmBuilder builder = new OsmBuilder(placement);
        DataSet data = builder.build(this.data.getLayers(), OsmBuilder.Mode.Final, monitor.createSubTaskMonitor(500, false));
        OsmDataLayer layer = new OsmDataLayer(data, file.getName(), file);
        monitor.setCustomText(I18n.tr((String)" Writing to file", (Object[])new Object[0]));
        monitor.setTicks(500);
        OsmExporter exporter = new OsmExporter();
        try {
            exporter.exportData(file, (Layer)layer);
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
        monitor.finishTask();
    }

    private class ProjectionSubPrefsDialog
    extends JDialog {
        private final ProjectionChoice projPref;
        private OKAction actOK;
        private CancelAction actCancel;
        private JPanel projPrefPanel;

        ProjectionSubPrefsDialog(Component parent, ProjectionChoice pr) {
            super((Window)JOptionPane.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
            this.projPref = pr;
            this.setTitle(I18n.tr((String)"Projection Preferences", (Object[])new Object[0]));
            this.setDefaultCloseOperation(2);
            this.build();
        }

        protected void makeButtonRespondToEnter(SideButton btn) {
            btn.setFocusable(true);
            btn.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
            btn.getActionMap().put("enter", btn.getAction());
        }

        protected JPanel buildInputForm() {
            return this.projPref.getPreferencePanel(null);
        }

        protected JPanel buildButtonRow() {
            JPanel pnl = new JPanel(new FlowLayout());
            this.actOK = new OKAction();
            this.actCancel = new CancelAction();
            SideButton btn = new SideButton((Action)this.actOK);
            pnl.add((Component)btn);
            this.makeButtonRespondToEnter(btn);
            btn = new SideButton((Action)this.actCancel);
            pnl.add((Component)btn);
            this.makeButtonRespondToEnter(btn);
            return pnl;
        }

        protected void build() {
            this.projPrefPanel = this.buildInputForm();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.projPrefPanel, "Center");
            this.getContentPane().add((Component)this.buildButtonRow(), "South");
            this.pack();
            this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape");
            this.getRootPane().getActionMap().put("escape", this.actCancel);
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerOnScreen((Dimension)new Dimension(400, 300))).applySafe((Window)this);
            } else if (this.isShowing()) {
                new WindowGeometry((Window)this).remember(this.getClass().getName() + ".geometry");
            }
            super.setVisible(visible);
        }

        class CancelAction
        extends AbstractAction {
            CancelAction() {
                this.putValue("Name", I18n.tr((String)"Cancel", (Object[])new Object[0]));
                this.putValue("ShortDescription", I18n.tr((String)"Close the dialog, discard projection preference changes", (Object[])new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectionSubPrefsDialog.this.setVisible(false);
            }
        }

        class OKAction
        extends AbstractAction {
            OKAction() {
                this.putValue("Name", I18n.tr((String)"OK", (Object[])new Object[0]));
                this.putValue("ShortDescription", I18n.tr((String)"Close the dialog and apply projection preferences", (Object[])new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectionSubPrefsDialog.this.projPref.setPreferences(ProjectionSubPrefsDialog.this.projPref.getPreferences(ProjectionSubPrefsDialog.this.projPrefPanel));
                ProjectionSubPrefsDialog.this.setVisible(false);
            }
        }
    }

    class LoadProgressRenderer
    implements ProgressRenderer {
        private final JProgressBar pBar;
        private String title = "";

        LoadProgressRenderer(JProgressBar pb) {
            this.pBar = pb;
            this.pBar.setMinimum(0);
            this.pBar.setValue(0);
            this.pBar.setMaximum(1);
            this.pBar.setString("");
            this.pBar.setStringPainted(true);
        }

        public void setCustomText(String message) {
            this.pBar.setString(this.title + message);
        }

        public void setIndeterminate(boolean indeterminate) {
            this.pBar.setIndeterminate(indeterminate);
        }

        public void setMaximum(int maximum) {
            this.pBar.setMaximum(maximum);
        }

        public void setTaskTitle(String taskTitle) {
            this.title = taskTitle;
            this.pBar.setString(this.title);
        }

        public void setValue(int value) {
            this.pBar.setValue(value);
        }

        public void finish() {
            this.pBar.setString(I18n.tr((String)"Finished", (Object[])new Object[0]));
            this.pBar.setValue(this.pBar.getMaximum());
        }
    }
}

