/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.geotools.data.DataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.NationalHandlers;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoCrsException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UserCancelException;

public class ShpReader
extends GeographicReader {
    private final ShpHandler handler;
    private final Set<OsmPrimitive> featurePrimitives = new HashSet<OsmPrimitive>();

    public ShpReader(ShpHandler handler) {
        super(handler, NationalHandlers.DEFAULT_SHP_HANDLERS);
        this.handler = handler;
    }

    public static DataSet parseDataSet(InputStream in, File file, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        if (in != null) {
            in.close();
        }
        try {
            return new ShpReader(handler != null ? handler.getShpHandler() : null).parse(file, instance);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private void parseFeature(Feature feature, final Component parent) throws UserCancelException, GeoMathTransformException, FactoryException, GeoCrsException, MismatchedDimensionException, TransformException {
        this.featurePrimitives.clear();
        GeometryAttribute geometry = feature.getDefaultGeometryProperty();
        if (geometry != null) {
            GeometryDescriptor desc = geometry.getDescriptor();
            if (this.crs == null) {
                if (desc != null && desc.getCoordinateReferenceSystem() != null) {
                    this.crs = desc.getCoordinateReferenceSystem();
                } else if (!GraphicsEnvironment.isHeadless()) {
                    GuiHelper.runInEDTAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (0 == JOptionPane.showConfirmDialog(parent, I18n.tr((String)"Unable to detect Coordinate Reference System.\nWould you like to fallback to ESPG:4326 (WGS 84) ?", (Object[])new Object[0]), I18n.tr((String)"Warning: CRS not found", (Object[])new Object[0]), 1)) {
                                ShpReader.this.crs = GeographicReader.wgs84;
                            }
                        }
                    });
                } else {
                    this.crs = wgs84;
                }
                if (this.crs != null) {
                    this.findMathTransform(parent, true);
                } else {
                    throw new GeoCrsException(I18n.tr((String)"Unable to detect CRS !", (Object[])new Object[0]));
                }
            }
            Node primitive = null;
            if (geometry.getValue() instanceof Point) {
                primitive = this.createOrGetEmptyNode((Point)geometry.getValue());
            } else if (geometry.getValue() instanceof GeometryCollection) {
                GeometryCollection mp = (GeometryCollection)geometry.getValue();
                int nGeometries = mp.getNumGeometries();
                if (nGeometries < 1) {
                    Main.error((String)"empty geometry collection found");
                } else {
                    Way r = null;
                    Way w = null;
                    for (int i = 0; i < nGeometries; ++i) {
                        Geometry g = mp.getGeometryN(i);
                        if (g instanceof Polygon) {
                            Polygon p = (Polygon)g;
                            if (r == null && (nGeometries > 1 || p.getNumInteriorRing() > 0 || this.handler != null && this.handler.preferMultipolygonToSimpleWay())) {
                                r = this.createMultipolygon();
                            }
                            w = this.createOrGetWay(p.getExteriorRing());
                            if (r == null) continue;
                            this.addWayToMp((Relation)r, "outer", w);
                            for (int j = 0; j < p.getNumInteriorRing(); ++j) {
                                this.addWayToMp((Relation)r, "inner", this.createOrGetWay(p.getInteriorRingN(j)));
                            }
                            continue;
                        }
                        if (g instanceof LineString) {
                            w = this.createOrGetWay((LineString)g);
                            continue;
                        }
                        if (g instanceof Point) {
                            ShpReader.readNonGeometricAttributes(feature, (OsmPrimitive)this.createOrGetNode((Point)g));
                            continue;
                        }
                        Main.error((String)("unsupported geometry : " + g));
                    }
                    primitive = r != null ? r : w;
                }
            } else {
                Main.debug((String)("\ttype: " + geometry.getType()));
                Main.debug((String)("\tbounds: " + geometry.getBounds()));
                Main.debug((String)("\tdescriptor: " + desc));
                Main.debug((String)("\tname: " + geometry.getName()));
                Main.debug((String)("\tvalue: " + geometry.getValue()));
                Main.debug((String)("\tid: " + geometry.getIdentifier()));
                Main.debug((String)"-------------------------------------------------------------");
            }
            if (primitive != null) {
                ShpReader.readNonGeometricAttributes(feature, (OsmPrimitive)primitive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataSet parse(File file, ProgressMonitor instance) throws IOException {
        this.crs = null;
        this.transform = null;
        try {
            DataStore dataStore;
            if (file == null) return this.ds;
            HashMap<String, Object> params = new HashMap<String, Object>();
            Charset charset = null;
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            if (this.handler != null && this.handler.getDbfCharset() != null) {
                charset = this.handler.getDbfCharset();
            } else {
                String path = file.getAbsolutePath();
                Path cpg = new File(path = path.substring(0, path.lastIndexOf(46)) + ".cpg").toPath();
                if (Files.exists(cpg, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(cpg, StandardCharsets.UTF_8);){
                        charset = Charset.forName(reader.readLine());
                    }
                    catch (IOException | IllegalCharsetNameException | UnsupportedCharsetException e) {
                        Main.warn((Throwable)e);
                    }
                }
            }
            if (charset != null) {
                Main.info((String)("Using charset " + charset));
                params.put(ShapefileDataStoreFactory.DBFCHARSET.key, charset.name());
            }
            if ((dataStore = new ShapefileDataStoreFactory().createDataStore(params)) == null) {
                throw new IOException(I18n.tr((String)"Unable to find a data store for file {0}", (Object[])new Object[]{file.getName()}));
            }
            String[] typeNames = dataStore.getTypeNames();
            String typeName = typeNames[0];
            SimpleFeatureSource featureSource = dataStore.getFeatureSource(typeName);
            FeatureCollection collection = featureSource.getFeatures();
            FeatureIterator iterator = collection.features();
            if (instance != null) {
                instance.beginTask(I18n.tr((String)"Loading shapefile ({0} features)", (Object[])new Object[]{collection.size()}), collection.size());
            }
            int n = 0;
            Component parent = instance != null ? instance.getWindowParent() : Main.parent;
            try {
                while (iterator.hasNext()) {
                    ++n;
                    try {
                        Feature feature = iterator.next();
                        this.parseFeature(feature, parent);
                        if (this.handler != null) {
                            this.handler.notifyFeatureParsed(feature, this.ds, this.featurePrimitives);
                        }
                    }
                    catch (UserCancelException e) {
                        e.printStackTrace();
                        DataSet dataSet = this.ds;
                        iterator.close();
                        this.nodes.clear();
                        if (instance == null) return dataSet;
                        instance.setCustomText(null);
                        return dataSet;
                    }
                    if (instance == null) continue;
                    instance.worked(1);
                    instance.setCustomText(n + "/" + collection.size());
                }
                return this.ds;
            }
            finally {
                iterator.close();
                this.nodes.clear();
                if (instance != null) {
                    instance.setCustomText(null);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private static void readNonGeometricAttributes(Feature feature, OsmPrimitive primitive) {
        try {
            for (Property prop : feature.getProperties()) {
                if (prop instanceof GeometryAttribute) continue;
                Name name = prop.getName();
                Object value = prop.getValue();
                if (name == null || value == null) continue;
                String sName = name.toString();
                String sValue = value.toString();
                if (value instanceof Date) {
                    sValue = new SimpleDateFormat("yyyy-MM-dd").format(value);
                }
                if (sName.isEmpty() || sValue.isEmpty()) continue;
                primitive.put(sName, sValue);
            }
        }
        catch (Exception e) {
            Main.error((Throwable)e);
        }
    }

    @Override
    protected Node createOrGetNode(Point p) throws MismatchedDimensionException, TransformException {
        Node n = super.createOrGetNode(p);
        this.featurePrimitives.add((OsmPrimitive)n);
        return n;
    }

    @Override
    protected <T extends OsmPrimitive> T addOsmPrimitive(T p) {
        this.featurePrimitives.add(p);
        return super.addOsmPrimitive(p);
    }
}

