/*
 * Decompiled with CFR 0.152.
 */
package indoor_sweepline;

import indoor_sweepline.CorridorPart;
import indoor_sweepline.IndoorSweeplineModel;
import indoor_sweepline.IndoorSweeplineWizardDialog;
import indoor_sweepline.Strip;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class IndoorSweeplineController
implements LayerManager.LayerChangeListener {
    private OsmDataLayer layer;
    private IndoorSweeplineModel model;
    private IndoorSweeplineWizardDialog dialog;

    public IndoorSweeplineController(OsmDataLayer activeLayer, LatLon center) {
        Main.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        this.layer = activeLayer;
        this.model = new IndoorSweeplineModel(activeLayer, center);
        this.dialog = new IndoorSweeplineWizardDialog(this);
        this.dialog.setVisible(true);
    }

    public IndoorSweeplineWizardDialog view() {
        return this.dialog;
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() == this.layer) {
            this.dialog.setVisible(false);
        }
    }

    public int leftRightCount() {
        return this.model.leftRightCount();
    }

    public void addRightStructure() {
        if (this.model.leftRightCount() % 2 == 0) {
            this.model.addBeam();
        } else {
            this.model.addStrip();
        }
    }

    public DefaultComboBoxModel<String> structures() {
        return this.model.structures();
    }

    public double getStripWidth(int index) {
        return this.model.getStripWidth(index);
    }

    public void setStripWidth(int index, double value) {
        this.model.setStripWidth(index, value);
    }

    public double getBeamOffset(int index) {
        return this.model.getBeamOffset(index);
    }

    public void setBeamOffset(int index, double beamOffset) {
        this.model.setBeamOffset(index, beamOffset);
    }

    public List<CorridorPart> getBeamParts(int index) {
        return this.model.getBeamParts(index);
    }

    public void addCorridorPart(int beamIndex, boolean append, double value) {
        this.model.addCorridorPart(beamIndex, append, value);
    }

    public void setCorridorPartWidth(int beamIndex, int partIndex, double value) {
        this.model.setCorridorPartWidth(beamIndex, partIndex, value);
    }

    public void setCorridorPartType(int beamIndex, int partIndex, CorridorPart.Type type) {
        this.model.setCorridorPartType(beamIndex, partIndex, type);
    }

    public void setCorridorPartSide(int beamIndex, int partIndex, CorridorPart.ReachableSide side) {
        this.model.setCorridorPartSide(beamIndex, partIndex, side);
    }

    public Strip getStrip(int beamIndex) {
        return this.model.getStrip(beamIndex);
    }

    public IndoorSweeplineModel.Type getType() {
        return this.model.getType();
    }

    public void setType(IndoorSweeplineModel.Type type) {
        this.model.setType(type);
    }

    public String getLevel() {
        return this.model.getLevel();
    }

    public void setLevel(String level) {
        this.model.setLevel(level);
    }
}

