/*
 * Decompiled with CFR 0.152.
 */
package public_transport;

import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public abstract class AStarAlgorithm {
    protected Vertex begin;
    protected Vertex end;
    private TreeSet<Vertex> closedList;
    private TreeMap<Vertex, Double> openList;
    private TreeMap<Vertex, Edge> pathTail;

    public abstract Vector<Edge> getNeighbors(Vertex var1);

    public abstract double estimateDistance(Vertex var1);

    public AStarAlgorithm(Vertex begin, Vertex end) {
        this.begin = begin;
        this.end = end;
        this.openList = new TreeMap();
        this.closedList = new TreeSet();
        this.pathTail = new TreeMap();
    }

    public Vertex determineCurrentStart() {
        Vertex minVertex = null;
        double minDist = 0.0;
        for (Map.Entry<Vertex, Double> entry : this.openList.entrySet()) {
            double distance = entry.getValue() + this.estimateDistance(entry.getKey());
            if (minVertex != null && !(distance < minDist)) continue;
            minDist = distance;
            minVertex = entry.getKey();
        }
        if (minVertex != null) {
            System.out.print(this.openList.get(minVertex));
            System.out.print("\t");
            System.out.println(minDist);
        }
        return minVertex;
    }

    Vector<Edge> shortestPath() {
        Vertex currentStart = this.begin;
        this.openList.put(currentStart, 0.0);
        while (currentStart != null && !currentStart.equals(this.end)) {
            double startDistance = this.openList.get(currentStart);
            this.openList.remove(currentStart);
            this.closedList.add(currentStart);
            for (Edge edge : this.getNeighbors(currentStart)) {
                if (this.closedList.contains(edge.getEnd())) continue;
                Double knownDistance = this.openList.get(edge.getEnd());
                double distance = startDistance + edge.getLength();
                if (knownDistance != null && !(distance < knownDistance)) continue;
                this.openList.put(edge.getEnd(), distance);
                this.pathTail.put(edge.getEnd(), edge);
            }
            currentStart = this.determineCurrentStart();
        }
        if (currentStart == null) {
            return null;
        }
        Vector<Edge> backwards = new Vector<Edge>();
        Vertex currentEnd = this.end;
        while (!currentEnd.equals(this.begin)) {
            backwards.add(this.pathTail.get(currentEnd));
            currentEnd = this.pathTail.get(currentEnd).getBegin();
        }
        Vector<Edge> result = new Vector<Edge>();
        for (int i = backwards.size() - 1; i >= 0; --i) {
            result.add((Edge)backwards.elementAt(i));
        }
        return result;
    }

    public static abstract class Edge {
        public abstract Vertex getBegin();

        public abstract Vertex getEnd();

        public abstract double getLength();
    }

    public static abstract class Vertex
    implements Comparable<Vertex> {
        @Override
        public abstract int compareTo(Vertex var1);
    }
}

