/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.media.jai.PlanarImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImportImagePlugin;
import org.openstreetmap.josm.plugins.ImportImagePlugin.LayerPropertiesDialog;
import org.openstreetmap.josm.plugins.ImportImagePlugin.PluginOperations;
import org.openstreetmap.josm.tools.I18n;

public class ImageLayer
extends Layer {
    private Logger logger = Logger.getLogger(ImageLayer.class);
    private File imageFile;
    private BufferedImage image = null;
    private EastNorth upperLeft;
    private double angle = 0.0;
    private Envelope2D bbox;
    private Icon layericon = null;
    private CoordinateReferenceSystem sourceRefSys;

    public ImageLayer(File file) throws IOException {
        super(file.getName());
        this.imageFile = file;
        this.image = (BufferedImage)this.createImage();
        this.layericon = new ImageIcon(ImportImagePlugin.pluginClassLoader.getResource("images/layericon.png"));
    }

    private Image createImage() throws IOException {
        GridCoverage2D coverage = null;
        try {
            coverage = PluginOperations.createGridFromFile(this.imageFile, null, true);
            this.sourceRefSys = coverage.getCoordinateReferenceSystem();
            coverage = PluginOperations.reprojectCoverage(coverage, CRS.decode((String)Main.getProjection().toCode()));
        }
        catch (FactoryException e) {
            this.logger.error((Object)"Error while creating GridCoverage:", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        catch (Exception e) {
            if (e.getMessage().contains("No projection file found")) {
                ExtendedDialog ex = new ExtendedDialog(Main.parent, I18n.tr((String)"Warning", (Object[])new Object[0]), new String[]{I18n.tr((String)"Default image projection", (Object[])new Object[0]), I18n.tr((String)"JOSM''s current projection", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
                ex.setContent(I18n.tr((String)"No projection file (.prj) found.<br>You can choose the default image projection ({0}) or JOSM''s current editor projection ({1}) as original image projection.<br>(It can be changed later from the right click menu of the image layer.)", (Object[])new Object[]{ImportImagePlugin.pluginProps.getProperty("default_crs_srid"), Main.getProjection().toCode()}));
                ex.showDialog();
                int val = ex.getValue();
                if (val == 3) {
                    this.logger.debug((Object)"No projection and user declined un-projected use");
                    throw new LayerCreationCanceledException();
                }
                CoordinateReferenceSystem src = null;
                try {
                    if (val == 1) {
                        src = PluginOperations.defaultSourceCRS;
                    } else {
                        this.logger.debug((Object)"Passing through image un-projected.");
                        src = CRS.decode((String)Main.getProjection().toCode());
                    }
                    coverage = PluginOperations.createGridFromFile(this.imageFile, src, false);
                    this.sourceRefSys = coverage.getCoordinateReferenceSystem();
                    if (val == 1) {
                        coverage = PluginOperations.reprojectCoverage(coverage, CRS.decode((String)Main.getProjection().toCode()));
                    }
                }
                catch (Exception e1) {
                    this.logger.error((Object)"Error while creating GridCoverage:", (Throwable)e1);
                    throw new IOException(e1);
                }
            }
            this.logger.error((Object)"Error while creating GridCoverage:", (Throwable)e);
            throw new IOException(e);
        }
        this.logger.debug((Object)("Coverage created: " + coverage));
        this.upperLeft = new EastNorth(coverage.getEnvelope2D().x, coverage.getEnvelope2D().y + coverage.getEnvelope2D().height);
        this.angle = 0.0;
        this.bbox = coverage.getEnvelope2D();
        ImageWorker worker = new ImageWorker(coverage.getRenderedImage());
        return worker.getBufferedImage();
    }

    public void paint(Graphics2D g2, MapView mv, Bounds bounds) {
        if (this.image != null && g2 != null) {
            EastNorth center = mv.getCenter();
            EastNorth leftop = mv.getEastNorth(0, 0);
            double pixel_per_east_unit = (double)mv.getWidth() / 2.0 / (center.east() - leftop.east());
            double pixel_per_north_unit = (double)mv.getHeight() / 2.0 / (leftop.north() - center.north());
            double pic_offset_x = (this.upperLeft.east() - leftop.east()) * pixel_per_east_unit;
            double pic_offset_y = (leftop.north() - this.upperLeft.north()) * pixel_per_north_unit;
            Graphics2D g = (Graphics2D)g2.create();
            g.translate(pic_offset_x, pic_offset_y);
            g.rotate(this.angle * Math.PI / 180.0);
            ProjectionBounds projbounds = mv.getProjectionBounds();
            double width = projbounds.maxEast - projbounds.minEast;
            double height = projbounds.maxNorth - projbounds.minNorth;
            double ratio_x = (this.bbox.getMaxX() - this.bbox.getMinX()) / width;
            double ratio_y = (this.bbox.getMaxY() - this.bbox.getMinY()) / height;
            double pixels4bbox_width = ratio_x * (double)mv.getWidth();
            double pixels4bbox_height = ratio_y * (double)mv.getHeight();
            double scalex = pixels4bbox_width / (double)this.image.getWidth();
            double scaley = pixels4bbox_height / (double)this.image.getHeight();
            if (scalex > 10.0 || scaley > 10.0) {
                this.logger.warn((Object)"Not drawing image - scale too big");
                return;
            }
            g.scale(scalex, scaley);
            try {
                g.drawImage((Image)this.image, 0, 0, null);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        } else {
            this.logger.error((Object)"Error while dawing image: image == null or Graphics == null");
        }
    }

    public Envelope2D getBbox() {
        return this.bbox;
    }

    public Icon getIcon() {
        return this.layericon;
    }

    public Object getInfoComponent() {
        return null;
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction((Layer)this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(this.getAssociatedFile(), (Layer)this), new LayerPropertiesAction(this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
        throw new UnsupportedOperationException();
    }

    public void visitBoundingBox(BoundingXYVisitor visitor) {
        EastNorth min = new EastNorth(this.getBbox().getMinX(), this.getBbox().getMinY());
        EastNorth max = new EastNorth(this.getBbox().getMaxX(), this.getBbox().getMaxY());
        visitor.visit(min);
        visitor.visit(max);
    }

    public String getToolTipText() {
        return this.getName();
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    void resample(CoordinateReferenceSystem refSys) throws IOException, NoSuchAuthorityCodeException, FactoryException {
        this.logger.debug((Object)"resample");
        GridCoverage2D coverage = PluginOperations.createGridFromFile(this.imageFile, refSys, true);
        coverage = PluginOperations.reprojectCoverage(coverage, CRS.decode((String)Main.getProjection().toCode()));
        this.bbox = coverage.getEnvelope2D();
        this.image = ((PlanarImage)coverage.getRenderedImage()).getAsBufferedImage();
        this.upperLeft = new EastNorth(coverage.getEnvelope2D().x, coverage.getEnvelope2D().y + coverage.getEnvelope2D().height);
        this.angle = 0.0;
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        this.visitBoundingBox(boundingXYVisitor);
        Main.map.mapView.zoomTo(boundingXYVisitor);
    }

    public CoordinateReferenceSystem getSourceRefSys() {
        return this.sourceRefSys;
    }

    public void setSourceRefSys(CoordinateReferenceSystem sourceRefSys) {
        this.sourceRefSys = sourceRefSys;
    }

    class LayerCreationCanceledException
    extends IOException {
        LayerCreationCanceledException() {
        }
    }

    public class LayerPropertiesAction
    extends AbstractAction {
        public ImageLayer imageLayer;

        public LayerPropertiesAction(ImageLayer imageLayer) {
            super(I18n.tr((String)"Layer Properties", (Object[])new Object[0]));
            this.imageLayer = imageLayer;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LayerPropertiesDialog layerProps = new LayerPropertiesDialog(this.imageLayer, PluginOperations.crsDescriptions);
            layerProps.setLocation(Main.parent.getWidth() / 4, Main.parent.getHeight() / 4);
            layerProps.setVisible(true);
        }
    }
}

