/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.kaintoch.gps.globalsat.dg100.Dg100Config;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class GlobalsatConfigDialog
extends JPanel {
    private JRadioButton formatPosOnly = new JRadioButton(I18n.tr((String)"Position only", (Object[])new Object[0]));
    private JRadioButton formatPosTDS = new JRadioButton(I18n.tr((String)"Position, Time, Date, Speed", (Object[])new Object[0]));
    private JRadioButton formatPosTDSA = new JRadioButton(I18n.tr((String)"Position, Time, Date, Speed, Altitude", (Object[])new Object[0]));
    private JRadioButton aTime = new JRadioButton(I18n.tr((String)"A By Time", (Object[])new Object[0]));
    private JRadioButton aDist = new JRadioButton(I18n.tr((String)"A By Distance", (Object[])new Object[0]));
    private JRadioButton bTime = new JRadioButton(I18n.tr((String)"B By Time", (Object[])new Object[0]));
    private JRadioButton bDist = new JRadioButton(I18n.tr((String)"B By Distance", (Object[])new Object[0]));
    private JRadioButton cTime = new JRadioButton(I18n.tr((String)"C By Time", (Object[])new Object[0]));
    private JRadioButton cDist = new JRadioButton(I18n.tr((String)"C By Distance", (Object[])new Object[0]));
    private JTextField aSeconds = new IntegerTextField();
    private JTextField aMeters = new IntegerTextField();
    private JTextField bSeconds = new IntegerTextField();
    private JTextField bMeters = new IntegerTextField();
    private JTextField cSeconds = new IntegerTextField();
    private JTextField cMeters = new IntegerTextField();
    private JCheckBox disableLogDist;
    private JCheckBox disableLogSpeed;
    private JTextField minLogDist;
    private JTextField minLogSpeed;
    private Dg100Config conf;

    public GlobalsatConfigDialog(Dg100Config config) {
        this.conf = config;
        GridBagConstraints c = new GridBagConstraints();
        Dimension xx = this.aSeconds.getPreferredSize();
        this.aSeconds.setPreferredSize(new Dimension((int)xx.getWidth() + 50, (int)xx.getHeight()));
        this.aMeters.setPreferredSize(new Dimension((int)xx.getWidth() + 50, (int)xx.getHeight()));
        this.bSeconds.setPreferredSize(new Dimension((int)xx.getWidth() + 50, (int)xx.getHeight()));
        this.bMeters.setPreferredSize(new Dimension((int)xx.getWidth() + 50, (int)xx.getHeight()));
        this.cSeconds.setPreferredSize(new Dimension((int)xx.getWidth() + 50, (int)xx.getHeight()));
        this.cMeters.setPreferredSize(new Dimension((int)xx.getWidth() + 50, (int)xx.getHeight()));
        this.setLayout(new GridBagLayout());
        GlobalsatConfigDialog.createButtonGroup(this.formatPosOnly, this.formatPosTDS, this.formatPosTDSA);
        JPanel logPanel = new JPanel();
        logPanel.setLayout(new BoxLayout(logPanel, 3));
        logPanel.add(new JLabel(I18n.tr((String)"Data Logging Format", (Object[])new Object[0])));
        logPanel.add(this.formatPosOnly);
        logPanel.add(this.formatPosTDS);
        logPanel.add(this.formatPosTDSA);
        c.insets = new Insets(4, 4, 0, 4);
        c.gridwidth = 1;
        c.weightx = 1.8;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        this.add(logPanel);
        this.disableLogSpeed = new JCheckBox(I18n.tr((String)"Disable data logging if speed falls below", (Object[])new Object[0]));
        c.insets = new Insets(4, 4, 0, 4);
        c.gridwidth = 1;
        c.weightx = 0.8;
        c.fill = 2;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = 1;
        this.add((Component)this.disableLogSpeed, c);
        this.minLogSpeed = new IntegerTextField();
        c.insets = new Insets(4, 4, 0, 4);
        c.gridwidth = 1;
        c.weightx = 1.5;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)this.minLogSpeed, c);
        this.disableLogSpeed.addActionListener(e -> this.minLogSpeed.setEnabled(this.disableLogSpeed.isSelected()));
        this.disableLogDist = new JCheckBox(I18n.tr((String)"Disable data logging if distance falls below", (Object[])new Object[0]));
        c.insets = new Insets(0, 4, 4, 4);
        c.gridwidth = 1;
        c.weightx = 0.8;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.disableLogDist, c);
        this.minLogDist = new IntegerTextField();
        c.insets = new Insets(0, 4, 4, 4);
        c.gridwidth = 1;
        c.weightx = 1.5;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        this.add((Component)this.minLogDist, c);
        Dimension x = this.minLogDist.getPreferredSize();
        this.minLogDist.setPreferredSize(new Dimension((int)x.getWidth() + 50, (int)x.getHeight()));
        this.disableLogDist.addActionListener(e -> this.minLogDist.setEnabled(this.disableLogDist.isSelected()));
        this.disableLogDist.setSelected(this.conf.getDisableLogDist());
        this.disableLogSpeed.setSelected(this.conf.getDisableLogSpeed());
        this.minLogDist.setEnabled(this.disableLogDist.isSelected());
        this.minLogSpeed.setEnabled(this.disableLogSpeed.isSelected());
        this.minLogSpeed.setText("" + this.conf.getSpeedThres());
        this.minLogDist.setText("" + this.conf.getDistThres());
        GlobalsatConfigDialog.createButtonGroup(this.aTime, this.aDist);
        c.insets = new Insets(4, 4, 0, 4);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 3;
        this.add((Component)this.aTime, c);
        c.insets = new Insets(0, 4, 4, 4);
        c.gridy = 4;
        this.add((Component)this.aDist, c);
        c.insets = new Insets(4, 4, 0, 4);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 3;
        this.add((Component)this.aSeconds, c);
        c.insets = new Insets(0, 4, 4, 4);
        c.gridy = 4;
        this.add((Component)this.aMeters, c);
        GlobalsatConfigDialog.createButtonGroup(this.bTime, this.bDist);
        c.insets = new Insets(4, 4, 0, 4);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 5;
        this.add((Component)this.bTime, c);
        c.insets = new Insets(0, 4, 4, 4);
        c.gridy = 6;
        this.add((Component)this.bDist, c);
        c.insets = new Insets(4, 4, 0, 4);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 5;
        this.add((Component)this.bSeconds, c);
        c.insets = new Insets(0, 4, 4, 4);
        c.gridy = 6;
        this.add((Component)this.bMeters, c);
        GlobalsatConfigDialog.createButtonGroup(this.cTime, this.cDist);
        c.insets = new Insets(4, 4, 0, 4);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 7;
        this.add((Component)this.cTime, c);
        c.insets = new Insets(0, 4, 4, 4);
        c.gridy = 8;
        this.add((Component)this.cDist, c);
        c.insets = new Insets(4, 4, 0, 4);
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 7;
        this.add((Component)this.cSeconds, c);
        c.insets = new Insets(0, 4, 4, 4);
        c.gridy = 8;
        this.add((Component)this.cMeters, c);
        switch (this.conf.getLogFormat()) {
            case 0: {
                this.formatPosOnly.setSelected(true);
                break;
            }
            case 1: {
                this.formatPosTDS.setSelected(true);
                break;
            }
            case 2: {
                this.formatPosTDSA.setSelected(true);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unknown logFormat", (Object[])new Object[0]));
            }
        }
        GlobalsatConfigDialog.enableTimeDistRadioButton(this.conf.getSwATimeOrDist(), this.aTime, this.aDist);
        GlobalsatConfigDialog.enableTimeDistRadioButton(this.conf.getSwBTimeOrDist(), this.bTime, this.bDist);
        GlobalsatConfigDialog.enableTimeDistRadioButton(this.conf.getSwCTimeOrDist(), this.cTime, this.cDist);
        this.aSeconds.setText("" + this.conf.getSwATime() / 1000);
        this.aMeters.setText("" + this.conf.getSwADist());
        this.bSeconds.setText("" + this.conf.getSwBTime() / 1000);
        this.bMeters.setText("" + this.conf.getSwBDist());
        this.cSeconds.setText("" + this.conf.getSwCTime() / 1000);
        this.cMeters.setText("" + this.conf.getSwCDist());
    }

    private static ButtonGroup createButtonGroup(AbstractButton ... buttons) {
        ButtonGroup group = new ButtonGroup();
        for (AbstractButton b : buttons) {
            group.add(b);
        }
        return group;
    }

    private static void enableTimeDistRadioButton(int timeOrDist, AbstractButton time, AbstractButton dist) {
        if (timeOrDist == 0) {
            time.setSelected(true);
            dist.setSelected(false);
        } else {
            time.setSelected(false);
            dist.setSelected(true);
        }
    }

    public Dg100Config getConfig() {
        this.conf.setDisableLogDist(this.disableLogDist.isSelected());
        this.conf.setDisableLogSpeed(this.disableLogSpeed.isSelected());
        this.conf.setDistThres(Integer.parseInt(this.minLogDist.getText()));
        this.conf.setSpeedThres(Integer.parseInt(this.minLogSpeed.getText()));
        if (this.formatPosOnly.isSelected()) {
            this.conf.setLogFormat((byte)0);
        } else if (this.formatPosTDS.isSelected()) {
            this.conf.setLogFormat((byte)1);
        } else if (this.formatPosTDSA.isSelected()) {
            this.conf.setLogFormat((byte)2);
        }
        this.conf.setSwATimeOrDist((byte)(this.aDist.isSelected() ? 1 : 0));
        this.conf.setSwBTimeOrDist((byte)(this.bDist.isSelected() ? 1 : 0));
        this.conf.setSwCTimeOrDist((byte)(this.cDist.isSelected() ? 1 : 0));
        this.conf.setSwATime(Integer.parseInt(this.aSeconds.getText()) * 1000);
        this.conf.setSwADist(Integer.parseInt(this.aMeters.getText()));
        this.conf.setSwBTime(Integer.parseInt(this.bSeconds.getText()) * 1000);
        this.conf.setSwBDist(Integer.parseInt(this.bMeters.getText()));
        this.conf.setSwCTime(Integer.parseInt(this.cSeconds.getText()) * 1000);
        this.conf.setSwCDist(Integer.parseInt(this.cMeters.getText()));
        return this.conf;
    }

    public class IntegerTextField
    extends JTextField {
        static final String badchars = "-`~!@#$%^&*()_+=\\|\"':;?/>.<, ";

        IntegerTextField() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void processKeyEvent(KeyEvent ev) {
            char c = ev.getKeyChar();
            if (Character.isLetter(c) && !ev.isAltDown() || badchars.indexOf(c) > -1) {
                ev.consume();
                return;
            }
            super.processKeyEvent(ev);
        }
    }
}

