/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;
import org.openstreetmap.josm.plugins.imageryxmlbounds.actions.BoundsLayerSaveAction;
import org.openstreetmap.josm.plugins.imageryxmlbounds.actions.BoundsLayerSaveAsAction;
import org.openstreetmap.josm.plugins.imageryxmlbounds.actions.ShowBoundsAction;

public class XmlBoundsLayer
extends OsmDataLayer
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener,
XmlBoundsConstants {
    private static final JosmAction[] ACTIONS_TO_DISABLE = new JosmAction[]{Main.main.menu.download, Main.main.menu.downloadPrimitive, Main.main.menu.downloadReferrers, Main.main.menu.upload, Main.main.menu.uploadSelection, Main.main.menu.update, Main.main.menu.updateModified, Main.main.menu.updateSelection, Main.main.menu.openLocation};
    private static final Map<JosmAction, Boolean> ACTIONS_STATES = new HashMap<JosmAction, Boolean>();

    public Action[] getMenuEntries() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Action action : super.getMenuEntries()) {
            if (action instanceof Layer.LayerSaveAction) {
                result.add((Object)new BoundsLayerSaveAction(this));
                continue;
            }
            if (action instanceof Layer.LayerSaveAsAction) {
                result.add((Object)new BoundsLayerSaveAsAction(this));
                continue;
            }
            if (action instanceof Layer.LayerGpxExportAction || action instanceof OsmDataLayer.ConvertToGpxLayerAction) continue;
            result.add(action);
        }
        result.add(new ShowBoundsAction(this));
        return result.toArray(new Action[0]);
    }

    public XmlBoundsLayer(DataSet data) {
        this(data, OsmDataLayer.createNewName(), null);
    }

    public XmlBoundsLayer(DataSet data, String name, File associatedFile) {
        super(data, name, associatedFile);
        Main.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        Main.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
    }

    public boolean isMergable(Layer other) {
        return other instanceof XmlBoundsLayer;
    }

    public Icon getIcon() {
        return XML_ICON_16;
    }

    public boolean requiresUploadToServer() {
        return false;
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        block3: {
            Layer oldLayer;
            Layer newLayer;
            block2: {
                newLayer = Main.getLayerManager().getActiveLayer();
                oldLayer = e.getPreviousActiveLayer();
                if (newLayer != this || oldLayer instanceof XmlBoundsLayer) break block2;
                for (JosmAction action : ACTIONS_TO_DISABLE) {
                    ACTIONS_STATES.put(action, action.isEnabled());
                    action.setEnabled(false);
                }
                break block3;
            }
            if (oldLayer != this || newLayer instanceof XmlBoundsLayer) break block3;
            for (JosmAction action : ACTIONS_TO_DISABLE) {
                action.setEnabled(ACTIONS_STATES.get(action).booleanValue());
            }
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (Main.getLayerManager().getEditLayer() instanceof XmlBoundsLayer) {
            for (JosmAction action : ACTIONS_TO_DISABLE) {
                action.setEnabled(false);
            }
        }
    }
}

