/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.util;

import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;

@UML(identifier="UnlimitedInteger", specification=Specification.ISO_19103)
public final class UnlimitedInteger
extends Number
implements Comparable<UnlimitedInteger> {
    private static final long serialVersionUID = 4748246369364771836L;
    public static final UnlimitedInteger NEGATIVE_INFINITY = new UnlimitedInteger(Integer.MIN_VALUE);
    public static final UnlimitedInteger POSITIVE_INFINITY = new UnlimitedInteger(Integer.MAX_VALUE);
    public static final int MIN_VALUE = -2147483647;
    public static final int MAX_VALUE = 0x7FFFFFFE;
    private final int value;

    public UnlimitedInteger(int value) {
        this.value = value;
    }

    public boolean isInfinite() {
        return this.value == Integer.MAX_VALUE || this.value == Integer.MIN_VALUE;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        switch (this.value) {
            case 0x7FFFFFFF: {
                return Float.POSITIVE_INFINITY;
            }
            case -2147483648: {
                return Float.NEGATIVE_INFINITY;
            }
        }
        return this.value;
    }

    @Override
    public double doubleValue() {
        switch (this.value) {
            case 0x7FFFFFFF: {
                return Double.POSITIVE_INFINITY;
            }
            case -2147483648: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 0x7FFFFFFF: {
                return "\u221e";
            }
            case -2147483648: {
                return "-\u221e";
            }
        }
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof UnlimitedInteger && ((UnlimitedInteger)object).value == this.value;
    }

    @Override
    public int compareTo(UnlimitedInteger other) {
        if (this.value < other.value) {
            return -1;
        }
        if (this.value > other.value) {
            return 1;
        }
        return 0;
    }
}

