/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wikipedia.data.WikidataEntry;
import org.wikipedia.data.WikipediaEntry;
import org.wikipedia.tools.XPath;

public final class WikipediaApp {
    public static final Pattern WIKIDATA_PATTERN = Pattern.compile("Q\\d+");
    private static final XPath X_PATH = XPath.getInstance();

    private WikipediaApp() {
    }

    static String getMediawikiLocale(Locale locale) {
        if (!locale.getCountry().isEmpty()) {
            return locale.getLanguage() + "-" + locale.getCountry().toLowerCase();
        }
        return locale.getLanguage();
    }

    public static String getSiteUrl(String wikipediaLang) {
        if ("wikidata".equals(wikipediaLang)) {
            return "https://www.wikidata.org";
        }
        return "https://" + wikipediaLang + ".wikipedia.org";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<WikipediaEntry> getEntriesFromCoordinates(String wikipediaLang, LatLon min, LatLon max) {
        try {
            String url = WikipediaApp.getSiteUrl(wikipediaLang) + "/w/api.php" + "?action=query" + "&list=geosearch" + "&format=xml" + "&gslimit=500" + "&gsbbox=" + max.lat() + "|" + min.lon() + "|" + min.lat() + "|" + max.lon();
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document doc = WikipediaApp.newDocumentBuilder().parse(in);
                List<WikipediaEntry> entries = X_PATH.evaluateNodes("//gs", doc).stream().map(node -> {
                    String name = X_PATH.evaluateString("@title", node);
                    LatLon latLon = new LatLon(X_PATH.evaluateDouble("@lat", node), X_PATH.evaluateDouble("@lon", node));
                    if ("wikidata".equals(wikipediaLang)) {
                        return new WikidataEntry(name, null, latLon, null);
                    }
                    return new WikipediaEntry(wikipediaLang, name, latLon);
                }).collect(Collectors.toList());
                if ("wikidata".equals(wikipediaLang)) {
                    List<WikipediaEntry> list = WikipediaApp.getLabelForWikidata(entries, Locale.getDefault(), new String[0]).stream().collect(Collectors.toList());
                    return list;
                }
                List<WikipediaEntry> list = entries;
                return list;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<WikidataEntry> getWikidataEntriesForQuery(String languageForQuery, String query, Locale localeForLabels) {
        try {
            String url = "https://www.wikidata.org/w/api.php?action=wbsearchentities&language=" + languageForQuery + "&strictlanguage=false" + "&search=" + Utils.encodeUrl((String)query) + "&limit=50" + "&format=xml";
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                List r = X_PATH.evaluateNodes("//entity", xml).stream().map(node -> new WikidataEntry(X_PATH.evaluateString("@id", node), null, null, null)).collect(Collectors.toList());
                List<WikidataEntry> list = WikipediaApp.getLabelForWikidata(r, localeForLabels, new String[0]);
                return list;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<WikipediaEntry> getEntriesFromCategory(String wikipediaLang, String category, int depth) {
        try {
            String url = "https://tools.wmflabs.org/cats-php/?lang=" + wikipediaLang + "&depth=" + depth + "&cat=" + Utils.encodeUrl((String)category);
            try (BufferedReader reader = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContentReader();){
                List<WikipediaEntry> list = reader.lines().map(line -> new WikipediaEntry(wikipediaLang, line.trim().replace("_", " "))).collect(Collectors.toList());
                return list;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<WikipediaEntry> getEntriesFromClipboard(String wikipediaLang) {
        return Pattern.compile("[\\n\\r]+").splitAsStream(ClipboardUtils.getClipboardStringContent()).map(x -> new WikipediaEntry(wikipediaLang, (String)x)).collect(Collectors.toList());
    }

    public static void updateWIWOSMStatus(String wikipediaLang, List<WikipediaEntry> entries) {
        if (entries.size() > 20) {
            WikipediaApp.partitionList(entries, 20).forEach(chunk -> WikipediaApp.updateWIWOSMStatus(wikipediaLang, chunk));
            return;
        }
        HashMap status = new HashMap();
        if (!entries.isEmpty()) {
            String url = "https://tools.wmflabs.org/wiwosm/osmjson/getGeoJSON.php?action=check&lang=" + wikipediaLang;
            try {
                String articles = entries.stream().map(i -> i.article).collect(Collectors.joining(","));
                String requestBody = "articles=" + Utils.encodeUrl((String)articles);
                try (BufferedReader reader = HttpClient.create((URL)new URL(url), (String)"POST").setReasonForRequest("Wikipedia").setHeader("Content-Type", "application/x-www-form-urlencoded").setRequestBody(requestBody.getBytes(StandardCharsets.UTF_8)).connect().getContentReader();){
                    reader.lines().forEach(line -> {
                        String[] x = line.split("\t");
                        if (x.length == 2) {
                            status.put(x[0], "1".equals(x[1]));
                        } else {
                            Main.error((String)("Unknown element " + line));
                        }
                    });
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        for (WikipediaEntry i2 : entries) {
            i2.setWiwosmStatus((Boolean)status.get(i2.article));
        }
    }

    public static Stream<String> getWikipediaArticles(String wikipediaLang, OsmPrimitive p) {
        if ("wikidata".equals(wikipediaLang)) {
            return Stream.of(p.get("wikidata")).filter(Objects::nonNull);
        }
        return Stream.of("wikipedia", "wikipedia:" + wikipediaLang).map(key -> WikipediaEntry.parseTag(key, p.get(key))).filter(Objects::nonNull).filter(wp -> wikipediaLang.equals(wp.lang)).map(wp -> wp.article);
    }

    public static Map<String, String> getWikidataForArticles(String wikipediaLang, List<String> articles) {
        if (articles.size() > 50) {
            ArrayList<String> withoutDuplicates = new ArrayList<String>(new TreeSet<String>(articles));
            return WikipediaApp.partitionList(withoutDuplicates, 50).stream().flatMap(chunk -> WikipediaApp.getWikidataForArticles(wikipediaLang, chunk).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (articles.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=sitelinks&sites=" + wikipediaLang + "wiki" + "&sitefilter=" + wikipediaLang + "wiki" + "&format=xml" + "&titles=" + articles.stream().map(Utils::encodeUrl).collect(Collectors.joining("|"));
            TreeMap<String, String> r = new TreeMap<String, String>();
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                X_PATH.evaluateNodes("//entity", xml).forEach(node -> {
                    String wikidata = X_PATH.evaluateString("./@id", node);
                    String wikipedia = X_PATH.evaluateString("./sitelinks/sitelink/@title", node);
                    if (WIKIDATA_PATTERN.matcher(wikidata).matches()) {
                        r.put(wikipedia, wikidata);
                    }
                });
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getCategoriesForPrefix(String wikipediaLang, String prefix) {
        try {
            String url = WikipediaApp.getSiteUrl(wikipediaLang) + "/w/api.php" + "?action=query" + "&list=prefixsearch" + "&format=xml" + "&psnamespace=14" + "&pslimit=50" + "&pssearch=" + Utils.encodeUrl((String)prefix);
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document doc = WikipediaApp.newDocumentBuilder().parse(in);
                List<String> list = X_PATH.evaluateNodes("//ps/@title", doc).stream().map(Node::getNodeValue).map(value -> value.contains(":") ? value.split(":", 2)[1] : value).collect(Collectors.toList());
                return list;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getLabelForWikidata(String wikidataId, Locale locale, String ... preferredLanguage) {
        try {
            List<WikidataEntry> entry = Collections.singletonList(new WikidataEntry(wikidataId, null, null, null));
            return WikipediaApp.getLabelForWikidata(entry, (Locale)locale, (String[])preferredLanguage).get((int)0).label;
        }
        catch (IndexOutOfBoundsException ignore) {
            return null;
        }
    }

    static List<WikidataEntry> getLabelForWikidata(List<? extends WikipediaEntry> entries, Locale locale, String ... preferredLanguage) {
        if (entries.size() > 50) {
            return WikipediaApp.partitionList(entries, 50).stream().flatMap(chunk -> WikipediaApp.getLabelForWikidata(chunk, locale, preferredLanguage).stream()).collect(Collectors.toList());
        }
        if (entries.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            String url = "https://www.wikidata.org/w/api.php?action=wbgetentities&props=labels|descriptions&ids=" + entries.stream().map(x -> x.article).collect(Collectors.joining("|")) + "&format=xml";
            ArrayList<String> languages = new ArrayList<String>();
            if (locale != null) {
                languages.add(WikipediaApp.getMediawikiLocale(locale));
                languages.add(WikipediaApp.getMediawikiLocale(new Locale(locale.getLanguage())));
            }
            languages.addAll(Arrays.asList(preferredLanguage));
            languages.add("en");
            languages.add(null);
            ArrayList<WikidataEntry> r = new ArrayList<WikidataEntry>(entries.size());
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                for (WikipediaEntry wikipediaEntry : entries) {
                    Node entity = X_PATH.evaluateNode("//entity[@id='" + wikipediaEntry.article + "']", xml);
                    if (entity == null) continue;
                    r.add(new WikidataEntry(wikipediaEntry.article, WikipediaApp.getFirstField(languages, "label", entity), wikipediaEntry.coordinate, WikipediaApp.getFirstField(languages, "description", entity)));
                }
            }
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getFirstField(Collection<String> languages, String field, Node entity) {
        return languages.stream().map(language -> X_PATH.evaluateString(language != null ? ".//" + field + "[@language='" + language + "']/@value" : ".//" + field + "/@value", entity)).filter(label -> label != null && !label.isEmpty()).findFirst().orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<WikipediaEntry> getInterwikiArticles(String wikipediaLang, String article) {
        try {
            String url = WikipediaApp.getSiteUrl(wikipediaLang) + "/w/api.php" + "?action=query" + "&prop=langlinks" + "&titles=" + Utils.encodeUrl((String)article) + "&lllimit=500" + "&format=xml";
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                Collection collection = X_PATH.evaluateNodes("//ll", xml).stream().map(node -> {
                    String lang = X_PATH.evaluateString("@lang", node);
                    String name = node.getTextContent();
                    return new WikipediaEntry(lang, name);
                }).collect(Collectors.toList());
                return collection;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LatLon getCoordinateForArticle(String wikipediaLang, String article) {
        try {
            String url = WikipediaApp.getSiteUrl(wikipediaLang) + "/w/api.php" + "?action=query" + "&prop=coordinates" + "&titles=" + Utils.encodeUrl((String)article) + "&format=xml";
            try (InputStream in = HttpClient.create((URL)new URL(url)).setReasonForRequest("Wikipedia").connect().getContent();){
                Document xml = WikipediaApp.newDocumentBuilder().parse(in);
                Node node = X_PATH.evaluateNode("//coordinates/co", xml);
                if (node == null) {
                    LatLon latLon = null;
                    return latLon;
                }
                LatLon latLon = new LatLon(X_PATH.evaluateDouble("@lat", node), X_PATH.evaluateDouble("@lon", node));
                return latLon;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> List<List<T>> partitionList(final List<T> list, final int size) {
        return new AbstractList<List<T>>(){

            @Override
            public List<T> get(int index) {
                int fromIndex = index * size;
                int toIndex = Math.min(fromIndex + size, list.size());
                return list.subList(fromIndex, toIndex);
            }

            @Override
            public int size() {
                return (int)Math.ceil((float)list.size() / (float)size);
            }
        };
    }

    private static DocumentBuilder newDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Main.warn((String)"Cannot create DocumentBuilder");
            Main.warn((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

