/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix;

import java.text.DecimalFormat;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.tofix.TofixDraw;
import org.openstreetmap.josm.plugins.tofix.TofixLayer;
import org.openstreetmap.josm.plugins.tofix.bean.AccessToTask;
import org.openstreetmap.josm.plugins.tofix.bean.items.Item;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintLinestring;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintMultipoint;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintPoint;
import org.openstreetmap.josm.plugins.tofix.controller.ItemController;
import org.openstreetmap.josm.plugins.tofix.util.Download;
import org.openstreetmap.josm.tools.I18n;

public class TofixTask {
    ItemController itemController = new ItemController();
    Bounds bounds = null;
    DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
    Node node = null;
    MapView mv = null;
    TofixLayer tofixLayer = new TofixLayer("Tofix-layer");

    public AccessToTask work(Item item, AccessToTask accessToTask, double size) {
        if ("Point".equals(item.getType())) {
            accessToTask = this.work_osmlintpoint(item.getItemOsmlintPoint(), accessToTask, size);
        }
        if ("LineString".equals(item.getType())) {
            accessToTask = this.work_osmlintlinestring(item.getItemOsmlintLinestring(), accessToTask, size);
        }
        if ("MultiPoint".equals(item.getType())) {
            accessToTask = this.work_osmlintmultipoint(item.getItemOsmlintMultipoint(), accessToTask, size);
        }
        UploadDialog.getUploadDialog().getChangeset().getCommentsCount();
        return accessToTask;
    }

    public void deleteLayer() {
        while (Main.getLayerManager().getEditLayer() != null) {
            Main.getLayerManager().removeLayer((Layer)Main.getLayerManager().getEditLayer());
        }
    }

    private AccessToTask work_osmlintpoint(ItemOsmlintPoint itemOsmlintPoint, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintPoint.getKey());
        this.node = itemOsmlintPoint.get_node();
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        this.checkTofixLayer();
        TofixDraw.draw_Node(this.tofixLayer, this.node.getCoor());
        Download.download(this.downloadOsmTask, this.bounds, itemOsmlintPoint.getWay());
        return accessToTask;
    }

    private AccessToTask work_osmlintlinestring(ItemOsmlintLinestring itemOsmlintLinestring, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintLinestring.getKey());
        List<List<Node>> list = itemOsmlintLinestring.get_nodes();
        this.node = new Node(new LatLon(list.get(0).get(0).getCoor().lat(), list.get(0).get(0).getCoor().lon()));
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        this.checkTofixLayer();
        TofixDraw.draw_line(this.tofixLayer, this.node.getCoor(), list);
        Download.download(this.downloadOsmTask, this.bounds, itemOsmlintLinestring.getWay());
        return accessToTask;
    }

    private AccessToTask work_osmlintmultipoint(ItemOsmlintMultipoint itemOsmlintMultipoint, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintMultipoint.getKey());
        List<Node> list = itemOsmlintMultipoint.get_nodes();
        this.node = new Node(new LatLon(list.get(0).getCoor().lat(), list.get(0).getCoor().lon()));
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        this.checkTofixLayer();
        TofixDraw.draw_nodes(this.tofixLayer, this.node.getCoor(), list);
        Download.download(this.downloadOsmTask, this.bounds, itemOsmlintMultipoint.getWay());
        return accessToTask;
    }

    public void task_complete(Item item, AccessToTask accessToTask) {
        DecimalFormat myFormatter = new DecimalFormat("#,###");
        String num = myFormatter.format(item.getTaskCompleteBean().getTotal());
        String message = "Task " + accessToTask.getTask_name() + " is complete\n" + num + " issues fixed";
        new Notification(I18n.tr((String)message, (Object[])new Object[0])).show();
    }

    public final void checkTofixLayer() {
        if (!Main.getLayerManager().containsLayer((Layer)this.tofixLayer)) {
            Main.getLayerManager().addLayer((Layer)this.tofixLayer);
        }
    }
}

