/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix.controller;

import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.openstreetmap.josm.plugins.tofix.bean.AccessToTask;
import org.openstreetmap.josm.plugins.tofix.bean.ResponseBean;
import org.openstreetmap.josm.plugins.tofix.bean.TaskCompleteBean;
import org.openstreetmap.josm.plugins.tofix.bean.items.Item;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintLinestring;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintMultipoint;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintPoint;
import org.openstreetmap.josm.plugins.tofix.util.Request;
import org.openstreetmap.josm.plugins.tofix.util.Util;

public class ItemController {
    Item item = new Item();
    ResponseBean responseBean = new ResponseBean();
    AccessToTask accessToTask;

    public AccessToTask getAccessToTask() {
        return this.accessToTask;
    }

    public void setAccessToTask(AccessToTask accessToTask) {
        this.accessToTask = accessToTask;
    }

    public Item getItem() {
        try {
            this.responseBean = Request.sendPOST(this.accessToTask.getTask_url());
            this.item.setStatus(this.responseBean.getStatus());
            Util.print(this.responseBean.getValue());
            JsonReader reader = Json.createReader((Reader)new StringReader(this.responseBean.getValue()));
            JsonObject object = reader.readObject();
            JsonObject geometry = (JsonObject)object.get((Object)"geometry");
            JsonObject properties = (JsonObject)object.get((Object)"properties");
            this.item.setType(geometry.getString("type"));
            switch (this.responseBean.getStatus()) {
                case 200: {
                    if (geometry.getString("type").equals("Point")) {
                        ItemOsmlintPoint iop = new ItemOsmlintPoint();
                        iop.setKey(properties.getString("_key"));
                        if (properties.containsKey((Object)"_osmId") && geometry.containsKey((Object)"type")) {
                            iop.setWay(Long.parseLong(properties.getJsonNumber("_osmId").toString()));
                            iop.setGeometry(geometry.getJsonString("type").toString());
                            iop.setCoordinates(((JsonValue)geometry.get((Object)"coordinates")).toString());
                            this.item.setItemOsmlintPoint(iop);
                        } else {
                            this.item.setStatus(520);
                        }
                    }
                    if (geometry.getString("type").equals("MultiPoint")) {
                        ItemOsmlintMultipoint iom = new ItemOsmlintMultipoint();
                        iom.setKey(properties.getString("_key"));
                        if (properties.containsKey((Object)"_osmId") && geometry.containsKey((Object)"type")) {
                            iom.setWay(Long.parseLong(properties.getJsonNumber("_osmId").toString()));
                            iom.setGeometry(geometry.getJsonString("type").toString());
                            iom.setCoordinates(((JsonValue)geometry.get((Object)"coordinates")).toString());
                            this.item.setItemOsmlintMultipoint(iom);
                        } else {
                            this.item.setStatus(520);
                        }
                    }
                    if (!geometry.getString("type").equals("LineString")) break;
                    ItemOsmlintLinestring iol = new ItemOsmlintLinestring();
                    iol.setKey(properties.getString("_key"));
                    if (object.containsKey((Object)"geometry")) {
                        iol.setGeometry(geometry.getJsonString("type").toString());
                        iol.setCoordinates(((JsonValue)geometry.get((Object)"coordinates")).toString());
                        this.item.setItemOsmlintLinestring(iol);
                        break;
                    }
                    this.item.setStatus(520);
                    break;
                }
                case 410: {
                    TaskCompleteBean taskCompleteBean = new TaskCompleteBean();
                    taskCompleteBean.setTotal(0);
                    String total = this.responseBean.getValue().replaceAll("[^0-9]+", " ");
                    if (total.trim().split(" ")[1] != null) {
                        taskCompleteBean.setTotal(Integer.parseInt(total.trim().split(" ")[1]));
                    }
                    this.item.setTaskCompleteBean(taskCompleteBean);
                    break;
                }
            }
            reader.close();
        }
        catch (Exception ex) {
            Util.alert(ex);
            Logger.getLogger(ItemController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.item;
    }
}

