/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tag2link.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.tag2link.Tag2LinkConstants;
import org.openstreetmap.josm.plugins.tag2link.data.Link;
import org.openstreetmap.josm.plugins.tag2link.data.LinkPost;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class OpenLinkAction
extends JosmAction
implements Tag2LinkConstants {
    private Link link;

    public OpenLinkAction(Link link) {
        super(I18n.tr((String)link.name, (Object[])new Object[0]), "tag2linkv2_24x24.png", I18n.tr((String)"Launch browser with information about the selected object", (Object[])new Object[0]), null, false);
        this.link = link;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.link instanceof LinkPost) {
            try {
                LinkPost lp = (LinkPost)this.link;
                String data = "";
                for (String param : lp.params.keySet()) {
                    if (!data.isEmpty()) {
                        data = data + "&";
                    }
                    data = data + param + "=" + lp.params.get(param);
                }
                String filename = "output.pdf";
                try (InputStream is = HttpClient.create((URL)new URL(lp.url), (String)"POST").setHeaders(lp.headers).setRequestBody(data.getBytes(StandardCharsets.UTF_8)).connect().getContent();){
                    Files.copy(is, new File(filename).toPath(), new CopyOption[0]);
                }
                Main.info((String)("Opening " + filename));
                String result = OpenBrowser.displayUrl((String)("file://" + filename));
                if (result != null) {
                    Main.error((String)result);
                }
            }
            catch (IOException ex) {
                Main.error((Throwable)ex);
            }
        } else {
            Main.info((String)("Opening " + this.link.url));
            String result = OpenBrowser.displayUrl((String)this.link.url);
            if (result != null) {
                Main.error((String)result);
            }
        }
    }
}

