/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.wikipedia.WikipediaApp;
import org.wikipedia.gui.WikiSearchTextResultListPanel;
import org.wikipedia.gui.WikipediaToggleDialog;

final class WikipediaCategorySearchDialog
extends ExtendedDialog {
    private final Selector selector = new Selector();
    private static final WikipediaCategorySearchDialog INSTANCE = new WikipediaCategorySearchDialog();

    private WikipediaCategorySearchDialog() {
        super(Main.parent, I18n.tr((String)"Search Wikipedia category", (Object[])new Object[0]), new String[]{I18n.tr((String)"Load category", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        this.selector.setDblClickListener(e -> this.buttonAction(0, null));
        this.setContent((Component)((Object)this.selector), false);
        this.setPreferredSize(new Dimension(600, 300));
    }

    public static synchronized WikipediaCategorySearchDialog getInstance() {
        return INSTANCE;
    }

    public ExtendedDialog showDialog() {
        this.selector.init();
        super.showDialog();
        this.selector.clearSelection();
        this.selector.requestFocus();
        return this;
    }

    String getCategory() {
        return (String)this.selector.getSelectedItem();
    }

    private static class Selector
    extends WikiSearchTextResultListPanel<String> {
        private Selector() {
        }

        protected void filterItems() {
            String query = this.edSearchText.getText();
            this.debouncer.debounce(((Object)((Object)this)).getClass(), () -> {
                List entries = query == null || query.isEmpty() ? Collections.emptyList() : WikipediaApp.getCategoriesForPrefix(WikipediaToggleDialog.wikipediaLang.get(), query);
                GuiHelper.runInEDT(() -> this.lsResultModel.setItems(entries));
            }, 200L, TimeUnit.MILLISECONDS);
        }
    }
}

