/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.io.export;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.cache.CacheUtils;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;

public class MapillaryExportDownloadThread
extends Thread
implements ICachedLoaderListener {
    private final ArrayBlockingQueue<BufferedImage> queue;
    private final ArrayBlockingQueue<MapillaryAbstractImage> queueImages;
    private final MapillaryImage image;

    public MapillaryExportDownloadThread(MapillaryImage image, ArrayBlockingQueue<BufferedImage> queue, ArrayBlockingQueue<MapillaryAbstractImage> queueImages) {
        this.queue = queue;
        this.image = image;
        this.queueImages = queueImages;
    }

    @Override
    public void run() {
        CacheUtils.submit(this.image.getKey(), MapillaryCache.Type.FULL_IMAGE, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadingFinished(CacheEntry data, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
        try {
            Class<MapillaryExportDownloadThread> clazz = MapillaryExportDownloadThread.class;
            synchronized (MapillaryExportDownloadThread.class) {
                this.queue.put(ImageIO.read(new ByteArrayInputStream(data.getContent())));
                this.queueImages.put(this.image);
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (IOException | InterruptedException e) {
            Main.error((Throwable)e);
        }
        {
            return;
        }
    }
}

