/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLocationChangeset;
import org.openstreetmap.josm.plugins.mapillary.actions.MapillarySubmitCurrentChangesetAction;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryImageTreeCellRenderer;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryChangesetListener;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public final class MapillaryChangesetDialog
extends ToggleDialog
implements MapillaryChangesetListener {
    private static final long serialVersionUID = -3019715241209349372L;
    private static MapillaryChangesetDialog instance;
    private final DefaultTreeModel changesetTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final JTree changesetTree = new JTree(this.changesetTreeModel);
    private final JSeparator separator = new JSeparator();
    private final Component spacer = Box.createRigidArea(new Dimension(0, 3));
    private final SideButton submitButton;
    private final ConcurrentHashMap<Object, MapillaryAbstractImage> map = new ConcurrentHashMap();

    public static void destroyInstance() {
        instance = null;
    }

    private MapillaryChangesetDialog() {
        super(I18n.tr((String)"Current Mapillary changeset", (Object[])new Object[0]), "mapillary-upload.svg", I18n.tr((String)"Open Mapillary changeset dialog", (Object[])new Object[0]), Shortcut.registerShortcut((String)I18n.tr((String)"Mapillary changeset", (Object[])new Object[0]), (String)I18n.tr((String)"Open Mapillary changeset dialog", (Object[])new Object[0]), (int)57, (int)5000), 200);
        this.changesetTree.expandRow(0);
        this.changesetTree.setShowsRootHandles(true);
        this.changesetTree.setRootVisible(false);
        this.changesetTree.setCellRenderer(new MapillaryImageTreeCellRenderer());
        this.changesetTree.getSelectionModel().setSelectionMode(1);
        JPanel treesPanel = new JPanel(new GridBagLayout());
        treesPanel.add(this.spacer, GBC.eol());
        this.spacer.setVisible(false);
        treesPanel.add((Component)this.changesetTree, GBC.eol().fill(2));
        this.separator.setVisible(false);
        treesPanel.add((Component)this.separator, GBC.eol().fill(2));
        treesPanel.add(Box.createRigidArea(new Dimension(0, 0)), GBC.std().weight(0.0, 1.0));
        this.submitButton = new SideButton((Action)new SubmitAction());
        this.createLayout(treesPanel, true, Collections.singletonList(this.submitButton));
    }

    public static synchronized MapillaryChangesetDialog getInstance() {
        if (instance == null) {
            instance = new MapillaryChangesetDialog();
        }
        return instance;
    }

    private void buildTree() {
        this.submitButton.setEnabled(true);
        MapillaryLocationChangeset changeset = MapillaryLayer.getInstance().getLocationChangeset();
        if (!changeset.isEmpty()) {
            this.submitButton.setEnabled(true);
        } else {
            this.submitButton.setEnabled(false);
        }
        DefaultMutableTreeNode changesetRoot = new DefaultMutableTreeNode();
        this.map.clear();
        changeset.parallelStream().filter(command -> command != null).forEach(command -> {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(command.toString());
            this.map.put(node, (MapillaryAbstractImage)command);
            changesetRoot.add(node);
        });
        this.spacer.setVisible(changeset.isEmpty());
        this.changesetTreeModel.setRoot(changesetRoot);
    }

    @Override
    public void changesetChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::buildTree);
        } else {
            this.buildTree();
        }
    }

    private static class SubmitAction
    extends AbstractAction {
        private static final long serialVersionUID = -2761935780353053512L;

        SubmitAction() {
            this.putValue("Name", I18n.tr((String)"Submit", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"upload"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillarySubmitCurrentChangesetAction submitCurrentChangesetAction = new MapillarySubmitCurrentChangesetAction();
            submitCurrentChangesetAction.actionPerformed(null);
        }
    }
}

