/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.swing.JFileChooser;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandImport;
import org.openstreetmap.josm.plugins.mapillary.utils.ImageUtil;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryImportIntoSequenceAction
extends JosmAction {
    private static final long serialVersionUID = -9190217809965894878L;
    private List<MapillaryAbstractImage> images;

    public MapillaryImportIntoSequenceAction() {
        super(I18n.tr((String)"Import pictures into sequence", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Import local pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Import Mapillary Sequence", (String)I18n.tr((String)"Import pictures into Mapillary layer in a sequence", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryImportSequence", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent arg0) {
        this.images = new ArrayList<MapillaryAbstractImage>();
        JFileChooser chooser = new JFileChooser();
        File startDirectory = new File(Main.pref.get("mapillary.start-directory", System.getProperty("user.home")));
        chooser.setCurrentDirectory(startDirectory);
        chooser.setDialogTitle(I18n.tr((String)"Select pictures", (Object[])new Object[0]));
        chooser.setFileSelectionMode(2);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(ImageUtil.IMAGE_FILE_FILTER);
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(Main.parent) == 0) {
            for (File file : chooser.getSelectedFiles()) {
                Main.pref.put("mapillary.start-directory", file.getParent());
                try {
                    this.images.addAll(ImageUtil.readImagesFrom(file, Main.map.mapView.getProjection().eastNorth2latlon(Main.map.mapView.getCenter())));
                }
                catch (IOException e) {
                    Main.error((String)("Could not read image(s) from " + file.getAbsolutePath()));
                }
            }
            this.joinImages();
            MapillaryRecord.getInstance().addCommand(new CommandImport(new ConcurrentSkipListSet<MapillaryAbstractImage>(this.images)));
        }
        MapillaryUtils.showAllPictures();
    }

    public void joinImages() {
        Collections.sort(this.images, new MapillaryEpochComparator());
        MapillarySequence seq = new MapillarySequence();
        for (MapillaryAbstractImage img : this.images) {
            seq.add(img);
            img.setSequence(seq);
        }
    }

    public static class MapillaryEpochComparator
    implements Comparator<MapillaryAbstractImage>,
    Serializable {
        @Override
        public int compare(MapillaryAbstractImage arg0, MapillaryAbstractImage arg1) {
            if (arg0.getCapturedAt() < arg1.getCapturedAt()) {
                return -1;
            }
            if (arg0.getCapturedAt() > arg1.getCapturedAt()) {
                return 1;
            }
            return 0;
        }
    }
}

