/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.utils;

import org.openstreetmap.josm.tools.I18n;

public final class ValidationUtil {
    private static final String KEY_REGEX = "[a-zA-Z0-9\\-_]{22}";

    private ValidationUtil() {
    }

    public static boolean validateImageKey(String imgKey) {
        return imgKey != null && imgKey.matches(KEY_REGEX);
    }

    public static boolean validateSequenceKey(String seqKey) {
        return ValidationUtil.validateImageKey(seqKey);
    }

    public static void throwExceptionForInvalidImgKey(String imgKey, boolean nullAllowed) {
        if (!ValidationUtil.validateSequenceKey(imgKey)) {
            throw new IllegalArgumentException(I18n.tr((String)"The image key ''{0}'' is invalid!", (Object[])new Object[]{imgKey}));
        }
        if (!nullAllowed && imgKey == null) {
            throw new IllegalArgumentException(I18n.tr((String)"The image key must not be null here!", (Object[])new Object[0]));
        }
    }

    public static void throwExceptionForInvalidSeqKey(String seqKey, boolean nullAllowed) {
        if (!ValidationUtil.validateSequenceKey(seqKey)) {
            throw new IllegalArgumentException(I18n.tr((String)"The sequence key ''{0}'' is invalid!", (Object[])new Object[]{seqKey}));
        }
        if (!nullAllowed && seqKey == null) {
            throw new IllegalArgumentException(I18n.tr((String)"The sequence key must not be null here!", (Object[])new Object[0]));
        }
    }
}

