/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryUploadDialog;
import org.openstreetmap.josm.plugins.mapillary.oauth.UploadUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryUploadAction
extends JosmAction
implements MapillaryDataListener {
    private static final long serialVersionUID = -1405641273676919943L;

    public MapillaryUploadAction() {
        super(I18n.tr((String)"Upload pictures", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Upload pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Upload Mapillary", (String)I18n.tr((String)"Upload Mapillary pictures", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryUpload", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent arg0) {
        MapillaryUploadDialog dialog = new MapillaryUploadDialog();
        JOptionPane pane = new JOptionPane(dialog, -1, 2);
        JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Upload pictures.", (Object[])new Object[0]));
        dlg.setMinimumSize(new Dimension(400, 150));
        dlg.setVisible(true);
        if (pane.getValue() != null && (Integer)pane.getValue() == 0 && dialog.getDelete() != null && dialog.getSequence().isSelected()) {
            UploadUtils.uploadSequence(MapillaryLayer.getInstance().getData().getSelectedImage().getSequence(), dialog.getDelete().isSelected());
        }
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public void selectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
        if (oldImage == null && newImage != null) {
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getUploadMenu(), true);
        } else if (oldImage != null && newImage == null) {
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getUploadMenu(), false);
        }
    }
}

