/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.traffico.TrafficoSign;

public class MapillarySign {
    private static final String[] COUNTRIES = new String[]{"au", "br", "ca", "eu", "us"};
    private static Map<String, HashMap<String, MapillarySign>> map = new HashMap<String, HashMap<String, MapillarySign>>();
    private final String fullName;
    private final String category;
    private final String type;
    private final String country;
    private String variant;
    private TrafficoSign trafficoSign;

    public static MapillarySign getSign(String name, String country) {
        Map countryMap = map.get(country);
        if (countryMap == null) {
            throw new IllegalArgumentException("Country does not exist");
        }
        if (countryMap.containsKey(name)) {
            return (MapillarySign)countryMap.get(name);
        }
        if (name.split("--").length >= 3) {
            if (countryMap.containsValue(new MapillarySign(name))) {
                Optional<MapillarySign> p = countryMap.values().stream().filter(sign -> sign.toString().equals(name)).findFirst();
                assert (p.isPresent());
                return p.get();
            }
            return new MapillarySign(name);
        }
        Main.warn((String)("Sign '" + name + "' does not exist in the plugin database. Please contact the developer to add it."));
        return null;
    }

    public MapillarySign(String fullName) {
        this.fullName = fullName;
        String[] parts = fullName.split("--");
        this.category = parts[0];
        this.type = parts[1];
        this.country = parts[2];
        if (parts.length == 4) {
            this.variant = parts[3];
        }
        this.trafficoSign = TrafficoSign.getSign(this.country, this.type);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapillarySign that = (MapillarySign)o;
        return this.fullName.equals(that.fullName);
    }

    static {
        for (String country : COUNTRIES) {
            HashMap<String, MapillarySign> countryMap = new HashMap<String, MapillarySign>();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(MapillarySign.class.getResourceAsStream("/data/signs/" + country + ".cson"), "UTF-8"));){
                String line = "";
                while ((line = br.readLine()) != null) {
                    if (line.equals("")) continue;
                    String[] pair = line.replace("'", "").split(":");
                    countryMap.put(pair[0].trim(), new MapillarySign(pair[1].trim()));
                }
                map.put(country, countryMap);
                br.close();
            }
            catch (IOException e) {
                Main.error((Throwable)e);
            }
        }
    }
}

