/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.utils.ValidationUtil;

public class MapillarySequence {
    private final List<MapillaryAbstractImage> images;
    private String key;
    private long createdAt;

    public MapillarySequence() {
        this.images = new CopyOnWriteArrayList<MapillaryAbstractImage>();
    }

    public MapillarySequence(String key, long createdAt) {
        ValidationUtil.throwExceptionForInvalidSeqKey(key, true);
        this.images = new CopyOnWriteArrayList<MapillaryAbstractImage>();
        this.key = key;
        this.createdAt = createdAt;
    }

    public synchronized void add(MapillaryAbstractImage image) {
        this.images.add(image);
    }

    public synchronized void add(List<MapillaryAbstractImage> images) {
        images.forEach(this::add);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public List<MapillaryAbstractImage> getImages() {
        return this.images;
    }

    public String getKey() {
        return this.key;
    }

    public MapillaryAbstractImage next(MapillaryAbstractImage image) {
        int i = this.images.indexOf(image);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        if (i == this.images.size() - 1) {
            return null;
        }
        return this.images.get(i + 1);
    }

    public MapillaryAbstractImage previous(MapillaryAbstractImage image) {
        int i = this.images.indexOf(image);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        if (i == 0) {
            return null;
        }
        return this.images.get(i - 1);
    }

    public void remove(MapillaryAbstractImage image) {
        this.images.remove(image);
    }
}

