/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryChangesetListener;

public class MapillaryLocationChangeset
extends HashSet<MapillaryImage> {
    private static final long serialVersionUID = 2461033584553885626L;
    private final Set<MapillaryChangesetListener> listeners = new HashSet<MapillaryChangesetListener>();

    public void addChangesetListener(MapillaryChangesetListener listener) {
        this.listeners.add(listener);
    }

    public void cleanChangeset() {
        this.clear();
        this.fireListeners();
    }

    private void fireListeners() {
        this.listeners.forEach(MapillaryChangesetListener::changesetChanged);
    }

    @Override
    public boolean add(MapillaryImage image) {
        boolean add = super.add(image);
        this.fireListeners();
        return add;
    }

    @Override
    public boolean remove(Object image) {
        boolean remove = super.remove(image);
        this.fireListeners();
        return remove;
    }
}

