/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public abstract class MapillaryAbstractImage
implements Comparable<MapillaryAbstractImage> {
    private static final float EPSILON = 1.0E-5f;
    protected long capturedAt;
    private MapillarySequence sequence;
    protected LatLon latLon;
    protected double ca;
    private LatLon tempLatLon;
    private LatLon movingLatLon;
    private double tempCa;
    protected double movingCa;
    private boolean visible;

    protected MapillaryAbstractImage(LatLon latLon, double ca) {
        this.tempLatLon = this.latLon = latLon;
        this.movingLatLon = this.latLon;
        this.ca = ca;
        this.tempCa = ca;
        this.movingCa = ca;
        this.visible = true;
    }

    public double getCa() {
        return this.ca;
    }

    public long getCapturedAt() {
        return this.capturedAt;
    }

    public String getDate() {
        StringBuilder format = new StringBuilder(26);
        if (Main.pref.getBoolean("iso.dates")) {
            format.append("yyyy-MM-dd");
        } else {
            format.append("dd/MM/yyyy");
        }
        if (Main.pref.getBoolean("mapillary.display-hour", true)) {
            if (Main.pref.getBoolean("mapillary.format-24")) {
                format.append(" - HH:mm:ss (z)");
            } else {
                format.append(" - h:mm:ss a (z)");
            }
        }
        return this.getDate(format.toString());
    }

    public String getDate(String format) {
        Date date = new Date(this.getCapturedAt());
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.UK);
        formatter.setTimeZone(Calendar.getInstance().getTimeZone());
        return formatter.format(date);
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public double getMovingCa() {
        return this.movingCa;
    }

    public LatLon getMovingLatLon() {
        return this.movingLatLon;
    }

    public MapillarySequence getSequence() {
        if (this.sequence == null) {
            this.sequence = new MapillarySequence();
            this.sequence.add(this);
        }
        return this.sequence;
    }

    public double getTempCa() {
        return this.tempCa;
    }

    public LatLon getTempLatLon() {
        return this.tempLatLon;
    }

    public boolean isModified() {
        return !this.getMovingLatLon().equals((Object)this.latLon) || Math.abs(this.getMovingCa() - this.ca) > (double)1.0E-5f;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void move(double x, double y) {
        this.movingLatLon = new LatLon(this.tempLatLon.getY() + y, this.tempLatLon.getX() + x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapillaryAbstractImage next() {
        Class<MapillaryAbstractImage> clazz = MapillaryAbstractImage.class;
        synchronized (MapillaryAbstractImage.class) {
            if (this.getSequence() == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getSequence().next(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapillaryAbstractImage previous() {
        Class<MapillaryAbstractImage> clazz = MapillaryAbstractImage.class;
        synchronized (MapillaryAbstractImage.class) {
            if (this.getSequence() == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getSequence().previous(this);
        }
    }

    public void setCa(double ca) {
        this.ca = ca;
    }

    public void setCapturedAt(long capturedAt) {
        this.capturedAt = capturedAt;
    }

    public void setLatLon(LatLon latLon) {
        if (latLon != null) {
            this.latLon = latLon;
        }
    }

    public void setSequence(MapillarySequence sequence) {
        this.sequence = sequence;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void stopMoving() {
        this.tempLatLon = this.movingLatLon;
        this.tempCa = this.movingCa;
    }

    public void turn(double ca) {
        this.movingCa = this.tempCa + ca;
    }
}

