/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.swing.JFileChooser;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandImport;
import org.openstreetmap.josm.plugins.mapillary.utils.ImageUtil;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryImportAction
extends JosmAction {
    private static final long serialVersionUID = 4995924098228081806L;

    public MapillaryImportAction() {
        super(I18n.tr((String)"Import pictures", (Object[])new Object[0]), MapillaryPlugin.getProvider("icon24.png"), I18n.tr((String)"Import local pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Import Mapillary", (String)I18n.tr((String)"Import pictures into Mapillary layer", (Object[])new Object[0]), (int)65535, (int)5000), false, "mapillaryImport", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent event) {
        JFileChooser chooser = new JFileChooser();
        File startDirectory = new File(Main.pref.get("mapillary.start-directory", System.getProperty("user.home")));
        chooser.setCurrentDirectory(startDirectory);
        chooser.setDialogTitle(I18n.tr((String)"Select pictures", (Object[])new Object[0]));
        chooser.setFileSelectionMode(2);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(ImageUtil.IMAGE_FILE_FILTER);
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(Main.parent) == 0) {
            ConcurrentSkipListSet<MapillaryAbstractImage> images = new ConcurrentSkipListSet<MapillaryAbstractImage>();
            for (File file : chooser.getSelectedFiles()) {
                Main.pref.put("mapillary.start-directory", file.getParent());
                try {
                    images.addAll(ImageUtil.readImagesFrom(file, Main.map.mapView.getProjection().eastNorth2latlon(Main.map.mapView.getCenter())));
                }
                catch (IOException e) {
                    Main.error((String)("Could not read image(s) from " + file.getAbsolutePath()));
                }
            }
            MapillaryRecord.getInstance().addCommand(new CommandImport(images));
            MapillaryUtils.showAllPictures();
        }
    }
}

