/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.plugins.turnlanestagging.bean.BRoad;
import org.openstreetmap.josm.plugins.turnlanestagging.buildturnlanes.BuildTurnLanes;
import org.openstreetmap.josm.plugins.turnlanestagging.editor.TagEditor;
import org.openstreetmap.josm.plugins.turnlanestagging.editor.ac.KeyValuePair;
import org.openstreetmap.josm.plugins.turnlanestagging.preset.PresetsData;
import org.openstreetmap.josm.plugins.turnlanestagging.preset.PresetsTableModel;
import org.openstreetmap.josm.plugins.turnlanestagging.util.Util;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TurnLanesEditorDialog
extends ExtendedDialog {
    private static TurnLanesEditorDialog instance = null;
    Map<String, String> tags = new HashMap<String, String>();
    public static final Dimension PREFERRED_SIZE = new Dimension(750, 700);
    public static final Dimension MIN_SIZE = new Dimension(630, 600);
    private TagEditor tagEditor = null;
    private BuildTurnLanes buildTurnLanes = null;
    private JButton jbOk = null;
    private OKAction okAction = null;
    private CancelAction cancelAction = null;
    List<BRoad> lastEdits = new ArrayList<BRoad>();
    OsmPrimitive saveSelected = null;

    protected TurnLanesEditorDialog() {
        super(Main.parent, "", null, false, false);
        this.build();
    }

    public static TurnLanesEditorDialog getInstance() {
        if (instance == null) {
            instance = new TurnLanesEditorDialog();
        }
        return instance;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setModal(false);
        this.setSize(PREFERRED_SIZE);
        this.setTitle(I18n.tr((String)"Turn Lanes Editor", (Object[])new Object[0]));
        this.setLocation(90, 90);
        this.pack();
        JPanel pnlPresetGrid = this.buildPresetGridPanel();
        pnlPresetGrid.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel pnlTagGrid = this.buildTagGridPanel();
        JSplitPane splitPane = new JSplitPane(0, pnlPresetGrid, pnlTagGrid);
        this.setMinimumSize(MIN_SIZE);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(380);
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)this.buildButtonRowPanel(), "South");
        this.getRootPane().registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "clickButton");
        this.getRootPane().getActionMap().put("clickButton", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TurnLanesEditorDialog.this.jbOk.doClick();
            }
        });
    }

    protected JPanel buildButtonRowPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        this.okAction = new OKAction();
        this.jbOk = new JButton(this.okAction);
        pnl.add(this.jbOk);
        this.getModel().addPropertyChangeListener((PropertyChangeListener)this.okAction);
        this.cancelAction = new CancelAction();
        pnl.add(new JButton(this.cancelAction));
        return pnl;
    }

    protected JPanel buildTagGridPanel() {
        this.tagEditor = new TagEditor();
        return this.tagEditor;
    }

    public TagEditorModel getModel() {
        return this.tagEditor.getModel();
    }

    protected JPanel buildPresetGridPanel() {
        this.buildTurnLanes = new BuildTurnLanes();
        this.buildTurnLanes.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("RoadChanged")) {
                    TurnLanesEditorDialog.this.addTagOnRoad((BRoad)evt.getNewValue());
                    TurnLanesEditorDialog.this.jbOk.requestFocus();
                    TurnLanesEditorDialog.this.jbOk.setSelected(true);
                }
            }
        });
        return this.buildTurnLanes;
    }

    public PresetsTableModel getPressetTableModel() {
        return this.buildTurnLanes.getModel();
    }

    public void startEditSession() {
        if (this.waySelected() != null) {
            this.tags = this.waySelected().getKeys();
        }
        this.tagEditor.getModel().clearAppliedPresets();
        this.tagEditor.getModel().initFromJOSMSelection();
        this.getModel().ensureOneTag();
        this.setRoadProperties();
    }

    public boolean addOneway() {
        return this.waySelected().hasDirectionKeys();
    }

    public void setRoadProperties() {
        PresetsData presetsData = new PresetsData();
        BRoad bRoad = new BRoad();
        OsmPrimitive element = this.waySelected();
        if (element.hasKey("oneway")) {
            if (element.get("oneway").equals("yes")) {
                bRoad.setName("Unidirectional");
            } else if (element.get("oneway").equals("no")) {
                bRoad.setName("Bidirectional");
            }
        } else {
            bRoad.setName("Bidirectional");
        }
        for (String key : element.keySet()) {
            if (key.equals("turn:lanes")) {
                bRoad.getLanesUnid().setStringLanes("unid", element.get(key));
                bRoad.setName("Unidirectional");
                if (element.hasKey("lanes") && Util.isInt(element.get("lanes")) && Integer.valueOf(element.get("lanes")).intValue() != bRoad.getLanesUnid().getLanes().size()) {
                    new Notification(I18n.tr((String)" The number of lanes has fixed according number of turns", (Object[])new Object[0])).show();
                }
            } else if (key.equals("lanes") && Util.isInt(element.get(key)) && !element.hasKey("turn:lanes") && element.hasDirectionKeys()) {
                bRoad = presetsData.defaultRoadUnidirectional(Integer.valueOf(element.get(key)));
                bRoad.setName("Unidirectional");
            } else if (!(!key.equals("lanes") || !Util.isInt(element.get(key)) || element.hasKey("turn:lanes") || element.hasKey("turn:lanes:forward") || element.hasKey("turn:lanes:both_ways") || element.hasKey("turn:lanes:backward") || element.hasKey("lanes:forward") || element.hasKey("lanes:both_ways") || element.hasKey("lanes:backward"))) {
                bRoad = presetsData.defaultRoadUnidirectional(Integer.valueOf(element.get(key)));
                bRoad.setName("Unidirectional");
            } else if (key.equals("turn:lanes:forward")) {
                if (Util.isRightHandTraffic()) {
                    bRoad.getLanesC().setStringLanes("forward", element.get(key));
                    bRoad.getLanesC().setType("forward");
                    bRoad.setName("Bidirectional");
                    if (element.hasKey("lanes:forward") && Util.isInt(element.get("lanes:forward")) && Integer.valueOf(element.get("lanes:forward")).intValue() != bRoad.getLanesC().getLanes().size()) {
                        new Notification(I18n.tr((String)" The number of lanes:forward has fixed according number of turns", (Object[])new Object[0])).show();
                    }
                } else {
                    bRoad.getLanesA().setStringLanes("forward", element.get(key));
                    bRoad.getLanesA().setType("forward");
                    bRoad.setName("Bidirectional");
                    if (element.hasKey("lanes:forward") && Util.isInt(element.get("lanes:forward")) && Integer.valueOf(element.get("lanes:forward")).intValue() != bRoad.getLanesA().getLanes().size()) {
                        new Notification(I18n.tr((String)" The number of lanes:forward has fixed according number of turns", (Object[])new Object[0])).show();
                    }
                }
            } else if (key.equals("turn:lanes:both_ways")) {
                bRoad.getLanesB().setStringLanes("both_ways", element.get(key));
                bRoad.getLanesB().setType("both_ways");
                bRoad.setName("Bidirectional");
                if (element.hasKey("lanes:both_ways") && Util.isInt(element.get("lanes:both_ways")) && Integer.valueOf(element.get("lanes:both_ways")).intValue() != bRoad.getLanesB().getLanes().size()) {
                    new Notification(I18n.tr((String)" The number of lanes:both_ways has fixed according number of turns", (Object[])new Object[0])).show();
                }
            } else if (key.equals("turn:lanes:backward")) {
                if (Util.isRightHandTraffic()) {
                    bRoad.getLanesA().setStringLanes("backward", element.get(key));
                    bRoad.getLanesA().setType("backward");
                    bRoad.setName("Bidirectional");
                    if (element.hasKey("lanes:backward") && Util.isInt(element.get("lanes:backward")) && Integer.valueOf(element.get("lanes:backward")).intValue() != bRoad.getLanesA().getLanes().size()) {
                        new Notification(I18n.tr((String)" The number of lanes:backward has fixed according number of turns", (Object[])new Object[0])).show();
                    }
                } else {
                    bRoad.getLanesC().setStringLanes("backward", element.get(key));
                    bRoad.getLanesC().setType("backward");
                    bRoad.setName("Bidirectional");
                    if (element.hasKey("lanes:backward") && Util.isInt(element.get("lanes:backward")) && Integer.valueOf(element.get("lanes:backward")).intValue() != bRoad.getLanesC().getLanes().size()) {
                        new Notification(I18n.tr((String)" The number of lanes:backward has fixed according number of turns", (Object[])new Object[0])).show();
                    }
                }
            } else if (key.equals("lanes:forward") && Util.isInt(element.get(key)) && !element.hasKey("turn:lanes:forward")) {
                if (Util.isRightHandTraffic()) {
                    bRoad.setLanesC(presetsData.defaultLanes("forward", Integer.valueOf(element.get(key))));
                    bRoad.getLanesC().setType("forward");
                    bRoad.setName("Bidirectional");
                } else {
                    bRoad.setLanesA(presetsData.defaultLanes("forward", Integer.valueOf(element.get(key))));
                    bRoad.getLanesA().setType("forward");
                    bRoad.setName("Bidirectional");
                }
            } else if (key.equals("lanes:both_ways") && Util.isInt(element.get(key)) && !element.hasKey("turn:lanes:both_ways")) {
                bRoad.setLanesB(presetsData.defaultLanes("both_ways", Integer.valueOf(element.get(key))));
                bRoad.getLanesB().setType("both_ways");
                bRoad.setName("Bidirectional");
            } else if (key.equals("lanes:backward") && Util.isInt(element.get(key)) && !element.hasKey("turn:lanes:backward")) {
                if (Util.isRightHandTraffic()) {
                    bRoad.setLanesA(presetsData.defaultLanes("backward", Integer.valueOf(element.get(key))));
                    bRoad.getLanesA().setType("backward");
                    bRoad.setName("Bidirectional");
                } else {
                    bRoad.setLanesC(presetsData.defaultLanes("backward", Integer.valueOf(element.get(key))));
                    bRoad.getLanesC().setType("backward");
                    bRoad.setName("Bidirectional");
                }
            }
            if (!key.equals("oneway") || !element.get(key).equals("-1")) continue;
            new Notification(I18n.tr((String)"check the right direction of the way", (Object[])new Object[0])).show();
        }
        this.lastEdits = this.buildTurnLanes.getListLastEditsRoads();
        if (bRoad.getName().equals("Unidirectional")) {
            if (bRoad.getLanesUnid().getLanes().size() > 0) {
                this.buildTurnLanes.setLanesByRoadUnidirectional(bRoad);
            } else if (!this.lastEdits.isEmpty() && this.lastEdits.get(0).getName().equals("Unidirectional")) {
                this.buildTurnLanes.setLastEdit();
            } else {
                this.buildTurnLanes.startDefaultUnidirectional();
            }
        } else if (bRoad.getLanesA().getLanes().size() > 0 || bRoad.getLanesB().getLanes().size() > 0 || bRoad.getLanesC().getLanes().size() > 0) {
            if (bRoad.getLanesA().getLanes().isEmpty()) {
                bRoad.setLanesA(presetsData.defaultLanes("forward", 1));
            }
            if (bRoad.getLanesC().getLanes().isEmpty()) {
                bRoad.setLanesC(presetsData.defaultLanes("backward", 1));
            }
            this.buildTurnLanes.setLanesByRoadBidirectional(bRoad);
        } else if (!this.lastEdits.isEmpty() && this.lastEdits.get(0).getName().equals("Bidirectional")) {
            this.buildTurnLanes.setLastEdit();
        } else {
            this.buildTurnLanes.startDefaultBidirectional();
        }
    }

    public void addTagOnRoad(BRoad bRoad) {
        this.tagEditor.getModel().delete("turn:lanes");
        this.tagEditor.getModel().delete("lanes");
        this.tagEditor.getModel().delete("turn:lanes:forward");
        this.tagEditor.getModel().delete("lanes:forward");
        this.tagEditor.getModel().delete("turn:lanes:both_ways");
        this.tagEditor.getModel().delete("lanes:both_ways");
        this.tagEditor.getModel().delete("turn:lanes:backward");
        this.tagEditor.getModel().delete("lanes:backward");
        if (bRoad.getName().equals("Unidirectional")) {
            if (Util.isEmptyturnlane(bRoad.getLanesUnid().getTagturns())) {
                if (bRoad.isNone()) {
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes", Util.setNoneOnEmpty(bRoad.getLanesUnid().getTagturns())));
                } else {
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes", bRoad.getLanesUnid().getTagturns()));
                }
            }
            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes", String.valueOf(bRoad.getLanesUnid().getLanes().size())));
        } else {
            if (!bRoad.getLanesA().getLanes().isEmpty()) {
                if (bRoad.getLanesA().getType().equals("forward")) {
                    if (Util.isEmptyturnlane(bRoad.getLanesA().getTagturns())) {
                        if (bRoad.isNone()) {
                            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:forward", Util.setNoneOnEmpty(bRoad.getLanesA().getTagturns())));
                        } else {
                            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:forward", bRoad.getLanesA().getTagturns()));
                        }
                    }
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:forward", String.valueOf(bRoad.getLanesA().getLanes().size())));
                } else {
                    if (Util.isEmptyturnlane(bRoad.getLanesA().getTagturns())) {
                        if (bRoad.isNone()) {
                            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:backward", Util.setNoneOnEmpty(bRoad.getLanesA().getTagturns())));
                        } else {
                            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:backward", bRoad.getLanesA().getTagturns()));
                        }
                    }
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:backward", String.valueOf(bRoad.getLanesA().getLanes().size())));
                }
            }
            if (!bRoad.getLanesB().getLanes().isEmpty()) {
                if (Util.isEmptyturnlane(bRoad.getLanesB().getTagturns())) {
                    if (bRoad.isNone()) {
                        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:both_ways", Util.setNoneOnEmpty(bRoad.getLanesB().getTagturns())));
                    } else {
                        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:both_ways", bRoad.getLanesB().getTagturns()));
                    }
                }
                this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:both_ways", String.valueOf(bRoad.getLanesB().getLanes().size())));
            }
            if (!bRoad.getLanesC().getLanes().isEmpty()) {
                if (bRoad.getLanesC().getType().equals("backward")) {
                    if (Util.isEmptyturnlane(bRoad.getLanesC().getTagturns())) {
                        if (bRoad.isNone()) {
                            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:backward", Util.setNoneOnEmpty(bRoad.getLanesC().getTagturns())));
                        } else {
                            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:backward", bRoad.getLanesC().getTagturns()));
                        }
                    }
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:backward", String.valueOf(bRoad.getLanesC().getLanes().size())));
                } else {
                    if (Util.isEmptyturnlane(bRoad.getLanesC().getTagturns())) {
                        if (bRoad.isNone()) {
                            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:forward", Util.setNoneOnEmpty(bRoad.getLanesC().getTagturns())));
                        } else {
                            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:forward", bRoad.getLanesC().getTagturns()));
                        }
                    }
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:forward", String.valueOf(bRoad.getLanesC().getLanes().size())));
                }
            }
            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes", String.valueOf(bRoad.getNumLanesBidirectional())));
        }
        this.tagEditor.repaint();
        this.setPreview(this.waySelected());
    }

    public void setPreview(OsmPrimitive osmps) {
        if (osmps != null) {
            osmps.setKeys(this.tagEditor.getModel().getTags());
        }
    }

    public void resetPreview(OsmPrimitive osmprs) {
        if (osmprs != null) {
            osmprs.setKeys(this.tags);
            osmprs.setModified(false);
            this.saveSelected = null;
        }
    }

    public OsmPrimitive waySelected() {
        Collection selection;
        Iterator iterator;
        if (this.saveSelected != null && !Main.getLayerManager().getEditDataSet().getSelected().contains(this.saveSelected)) {
            this.resetPreview(this.saveSelected);
        }
        if ((iterator = (selection = Main.getLayerManager().getEditDataSet().getSelected()).iterator()).hasNext()) {
            OsmPrimitive element;
            this.saveSelected = element = (OsmPrimitive)iterator.next();
            return element;
        }
        return null;
    }

    public void setEnableOK(boolean active) {
        this.jbOk.setEnabled(active);
    }

    class OKAction
    extends AbstractAction
    implements PropertyChangeListener {
        public OKAction() {
            this.putValue("Name", I18n.tr((String)"OK", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
            this.putValue("ShortDescription", I18n.tr((String)"Apply edited tags and close dialog", (Object[])new Object[0]));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl ENTER"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
            TurnLanesEditorDialog.this.buildTurnLanes.addLastEditInTable();
            TurnLanesEditorDialog.this.buildTurnLanes.clearSelection();
        }

        public void run() {
            TurnLanesEditorDialog.this.tagEditor.stopEditing();
            TurnLanesEditorDialog.this.setVisible(false);
            TurnLanesEditorDialog.this.waySelected().setKeys(TurnLanesEditorDialog.this.tags);
            TurnLanesEditorDialog.this.tagEditor.getModel().updateJOSMSelection();
            DataSet ds = Main.getLayerManager().getEditDataSet();
            ds.fireSelectionChanged();
            Main.parent.repaint();
            TurnLanesEditorDialog.this.saveSelected = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(TagEditorModel.PROP_DIRTY)) {
                return;
            }
            if (!evt.getNewValue().getClass().equals(Boolean.class)) {
                return;
            }
            this.setEnabled(true);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
            this.putValue("ShortDescription", I18n.tr((String)"Abort tag editing and close dialog", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (TurnLanesEditorDialog.this.waySelected() != null) {
                TurnLanesEditorDialog.this.waySelected().setKeys(TurnLanesEditorDialog.this.tags);
                TurnLanesEditorDialog.this.waySelected().setModified(false);
            }
            TurnLanesEditorDialog.this.setVisible(false);
        }
    }
}

