/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.utils;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public class RouteUtils {
    private RouteUtils() {
    }

    public static boolean isTwoDirectionRoute(Relation r) {
        if (r == null) {
            return false;
        }
        if (!r.hasKey("route") || !r.hasTag("public_transport:version", "2")) {
            return false;
        }
        return (r.hasTag("route", "bus") || r.hasTag("route", "trolleybus") || r.hasTag("route", "share_taxi") || r.hasTag("route", "tram") || r.hasTag("route", "light_rail") || r.hasTag("route", "subway") || r.hasTag("route", "train")) && !r.hasTag("bus", "on_demand");
    }

    public static boolean isPTStop(RelationMember rm) {
        if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
            return true;
        }
        return rm.getType().equals((Object)OsmPrimitiveType.WAY) && (rm.getWay().hasTag("public_transport", "platform") || rm.getWay().hasTag("highway", "platform") || rm.getWay().hasTag("railway", "platform"));
    }

    public static boolean isPTWay(RelationMember rm) {
        if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
            return false;
        }
        if (rm.getType().equals((Object)OsmPrimitiveType.WAY)) {
            return !rm.getWay().hasTag("public_transport", "platform") && !rm.getWay().hasTag("highway", "platform") && !rm.getWay().hasTag("railway", "platform");
        }
        Relation nestedRelation = rm.getRelation();
        for (RelationMember nestedRelationMember : nestedRelation.getMembers()) {
            if (nestedRelationMember.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            return false;
        }
        return true;
    }

    public static int isOnewayForPublicTransport(Way way) {
        if (!(!OsmUtils.isTrue((String)way.get("oneway")) && !OsmUtils.isReversed((String)way.get("oneway")) && !way.hasTag("junction", "roundabout") && !way.hasTag("highway", "motorway") || way.hasTag("busway", "lane") || way.hasTag("busway:left", "lane") || way.hasTag("busway:right", "lane") || way.hasTag("oneway:bus", "no") || way.hasTag("busway", "opposite_lane") || way.hasTag("oneway:psv", "no") || way.hasTag("trolley_wire", "backward"))) {
            if (OsmUtils.isReversed((String)way.get("oneway"))) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static boolean waysTouch(Way w1, Way w2) {
        if (w1 == null || w2 == null) {
            return false;
        }
        Node w1FirstNode = w1.firstNode();
        Node w1LastNode = w1.lastNode();
        Node w2FirstNode = w2.firstNode();
        Node w2LastNode = w2.lastNode();
        return w1FirstNode == w2FirstNode || w1FirstNode == w2LastNode || w1LastNode == w2FirstNode || w1LastNode == w2LastNode;
    }

    public static boolean waysTouch(Collection<Way> c1, Collection<Way> c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        for (Way w1 : c1) {
            for (Way w2 : c2) {
                if (!RouteUtils.waysTouch(w1, w2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWaySuitableForBuses(Way way) {
        if (way.hasTag("highway", "motorway") || way.hasTag("highway", "trunk") || way.hasTag("highway", "primary") || way.hasTag("highway", "secondary") || way.hasTag("highway", "tertiary") || way.hasTag("highway", "unclassified") || way.hasTag("highway", "road") || way.hasTag("highway", "residential") || way.hasTag("highway", "service") || way.hasTag("highway", "motorway_link") || way.hasTag("highway", "trunk_link") || way.hasTag("highway", "primary_link") || way.hasTag("highway", "secondary_link") || way.hasTag("highway", "tertiary_link") || way.hasTag("highway", "living_street") || way.hasTag("highway", "bus_guideway") || way.hasTag("highway", "road") || way.hasTag("cycleway", "share_busway") || way.hasTag("cycleway", "shared_lane")) {
            return true;
        }
        return way.hasTag("highway", "pedestrian") && (way.hasTag("bus", "yes") || way.hasTag("psv", "yes") || way.hasTag("bus", "designated") || way.hasTag("psv", "designated"));
    }

    public static boolean isWaySuitableForPublicTransport(Way way) {
        return RouteUtils.isWaySuitableForBuses(way) || way.hasTag("railway", "tram") || way.hasTag("railway", "subway") || way.hasTag("railway", "subway") || way.hasTag("railway", "light_rail") || way.hasTag("railway", "rail");
    }
}

