/*
 * Decompiled with CFR 0.152.
 */
package com.tilusnet.josm.plugins.alignways;

import com.tilusnet.josm.plugins.alignways.AlignWaysPlugin;
import com.tilusnet.josm.plugins.alignways.AlignWaysSegmentMgr;
import com.tilusnet.josm.plugins.alignways.AlignWaysSelAlgnState;
import com.tilusnet.josm.plugins.alignways.AlignWaysSelBothState;
import com.tilusnet.josm.plugins.alignways.AlignWaysSelNoneState;
import com.tilusnet.josm.plugins.alignways.AlignWaysSelRefState;
import com.tilusnet.josm.plugins.alignways.AlignWaysState;
import com.tilusnet.josm.plugins.alignways.AlignWaysTipsPanel;
import com.tilusnet.josm.plugins.alignways.AlignWaysWhatsNewPanel;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AlignWaysMode
extends MapMode {
    private static final long serialVersionUID = -1090955708412011141L;
    private final AlignWaysState noneSelected = new AlignWaysSelNoneState();
    private final AlignWaysState referenceSelected = new AlignWaysSelRefState();
    private final AlignWaysState aligneeSelected = new AlignWaysSelAlgnState();
    private final AlignWaysState bothSelected = new AlignWaysSelBothState();
    private AlignWaysState currentState;
    private AlignWaysSegmentMgr awSegs;
    boolean tipShown = false;

    public AlignWaysMode(MapFrame mapFrame, String name, String desc) {
        super(I18n.tr((String)name, (Object[])new Object[0]), "alignways.png", I18n.tr((String)desc, (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:alignways", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Align Ways", (Object[])new Object[0])}), (int)78, (int)5005), mapFrame, Cursor.getPredefinedCursor(0));
    }

    public void enterMode() {
        int majorVer;
        boolean showTips;
        super.enterMode();
        AlignWaysPlugin.getAwDialog().activate(true);
        IconToggleButton optBtn = AlignWaysPlugin.getOptBtn();
        if (!optBtn.isSelected()) {
            optBtn.doClick();
        }
        if ((showTips = Boolean.parseBoolean(Main.pref.get("alignways.showtips", "true"))) && !this.tipShown) {
            this.showTips();
        }
        if ((majorVer = Integer.parseInt(Main.pref.get("alignways.majorver", "-1"))) != 2) {
            this.showWhatsNew();
        }
        this.awSegs = AlignWaysSegmentMgr.getInstance(Main.map.mapView);
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        this.setCurrentState(this.noneSelected);
    }

    public void exitMode() {
        super.exitMode();
        AlignWaysPlugin.getAwDialog().activate(false);
        IconToggleButton optBtn = AlignWaysPlugin.getOptBtn();
        if (optBtn.isSelected()) {
            optBtn.doClick();
        }
        this.setCurrentState(this.noneSelected);
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        AlignWaysPlugin.getAwAction().setEnabled(false);
    }

    public void mouseClicked(MouseEvent e) {
        boolean altPressed;
        boolean ctrlPressed = (e.getModifiers() & 2) != 0;
        boolean bl = altPressed = (e.getModifiers() & 0x28) != 0;
        if (e.getButton() == 1) {
            if (altPressed) {
                this.currentState.altLClick(this);
            } else {
                Point clickedPoint = new Point(e.getX(), e.getY());
                if (!ctrlPressed) {
                    if (this.awSegs.algnUpdate(clickedPoint)) {
                        this.currentState.leftClick(this);
                    }
                } else if (this.awSegs.refUpdate(clickedPoint)) {
                    this.currentState.ctrlLClick(this);
                }
            }
        }
        if (this.currentState == this.bothSelected) {
            AlignWaysPlugin.getAwAction().setEnabled(true);
        } else {
            AlignWaysPlugin.getAwAction().setEnabled(false);
        }
        Main.map.mapView.repaint();
    }

    public void setCurrentState(AlignWaysState currentState) {
        this.currentState = currentState;
        currentState.setHelpText();
        if (currentState == this.noneSelected) {
            this.awSegs.cleanupWays();
            DataSet ds = this.getLayerManager().getEditDataSet();
            if (ds != null) {
                ds.clearSelection();
            }
        }
    }

    public AlignWaysState getNoneSelected() {
        return this.noneSelected;
    }

    public AlignWaysState getReferenceSelected() {
        return this.referenceSelected;
    }

    public AlignWaysState getAligneeSelected() {
        return this.aligneeSelected;
    }

    public AlignWaysState getBothSelected() {
        return this.bothSelected;
    }

    public AlignWaysState getCurrentState() {
        return this.currentState;
    }

    private void showTips() {
        AlignWaysTipsPanel atp = new AlignWaysTipsPanel();
        Object[] okButton = new Object[]{I18n.tr((String)"I''m ready!", (Object[])new Object[0])};
        JOptionPane tipPane = new JOptionPane(atp, -1, -1, null, okButton, okButton[0]);
        tipPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 30, 10));
        JDialog tipDialog = tipPane.createDialog(Main.parent, I18n.tr((String)"AlignWays Tips", (Object[])new Object[0]));
        tipDialog.setIconImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/alignways.png")).getImage());
        tipDialog.setResizable(true);
        tipDialog.setVisible(true);
        this.tipShown = true;
        tipDialog.dispose();
        Main.pref.put("alignways.showtips", !atp.isChkBoxSelected());
    }

    private void showWhatsNew() {
        AlignWaysWhatsNewPanel awnp = new AlignWaysWhatsNewPanel();
        JOptionPane wnPane = new JOptionPane(awnp, -1, -1, null);
        wnPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JDialog wnDialog = wnPane.createDialog(Main.parent, I18n.tr((String)"AlignWays: What''s New...", (Object[])new Object[0]));
        wnDialog.setIconImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/alignways.png")).getImage());
        wnDialog.setResizable(true);
        wnDialog.setVisible(true);
        wnDialog.dispose();
        Main.pref.put("alignways.majorver", Integer.toString(2));
    }

    public boolean layerIsSupported(Layer l) {
        return l != null;
    }
}

