/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.pt_assistant.PTAssistantPlugin;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteSegment;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayer;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.tools.I18n;

public class SegmentChecker
extends Checker {
    private static List<PTRouteSegment> correctSegments = new ArrayList<PTRouteSegment>();
    private static HashMap<TestError, PTRouteSegment> wrongSegments = new HashMap();
    private PTRouteDataManager manager;
    private StopToWayAssigner assigner;

    public SegmentChecker(Relation relation, Test test) {
        super(relation, test);
        this.manager = new PTRouteDataManager(relation);
        for (RelationMember rm : this.manager.getFailedMembers()) {
            ArrayList<Relation> primitives = new ArrayList<Relation>(1);
            primitives.add(relation);
            ArrayList<OsmPrimitive> highlighted = new ArrayList<OsmPrimitive>(1);
            highlighted.add(rm.getMember());
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Relation member roles do not match tags", (Object[])new Object[0]), 3743, primitives, highlighted);
            this.errors.add(e);
        }
        this.assigner = new StopToWayAssigner(this.manager.getPTWays());
    }

    public static int getCorrectSegmentCount() {
        return correctSegments.size();
    }

    public static synchronized void addCorrectSegment(PTRouteSegment segment) {
        for (PTRouteSegment correctSegment : correctSegments) {
            if (!correctSegment.equalsRouteSegment(segment)) continue;
            return;
        }
        correctSegments.add(segment);
    }

    public void performFirstStopTest() {
        this.performEndStopTest(this.manager.getFirstStop());
    }

    public void performLastStopTest() {
        this.performEndStopTest(this.manager.getLastStop());
    }

    private void performEndStopTest(PTStop endStop) {
        if (endStop == null) {
            return;
        }
        if (endStop.getStopPosition() == null) {
            ArrayList<Object> highlighted;
            ArrayList<Relation> primitives;
            List<Node> potentialStopPositionList = endStop.findPotentialStopPositions();
            ArrayList<Node> stopPositionsOfThisRoute = new ArrayList<Node>();
            boolean containsAtLeastOneStopPositionAsFirstOrLastNode = false;
            for (Node potentialStopPosition : potentialStopPositionList) {
                int belongsToWay = this.belongsToAWayOfThisRoute(potentialStopPosition);
                if (belongsToWay == 0) {
                    stopPositionsOfThisRoute.add(potentialStopPosition);
                    containsAtLeastOneStopPositionAsFirstOrLastNode = true;
                }
                if (belongsToWay != 1) continue;
                stopPositionsOfThisRoute.add(potentialStopPosition);
            }
            if (stopPositionsOfThisRoute.isEmpty()) {
                primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                highlighted = new ArrayList<Object>(1);
                highlighted.add(endStop.getPlatform());
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route should start and end with a stop_position", (Object[])new Object[0]), 3741, primitives, highlighted);
                this.errors.add(e);
                return;
            }
            if (stopPositionsOfThisRoute.size() == 1) {
                endStop.setStopPosition((Node)stopPositionsOfThisRoute.get(0));
            }
            if (!containsAtLeastOneStopPositionAsFirstOrLastNode) {
                primitives = new ArrayList(1);
                primitives.add(this.relation);
                highlighted = new ArrayList();
                highlighted.addAll(stopPositionsOfThisRoute);
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: First or last way needs to be split", (Object[])new Object[0]), 3742, primitives, highlighted);
                this.errors.add(e);
            }
        } else {
            int belongsToWay = this.belongsToAWayOfThisRoute(endStop.getStopPosition());
            if (belongsToWay == 1) {
                ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                ArrayList<Node> highlighted = new ArrayList<Node>();
                highlighted.add(endStop.getStopPosition());
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: First or last way needs to be split", (Object[])new Object[0]), 3742, primitives, highlighted);
                this.errors.add(e);
            }
        }
    }

    private int belongsToAWayOfThisRoute(Node node) {
        boolean contains = false;
        List<PTWay> ptways = this.manager.getPTWays();
        for (PTWay ptway : ptways) {
            List<Way> ways = ptway.getWays();
            for (Way way : ways) {
                if (!way.containsNode(node)) continue;
                if (way.firstNode().equals((Object)node) || way.lastNode().equals((Object)node)) {
                    return 0;
                }
                contains = true;
            }
        }
        if (contains) {
            return 1;
        }
        return -1;
    }

    public void performStopNotServedTest() {
        for (PTStop stop : this.manager.getPTStops()) {
            Way way = this.assigner.get(stop);
            if (way != null) continue;
            this.createStopError(stop);
        }
    }

    public void performStopByStopTest() {
        if (this.manager.getPTStopCount() < 2) {
            return;
        }
        for (int i = 1; i < this.manager.getPTStopCount(); ++i) {
            PTRouteSegment routeSegment;
            PTStop startStop = this.manager.getPTStops().get(i - 1);
            PTStop endStop = this.manager.getPTStops().get(i);
            Way startWay = this.assigner.get(startStop);
            Way endWay = this.assigner.get(endStop);
            if (startWay == null || endWay == null || startWay == endWay && startWay == this.manager.getLastWay()) continue;
            List<PTWay> segmentWays = this.manager.getPTWaysBetween(startWay, endWay);
            Node firstNode = this.findFirstNodeOfRouteSegmentInDirectionOfTravel(segmentWays.get(0));
            if (firstNode == null) {
                if (!this.errors.isEmpty() && ((TestError)this.errors.get(this.errors.size() - 1)).getHighlighted().size() == 1 && ((TestError)this.errors.get(this.errors.size() - 1)).getHighlighted().iterator().next() == startWay) continue;
                ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                primitives.add(this.relation);
                ArrayList<Way> highlighted = new ArrayList<Way>();
                highlighted.add(startWay);
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Problem in the route segment", (Object[])new Object[0]), 3754, primitives, highlighted);
                this.errors.add(e);
                PTRouteSegment routeSegment2 = new PTRouteSegment(startStop, endStop, segmentWays, this.relation);
                wrongSegments.put(e, routeSegment2);
                continue;
            }
            boolean sortingCorrect = this.existingWaySortingIsCorrect(segmentWays.get(0), firstNode, segmentWays.get(segmentWays.size() - 1));
            if (sortingCorrect) {
                routeSegment = new PTRouteSegment(startStop, endStop, segmentWays, this.relation);
                SegmentChecker.addCorrectSegment(routeSegment);
                continue;
            }
            routeSegment = new PTRouteSegment(startStop, endStop, segmentWays, this.relation);
            TestError error = (TestError)this.errors.get(this.errors.size() - 1);
            wrongSegments.put(error, routeSegment);
        }
    }

    private void createStopError(PTStop stop) {
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        ArrayList<OsmPrimitive> highlighted = new ArrayList<OsmPrimitive>();
        OsmPrimitive stopPrimitive = stop.getPlatform();
        if (stopPrimitive == null) {
            stopPrimitive = stop.getStopPosition();
        }
        highlighted.add(stopPrimitive);
        TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop not served", (Object[])new Object[0]), 3753, primitives, highlighted);
        this.errors.add(e);
    }

    private Node findFirstNodeOfRouteSegmentInDirectionOfTravel(PTWay startWay) {
        Node[] startWayEndnodes = startWay.getEndNodes();
        if (this.isDeadendNode(startWayEndnodes[0])) {
            return startWayEndnodes[0];
        }
        if (this.isDeadendNode(startWayEndnodes[1])) {
            return startWayEndnodes[1];
        }
        PTWay nextWay = this.manager.getNextPTWay(startWay);
        if (nextWay == null) {
            return null;
        }
        PTWay wayAfterNext = this.manager.getNextPTWay(nextWay);
        Node[] nextWayEndnodes = nextWay.getEndNodes();
        if (startWayEndnodes[0] == nextWayEndnodes[0] && startWayEndnodes[1] == nextWayEndnodes[1] || startWayEndnodes[0] == nextWayEndnodes[1] && startWayEndnodes[1] == nextWayEndnodes[0]) {
            Node[] wayAfterNextEndnodes = wayAfterNext.getEndNodes();
            if (startWayEndnodes[0] == wayAfterNextEndnodes[0] || startWayEndnodes[0] == wayAfterNextEndnodes[1]) {
                return startWayEndnodes[0];
            }
            if (startWayEndnodes[1] == wayAfterNextEndnodes[0] || startWayEndnodes[1] == wayAfterNextEndnodes[1]) {
                return startWayEndnodes[1];
            }
        }
        if (startWayEndnodes[0] == nextWayEndnodes[0] || startWayEndnodes[0] == nextWayEndnodes[1]) {
            return startWayEndnodes[1];
        }
        if (startWayEndnodes[1] == nextWayEndnodes[0] || startWayEndnodes[1] == nextWayEndnodes[1]) {
            return startWayEndnodes[0];
        }
        return null;
    }

    private boolean isDeadendNode(Node node) {
        int count = 0;
        for (PTWay ptway : this.manager.getPTWays()) {
            List<Way> ways = ptway.getWays();
            for (Way way : ways) {
                if (way.firstNode() != node && way.lastNode() != node) continue;
                ++count;
            }
        }
        return count == 1;
    }

    private Node findClosestDeadendNode(LatLon coord, List<Node> deadendNodes) {
        Node closestDeadendNode = null;
        double minSqDistance = Double.MAX_VALUE;
        for (Node deadendNode : deadendNodes) {
            double distanceSq = coord.distanceSq(deadendNode.getCoor());
            if (!(distanceSq < minSqDistance)) continue;
            minSqDistance = distanceSq;
            closestDeadendNode = deadendNode;
        }
        return closestDeadendNode;
    }

    private boolean existingWaySortingIsCorrect(PTWay start, Node startWayPreviousNodeInDirectionOfTravel, PTWay end) {
        if (start == end) {
            return true;
        }
        PTWay current = start;
        Node currentNode = startWayPreviousNodeInDirectionOfTravel;
        while (!current.equals((Object)end)) {
            PTWay nextPTWayAccortingToExistingSorting = this.manager.getNextPTWay(current);
            if (current.containsUnsplitRoundabout()) {
                currentNode = this.manager.getCommonNode(current, nextPTWayAccortingToExistingSorting);
                if (currentNode == null) {
                    ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                    primitives.add(this.relation);
                    ArrayList<Way> highlighted = new ArrayList<Way>();
                    highlighted.addAll(current.getWays());
                    TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Problem in the route segment", (Object[])new Object[0]), 3754, primitives, highlighted);
                    this.errors.add(e);
                    return false;
                }
            } else {
                List<PTWay> nextWaysInDirectionOfTravel = this.findNextPTWaysInDirectionOfTravel(current, currentNode = this.getOppositeEndNode(current, currentNode));
                if (!nextWaysInDirectionOfTravel.contains((Object)nextPTWayAccortingToExistingSorting)) {
                    ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                    primitives.add(this.relation);
                    ArrayList<Way> highlighted = new ArrayList<Way>();
                    highlighted.addAll(current.getWays());
                    TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Problem in the route segment", (Object[])new Object[0]), 3754, primitives, highlighted);
                    this.errors.add(e);
                    return false;
                }
            }
            current = nextPTWayAccortingToExistingSorting;
        }
        return true;
    }

    private Node getOppositeEndNode(Way way, Node node) {
        if (node == way.firstNode()) {
            return way.lastNode();
        }
        if (node == way.lastNode()) {
            return way.firstNode();
        }
        return null;
    }

    private Node getOppositeEndNode(PTWay ptway, Node node) {
        if (ptway.isWay()) {
            return this.getOppositeEndNode(ptway.getWays().get(0), node);
        }
        Way firstWay = ptway.getWays().get(0);
        Way lastWay = ptway.getWays().get(ptway.getWays().size() - 1);
        Node oppositeNode = node;
        if (firstWay.firstNode() == node || firstWay.lastNode() == node) {
            for (int i = 0; i < ptway.getWays().size(); ++i) {
                oppositeNode = this.getOppositeEndNode(ptway.getWays().get(i), oppositeNode);
            }
            return oppositeNode;
        }
        if (lastWay.firstNode() == node || lastWay.lastNode() == node) {
            for (int i = ptway.getWays().size() - 1; i >= 0; --i) {
                oppositeNode = this.getOppositeEndNode(ptway.getWays().get(i), oppositeNode);
            }
            return oppositeNode;
        }
        return null;
    }

    private List<PTWay> findNextPTWaysInDirectionOfTravel(PTWay currentWay, Node nextNodeInDirectionOfTravel) {
        ArrayList<PTWay> nextPtways = new ArrayList<PTWay>();
        List<PTWay> ptways = this.manager.getPTWays();
        for (PTWay ptway : ptways) {
            if (ptway == currentWay) continue;
            for (Way way : ptway.getWays()) {
                if (!way.containsNode(nextNodeInDirectionOfTravel)) continue;
                nextPtways.add(ptway);
            }
        }
        return nextPtways;
    }

    protected static boolean isFixable(TestError testError) {
        return testError.getCode() == 3754;
    }

    private static boolean isFixableByUsingCorrectSegment(TestError testError) {
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        PTRouteSegment correctSegment = null;
        for (PTRouteSegment segment : correctSegments) {
            if (!wrongSegment.getFirstStop().equalsStop(segment.getFirstStop()) || !wrongSegment.getLastStop().equalsStop(segment.getLastStop())) continue;
            correctSegment = segment;
            break;
        }
        return correctSegment != null;
    }

    private static boolean isFixableBySortingAndRemoval(TestError testError) {
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        List<List<PTWay>> fixVariants = wrongSegment.getFixVariants();
        return !fixVariants.isEmpty();
    }

    protected void findFixes() {
        for (TestError error : wrongSegments.keySet()) {
            this.findFix(error);
            PTRouteSegment wrongSegment = wrongSegments.get(error);
            ArrayList<PTRouteSegment> correctSegmentsForThisError = new ArrayList<PTRouteSegment>();
            for (PTRouteSegment segment : correctSegments) {
                if (wrongSegment.getFirstWay().getId() != segment.getFirstWay().getId() || wrongSegment.getLastWay().getId() != segment.getLastWay().getId()) continue;
                correctSegmentsForThisError.add(segment);
            }
            int numberOfFixes = correctSegmentsForThisError.size();
            if (numberOfFixes == 0) {
                numberOfFixes = wrongSegment.getFixVariants().size();
            }
            if (numberOfFixes == 0) {
                for (PTRouteSegment segment : correctSegments) {
                    if (!wrongSegment.getFirstStop().equalsStop(segment.getFirstStop()) || !wrongSegment.getLastStop().equalsStop(segment.getLastStop())) continue;
                    correctSegmentsForThisError.add(segment);
                }
                numberOfFixes = correctSegmentsForThisError.size();
            }
            if (numberOfFixes == 0) {
                error.setMessage(I18n.tr((String)"PT: Problem in the route segment with no automatic fix", (Object[])new Object[0]));
                continue;
            }
            if (numberOfFixes == 1) {
                error.setMessage(I18n.tr((String)"PT: Problem in the route segment with one automatic fix", (Object[])new Object[0]));
                continue;
            }
            error.setMessage("PT: Problem in the route segment with several automatic fixes");
        }
    }

    private void findFix(TestError testError) {
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        PTWay startPTWay = wrongSegment.getFirstPTWay();
        PTWay endPTWay = wrongSegment.getLastPTWay();
        Node previousNode = this.findFirstNodeOfRouteSegmentInDirectionOfTravel(startPTWay);
        if (previousNode == null) {
            return;
        }
        ArrayList<List<PTWay>> initialFixes = new ArrayList<List<PTWay>>();
        ArrayList<PTWay> initialFix = new ArrayList<PTWay>();
        initialFix.add(startPTWay);
        initialFixes.add(initialFix);
        List<List<PTWay>> allFixes = this.findWaysForFix(initialFixes, initialFix, previousNode, endPTWay);
        for (List<PTWay> fix : allFixes) {
            if (fix.isEmpty() || !fix.get(fix.size() - 1).equals((Object)endPTWay)) continue;
            wrongSegment.addFixVariant(fix);
        }
    }

    private List<List<PTWay>> findWaysForFix(List<List<PTWay>> allFixes, List<PTWay> currentFix, Node previousNode, PTWay endWay) {
        Node nextNode;
        PTWay currentWay = currentFix.get(currentFix.size() - 1);
        List<PTWay> nextWays = this.findNextPTWaysInDirectionOfTravel(currentWay, nextNode = this.getOppositeEndNode(currentWay, previousNode));
        if (nextWays.size() > 1) {
            for (int i = 1; i < nextWays.size(); ++i) {
                ArrayList<PTWay> newFix = new ArrayList<PTWay>();
                newFix.addAll(currentFix);
                newFix.add(nextWays.get(i));
                allFixes.add(newFix);
                if (nextWays.get(i).equals((Object)endWay) || currentFix.contains((Object)nextWays.get(i))) continue;
                allFixes = this.findWaysForFix(allFixes, newFix, nextNode, endWay);
            }
        }
        if (!nextWays.isEmpty()) {
            boolean contains = currentFix.contains((Object)nextWays.get(0));
            currentFix.add(nextWays.get(0));
            if (!nextWays.get(0).equals((Object)endWay) && !contains) {
                allFixes = this.findWaysForFix(allFixes, currentFix, nextNode, endWay);
            }
        }
        return allFixes;
    }

    protected static Command fixError(TestError testError) {
        ((PTAssistantValidatorTest)testError.getTester()).clearFixVariants();
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        ArrayList<PTRouteSegment> correctSegmentsForThisError = new ArrayList<PTRouteSegment>();
        for (PTRouteSegment segment : correctSegments) {
            if (wrongSegment.getFirstWay().getId() != segment.getFirstWay().getId() || wrongSegment.getLastWay().getId() != segment.getLastWay().getId()) continue;
            correctSegmentsForThisError.add(segment);
        }
        if (correctSegmentsForThisError.isEmpty() && wrongSegment.getFixVariants().isEmpty()) {
            for (PTRouteSegment segment : correctSegments) {
                if (!wrongSegment.getFirstStop().equalsStop(segment.getFirstStop()) || !wrongSegment.getLastStop().equalsStop(segment.getLastStop())) continue;
                correctSegmentsForThisError.add(segment);
            }
            if (!correctSegmentsForThisError.isEmpty()) {
                if (SwingUtilities.isEventDispatchThread()) {
                    Notification notification = new Notification(I18n.tr((String)"Warning: the diplayed fix variants are based on less strict criteria", (Object[])new Object[0]));
                    notification.show();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Notification notification = new Notification(I18n.tr((String)"Warning: the diplayed fix variants are based on less strict criteria", (Object[])new Object[0]));
                            notification.show();
                        }
                    });
                }
            }
        }
        if (!correctSegmentsForThisError.isEmpty()) {
            if (correctSegmentsForThisError.size() > 1) {
                ArrayList<List<PTWay>> fixVariants = new ArrayList<List<PTWay>>();
                for (PTRouteSegment segment : correctSegmentsForThisError) {
                    fixVariants.add(segment.getPTWays());
                }
                SegmentChecker.displayFixVariants(fixVariants, testError);
                return null;
            }
            PTAssistantPlugin.setLastFix((PTRouteSegment)correctSegmentsForThisError.get(0));
            return SegmentChecker.carryOutSingleFix(testError, ((PTRouteSegment)correctSegmentsForThisError.get(0)).getPTWays());
        }
        if (!wrongSegment.getFixVariants().isEmpty()) {
            if (wrongSegment.getFixVariants().size() > 1) {
                SegmentChecker.displayFixVariants(wrongSegment.getFixVariants(), testError);
                return null;
            }
            PTAssistantPlugin.setLastFix(new PTRouteSegment(wrongSegment.getFirstStop(), wrongSegment.getLastStop(), wrongSegment.getFixVariants().get(0), (Relation)testError.getPrimitives().iterator().next()));
            return SegmentChecker.carryOutSingleFix(testError, wrongSegment.getFixVariants().get(0));
        }
        return SegmentChecker.fixErrorByZooming(testError);
    }

    private static void displayFixVariants(List<List<PTWay>> fixVariants, TestError testError) {
        char alphabet = 'A';
        final ArrayList<Character> allowedCharacters = new ArrayList<Character>();
        for (int i = 0; i < fixVariants.size(); ++i) {
            allowedCharacters.add(Character.valueOf(alphabet));
            alphabet = (char)(alphabet + '\u0001');
        }
        final ArrayList<OsmPrimitive> waysToZoom = new ArrayList<OsmPrimitive>();
        for (Object highlightedPrimitive : testError.getHighlighted()) {
            waysToZoom.add((OsmPrimitive)highlightedPrimitive);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            AutoScaleAction.zoomTo(waysToZoom);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoScaleAction.zoomTo((Collection)waysToZoom);
                }
            });
        }
        final PTAssistantValidatorTest test = (PTAssistantValidatorTest)testError.getTester();
        test.addFixVariants(fixVariants);
        PTAssistantLayer.getLayer().repaint((Relation)testError.getPrimitives().iterator().next());
        final TestError testErrorParameter = testError;
        Main.map.mapView.requestFocus();
        Main.map.mapView.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Character typedKey = Character.valueOf(e.getKeyChar());
                Character typedKeyUpperCase = Character.valueOf(typedKey.toString().toUpperCase().toCharArray()[0]);
                if (allowedCharacters.contains(typedKeyUpperCase)) {
                    Main.map.mapView.removeKeyListener((KeyListener)this);
                    List<PTWay> selectedFix = test.getFixVariant(typedKeyUpperCase);
                    test.clearFixVariants();
                    SegmentChecker.carryOutSelectedFix(testErrorParameter, selectedFix);
                }
                if (e.getKeyCode() == 27) {
                    Main.map.mapView.removeKeyListener((KeyListener)this);
                    test.clearFixVariants();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        if (SwingUtilities.isEventDispatchThread()) {
            Notification notification = new Notification(I18n.tr((String)"Type letter to select the fix variant or press Escape for no fix", (Object[])new Object[0]));
            notification.show();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Notification notification = new Notification(I18n.tr((String)"Type letter to select the fix variant or press Escape for no fix", (Object[])new Object[0]));
                    notification.show();
                }
            });
        }
    }

    private static void carryOutSelectedFix(TestError testError, List<PTWay> fix) {
        Relation originalRelation = (Relation)testError.getPrimitives().iterator().next();
        Relation modifiedRelation = new Relation(originalRelation);
        modifiedRelation.setMembers(SegmentChecker.getModifiedRelationMembers(testError, fix));
        ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
        Main.main.undoRedo.addNoRedraw((Command)changeCommand);
        Main.main.undoRedo.afterAdd();
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        wrongSegments.remove(testError);
        wrongSegment.setPTWays(fix);
        SegmentChecker.addCorrectSegment(wrongSegment);
        PTAssistantPlugin.setLastFix(wrongSegment);
        ArrayList<Way> primitives = new ArrayList<Way>();
        for (PTWay ptway : fix) {
            primitives.addAll(ptway.getWays());
        }
        OsmDataLayer layer = null;
        List listOfLayers = Main.getLayerManager().getLayersOfType(OsmDataLayer.class);
        for (OsmDataLayer osmDataLayer : listOfLayers) {
            if (osmDataLayer.data != originalRelation.getDataSet()) continue;
            layer = osmDataLayer;
            break;
        }
        GenericRelationEditor editor = (GenericRelationEditor)RelationEditor.getEditor(layer, (Relation)originalRelation, (Collection)originalRelation.getMembersFor(primitives));
        editor.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Command carryOutSingleFix(TestError testError, List<PTWay> fix) {
        final ArrayList<OsmPrimitive> waysToZoom = new ArrayList<OsmPrimitive>();
        for (Object highlightedPrimitive : testError.getHighlighted()) {
            waysToZoom.add((OsmPrimitive)highlightedPrimitive);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            AutoScaleAction.zoomTo(waysToZoom);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoScaleAction.zoomTo((Collection)waysToZoom);
                }
            });
        }
        Class<SegmentChecker> clazz = SegmentChecker.class;
        synchronized (SegmentChecker.class) {
            try {
                SegmentChecker.class.wait(1500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Relation originalRelation = (Relation)testError.getPrimitives().iterator().next();
            Relation modifiedRelation = new Relation(originalRelation);
            modifiedRelation.setMembers(SegmentChecker.getModifiedRelationMembers(testError, fix));
            wrongSegments.remove(testError);
            ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
            return changeCommand;
        }
    }

    private static List<RelationMember> getModifiedRelationMembers(TestError testError, List<PTWay> fix) {
        PTRouteSegment wrongSegment = wrongSegments.get(testError);
        Relation originalRelation = (Relation)testError.getPrimitives().iterator().next();
        List<RelationMember> modifiedRelationMembers = SegmentChecker.listStopMembers(originalRelation);
        List<RelationMember> waysOfOriginalRelation = SegmentChecker.listNotStopMembers(originalRelation);
        for (int i = 0; i < waysOfOriginalRelation.size(); ++i) {
            if (waysOfOriginalRelation.get(i).getWay() == wrongSegment.getPTWays().get(0).getWays().get(0)) {
                modifiedRelationMembers.addAll(fix);
                i = i + wrongSegment.getPTWays().size() - 1;
                continue;
            }
            modifiedRelationMembers.add(waysOfOriginalRelation.get(i));
        }
        return modifiedRelationMembers;
    }

    public static void carryOutRepeatLastFix(PTRouteSegment segment) {
        System.out.println("last fix relation: " + segment.getRelation().getId());
        ArrayList<TestError> wrongSegmentsToRemove = new ArrayList<TestError>();
        int counter = 0;
        for (TestError testError : wrongSegments.keySet()) {
            PTRouteSegment wrongSegment = wrongSegments.get(testError);
            if (wrongSegment.getFirstWay() != segment.getFirstWay() || wrongSegment.getLastWay() != segment.getLastWay()) continue;
            ++counter;
            System.out.println("wrong segment: " + wrongSegment.getRelation().getId());
            Relation originalRelation = wrongSegment.getRelation();
            Relation modifiedRelation = new Relation(originalRelation);
            modifiedRelation.setMembers(SegmentChecker.getModifiedRelationMembers(testError, segment.getPTWays()));
            ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
            Main.main.undoRedo.addNoRedraw((Command)changeCommand);
            Main.main.undoRedo.afterAdd();
            wrongSegmentsToRemove.add(testError);
        }
        ArrayList<TestError> modifiedValidatorTestErrors = new ArrayList<TestError>();
        for (TestError validatorTestError : Main.map.validatorDialog.tree.getErrors()) {
            if (wrongSegmentsToRemove.contains(validatorTestError)) continue;
            modifiedValidatorTestErrors.add(validatorTestError);
        }
        Main.map.validatorDialog.tree.setErrors(modifiedValidatorTestErrors);
        for (TestError testError : wrongSegmentsToRemove) {
            wrongSegments.remove(testError);
        }
        System.out.println("wrong segments found: " + counter);
        System.out.println();
    }
}

