/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.pt_assistant.actions.AddStopPositionAction;
import org.openstreetmap.josm.plugins.pt_assistant.actions.RepeatLastFixAction;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteSegment;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;

public class PTAssistantPlugin
extends Plugin {
    private static PTRouteSegment lastFix;
    private JMenuItem addStopPositionMenu;
    private static JMenuItem repeatLastFixMenu;

    public PTAssistantPlugin(PluginInformation info) {
        super(info);
        OsmValidator.addTest(PTAssistantValidatorTest.class);
        AddStopPositionAction addStopPositionAction = new AddStopPositionAction();
        this.addStopPositionMenu = MainMenu.add((JMenu)Main.main.menu.toolsMenu, (JosmAction)addStopPositionAction, (boolean)false);
        RepeatLastFixAction repeatLastFixAction = new RepeatLastFixAction();
        repeatLastFixMenu = MainMenu.add((JMenu)Main.main.menu.toolsMenu, (JosmAction)repeatLastFixAction, (boolean)false);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            this.addStopPositionMenu.setEnabled(true);
            repeatLastFixMenu.setEnabled(false);
        } else if (oldFrame != null && newFrame == null) {
            this.addStopPositionMenu.setEnabled(false);
            repeatLastFixMenu.setEnabled(false);
        }
    }

    public static PTRouteSegment getLastFix() {
        return lastFix;
    }

    public static void setLastFix(final PTRouteSegment segment) {
        lastFix = segment;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                repeatLastFixMenu.setEnabled(segment != null);
            }
        });
    }
}

