/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.wikipedia.GuiUtils;
import org.wikipedia.WikipediaApp;

public class FetchWikidataAction
extends JosmAction {
    public FetchWikidataAction() {
        super(I18n.tr((String)"Fetch Wikidata IDs", (Object[])new Object[0]), "dialogs/wikidata", I18n.tr((String)"Fetch Wikidata IDs using the ''wikipedia'' tag", (Object[])new Object[0]), null, true);
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null) {
            return;
        }
        Main.worker.submit((Runnable)((Object)new Fetcher(ds.getSelected())));
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        for (OsmPrimitive osmPrimitive : selection) {
            if (!osmPrimitive.hasKey("wikipedia")) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    static class PrimitivesWithWikipedia {
        final String lang;
        final MultiMap<String, OsmPrimitive> byArticle = new MultiMap();
        final List<Command> commands = new ArrayList<Command>();
        final List<WikipediaApp.WikipediaLangArticle> notFound = new ArrayList<WikipediaApp.WikipediaLangArticle>();

        public PrimitivesWithWikipedia(String lang) {
            this.lang = lang;
        }

        public void put(OsmPrimitive key, String wikipedia) {
            this.byArticle.put((Object)wikipedia, (Object)key);
        }

        protected void updateWikidataIds(ProgressMonitor monitor) {
            int size = this.byArticle.keySet().size();
            monitor.beginTask(I18n.trn((String)"Fetching {0} Wikidata ID for language ''{1}''", (String)"Fetching {0} Wikidata IDs for language ''{1}''", (long)size, (Object[])new Object[]{size, this.lang}));
            Map<String, String> wikidataByWikipedia = WikipediaApp.getWikidataForArticles(this.lang, new ArrayList<String>(this.byArticle.keySet()));
            ConditionalOptionPaneUtil.startBulkOperation((String)"wikipedia.overwrite-tag");
            for (Map.Entry i : this.byArticle.entrySet()) {
                String wikipedia = (String)i.getKey();
                String wikidata = wikidataByWikipedia.get(wikipedia);
                if (wikidata != null) {
                    if (!GuiUtils.confirmOverwrite("wikidata", wikidata, (Collection)i.getValue())) continue;
                    this.commands.add((Command)new ChangePropertyCommand((Collection)i.getValue(), "wikidata", wikidata));
                    continue;
                }
                WikipediaApp.WikipediaLangArticle article = new WikipediaApp.WikipediaLangArticle(this.lang, wikipedia);
                Main.warn((String)I18n.tr((String)"No Wikidata ID found for: {0}", (Object[])new Object[]{article}));
                this.notFound.add(article);
            }
            ConditionalOptionPaneUtil.endBulkOperation((String)"wikipedia.overwrite-tag");
            monitor.finishTask();
        }

        public Command getCommand() {
            return this.commands.isEmpty() ? null : new SequenceCommand(I18n.tr((String)"Add Wikidata for language ''{0}''", (Object[])new Object[]{this.lang}), this.commands);
        }

        public List<WikipediaApp.WikipediaLangArticle> getNotFound() {
            return this.notFound;
        }
    }

    static class Fetcher
    extends PleaseWaitRunnable {
        private final Collection<? extends OsmPrimitive> selection;
        private boolean canceled = false;
        private final List<Command> commands = new ArrayList<Command>();
        private final Collection<WikipediaApp.WikipediaLangArticle> notFound = new ArrayList<WikipediaApp.WikipediaLangArticle>();

        public Fetcher(Collection<? extends OsmPrimitive> selection) {
            super(I18n.tr((String)"Fetching Wikidata IDs", (Object[])new Object[0]));
            this.selection = selection;
        }

        protected void cancel() {
            this.canceled = true;
        }

        protected void realRun() {
            Map<String, PrimitivesWithWikipedia> wikipediaByLanguage = Fetcher.getLanguageToArticlesMap(this.selection);
            this.getProgressMonitor().setTicksCount(wikipediaByLanguage.keySet().size());
            for (Map.Entry<String, PrimitivesWithWikipedia> i : wikipediaByLanguage.entrySet()) {
                if (this.canceled) break;
                PrimitivesWithWikipedia fetcher = i.getValue();
                fetcher.updateWikidataIds(this.getProgressMonitor().createSubTaskMonitor(1, false));
                Command command = fetcher.getCommand();
                if (command != null) {
                    this.commands.add(command);
                }
                this.notFound.addAll(fetcher.getNotFound());
            }
        }

        protected static Map<String, PrimitivesWithWikipedia> getLanguageToArticlesMap(Iterable<? extends OsmPrimitive> selection) {
            HashMap<String, PrimitivesWithWikipedia> r = new HashMap<String, PrimitivesWithWikipedia>();
            for (OsmPrimitive osmPrimitive : selection) {
                WikipediaApp.WikipediaLangArticle tag = WikipediaApp.WikipediaLangArticle.parseTag("wikipedia", osmPrimitive.get("wikipedia"));
                if (tag == null) continue;
                if (!r.containsKey(tag.lang)) {
                    r.put(tag.lang, new PrimitivesWithWikipedia(tag.lang));
                }
                ((PrimitivesWithWikipedia)r.get(tag.lang)).put(osmPrimitive, tag.article);
            }
            return r;
        }

        protected void finish() {
            if (!this.canceled && !this.commands.isEmpty()) {
                Main.main.undoRedo.add((Command)(this.commands.size() == 1 ? this.commands.get(0) : new SequenceCommand(I18n.tr((String)"Add Wikidata", (Object[])new Object[0]), this.commands)));
            }
            if (!this.canceled && !this.notFound.isEmpty()) {
                new Notification(I18n.tr((String)"No Wikidata ID found for: {0}", (Object[])new Object[]{Utils.joinAsHtmlUnorderedList(this.notFound)})).setIcon(2).setDuration(Notification.TIME_LONG).show();
            }
        }
    }
}

