/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.feature.NameImpl;
import org.geotools.styling.Description;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.SemanticType;
import org.opengis.util.Cloneable;

public class FeatureTypeStyleImpl
implements FeatureTypeStyle,
Cloneable {
    public static String KEY_EVALUATION_MODE = "ruleEvaluation";
    public static String VALUE_EVALUATION_MODE_ALL = "all";
    public static String VALUE_EVALUATION_MODE_FIRST = "first";
    private static final Logger LOGGER = Logging.getLogger("org.geotools.styling");
    private List<Rule> rules = new ArrayList<Rule>();
    private Set<SemanticType> semantics = new LinkedHashSet<SemanticType>();
    private Id featureInstances = null;
    private Set<Name> featureTypeNames = new LinkedHashSet<Name>();
    private DescriptionImpl description = new DescriptionImpl();
    private String name = "name";
    private OnLineResource online = null;
    private Expression transformation = null;
    protected Map<String, String> options;

    protected FeatureTypeStyleImpl(Rule[] rules) {
        this(Arrays.asList(rules));
    }

    protected FeatureTypeStyleImpl(List<Rule> arules) {
        this.rules = new ArrayList<Rule>();
        this.rules.addAll(arules);
    }

    protected FeatureTypeStyleImpl() {
        this.rules = new ArrayList<Rule>();
    }

    public FeatureTypeStyleImpl(org.opengis.style.FeatureTypeStyle fts) {
        this.description = new DescriptionImpl(fts.getDescription());
        this.featureInstances = fts.getFeatureInstanceIDs();
        this.featureTypeNames = new LinkedHashSet<Name>(fts.featureTypeNames());
        this.name = fts.getName();
        this.rules = new ArrayList<Rule>();
        if (fts.rules() != null) {
            for (org.opengis.style.Rule rule : fts.rules()) {
                this.rules.add(RuleImpl.cast(rule));
            }
        }
        this.semantics = new LinkedHashSet<SemanticType>(fts.semanticTypeIdentifiers());
        this.online = fts.getOnlineResource();
        this.transformation = fts.getTransformation();
    }

    @Override
    public List<Rule> rules() {
        return this.rules;
    }

    @Override
    @Deprecated
    public Rule[] getRules() {
        Rule[] ret = new Rule[this.rules.size()];
        int n = this.rules.size();
        for (int i = 0; i < n; ++i) {
            ret[i] = this.rules.get(i);
        }
        return ret;
    }

    @Override
    @Deprecated
    public void setRules(Rule[] newRules) {
        this.rules = new ArrayList<Rule>();
        this.rules.addAll(Arrays.asList(newRules));
    }

    @Override
    @Deprecated
    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    @Override
    public Set<SemanticType> semanticTypeIdentifiers() {
        return this.semantics;
    }

    @Override
    @Deprecated
    public String[] getSemanticTypeIdentifiers() {
        String[] ids = new String[this.semantics.size()];
        Iterator<SemanticType> types = this.semantics.iterator();
        int i = 0;
        while (types.hasNext()) {
            ids[i] = types.next().name();
            ++i;
        }
        if (ids.length == 0) {
            ids = new String[]{SemanticType.ANY.toString()};
        }
        return ids;
    }

    @Override
    @Deprecated
    public void setSemanticTypeIdentifiers(String[] types) {
        this.semantics.clear();
        for (String id : types) {
            SemanticType st = SemanticType.valueOf(id);
            if (st == null) continue;
            this.semantics.add(st);
        }
    }

    @Override
    public Set<Name> featureTypeNames() {
        return this.featureTypeNames;
    }

    @Override
    @Deprecated
    public String getFeatureTypeName() {
        if (!this.featureTypeNames.isEmpty()) {
            return this.featureTypeNames.iterator().next().getLocalPart();
        }
        return "Feature";
    }

    @Override
    @Deprecated
    public void setFeatureTypeName(String name) {
        this.featureTypeNames.clear();
        if (name.equals("feature")) {
            LOGGER.warning("FeatureTypeStyle with typename 'feature' - did you mean to say 'Feature' (with a capital F) for the 'generic' FeatureType");
        }
        NameImpl featurename = new NameImpl(name);
        this.featureTypeNames.add(featurename);
    }

    @Override
    public Id getFeatureInstanceIDs() {
        return this.featureInstances;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Deprecated
    public String getAbstract() {
        if (this.description == null || this.description.getAbstract() == null) {
            return null;
        }
        return this.description.getAbstract().toString();
    }

    @Override
    @Deprecated
    public void setAbstract(String abstractStr) {
        this.description.setAbstract(new SimpleInternationalString(abstractStr));
    }

    @Override
    @Deprecated
    public String getTitle() {
        if (this.description == null || this.description.getTitle() == null) {
            return null;
        }
        return this.description.getTitle().toString();
    }

    @Override
    @Deprecated
    public void setTitle(String title) {
        this.description.setTitle(new SimpleInternationalString(title));
    }

    @Override
    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        FeatureTypeStyleImpl clone;
        try {
            clone = (FeatureTypeStyleImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        ArrayList<Rule> rulesCopy = new ArrayList<Rule>();
        for (Rule rl : this.rules) {
            rulesCopy.add((Rule)((Cloneable)((Object)rl)).clone());
        }
        clone.rules = new ArrayList<Rule>();
        clone.featureTypeNames = new LinkedHashSet<Name>();
        clone.semantics = new LinkedHashSet<SemanticType>();
        List<Rule> cloneRules = clone.rules();
        cloneRules.addAll(rulesCopy);
        clone.featureTypeNames().addAll(this.featureTypeNames);
        clone.semanticTypeIdentifiers().addAll(this.semantics);
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.rules != null) {
            result = 1000003 * result + this.rules.hashCode();
        }
        if (this.featureInstances != null) {
            result = 1000003 * result + this.featureInstances.hashCode();
        }
        if (this.semantics != null) {
            result = 1000003 * result + this.semantics.hashCode();
        }
        if (this.featureTypeNames != null) {
            result = 1000003 * result + this.featureTypeNames.hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.description != null) {
            result = 1000003 * result + this.description.hashCode();
        }
        if (this.options != null) {
            result = 1000003 * result + this.options.hashCode();
        }
        if (this.transformation != null) {
            result = 1000003 * result + this.transformation.hashCode();
        }
        if (this.online != null) {
            result = 1000003 * result + this.online.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof FeatureTypeStyleImpl) {
            FeatureTypeStyleImpl other = (FeatureTypeStyleImpl)oth;
            return Utilities.equals(this.name, other.name) && Utilities.equals(this.description, other.description) && Utilities.equals(this.rules, other.rules) && Utilities.equals(this.featureTypeNames, other.featureTypeNames) && Utilities.equals(this.semantics, other.semantics) && Utilities.equals(this.getOptions(), other.getOptions()) && Utilities.equals(this.getTransformation(), other.getTransformation()) && Utilities.equals(this.getOnlineResource(), other.getOnlineResource());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FeatureTypeStyleImpl");
        buf.append("[");
        if (this.name != null) {
            buf.append(" name=");
            buf.append(this.name);
        } else {
            buf.append(" UNNAMED");
        }
        buf.append(", ");
        buf.append(this.featureTypeNames);
        buf.append(", rules=<");
        buf.append(this.rules.size());
        buf.append(">");
        if (this.rules.size() > 0) {
            buf.append("(");
            buf.append(this.rules.get(0));
            if (this.rules.size() > 1) {
                buf.append(",...");
            }
            buf.append(")");
        }
        if (this.options != null) {
            buf.append(", options=" + this.options);
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void setOnlineResource(OnLineResource online) {
        this.online = online;
    }

    @Override
    public OnLineResource getOnlineResource() {
        return this.online;
    }

    static FeatureTypeStyleImpl cast(org.opengis.style.FeatureTypeStyle featureTypeStyle) {
        if (featureTypeStyle == null) {
            return null;
        }
        if (featureTypeStyle instanceof FeatureTypeStyleImpl) {
            return (FeatureTypeStyleImpl)featureTypeStyle;
        }
        FeatureTypeStyleImpl copy = new FeatureTypeStyleImpl();
        return copy;
    }

    @Override
    public Expression getTransformation() {
        return this.transformation;
    }

    @Override
    public void setTransformation(Expression transformation) {
        this.transformation = transformation;
    }

    @Override
    public boolean hasOption(String key) {
        return this.options != null && this.options.containsKey(key);
    }

    @Override
    public Map<String, String> getOptions() {
        if (this.options == null) {
            this.options = new LinkedHashMap<String, String>();
        }
        return this.options;
    }
}

