/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.awt.RenderingHints;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.sql.DataSource;
import org.geotools.factory.Hints;
import org.geotools.io.TableWriter;
import org.geotools.measure.Units;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.metadata.iso.quality.AbsoluteExternalPositionalAccuracyImpl;
import org.geotools.metadata.iso.quality.QuantitativeResultImpl;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.epsg.AuthorityCodes;
import org.geotools.referencing.factory.epsg.AxisName;
import org.geotools.referencing.factory.epsg.BursaWolfInfo;
import org.geotools.referencing.factory.epsg.CoordinateOperationSet;
import org.geotools.referencing.factory.epsg.SingleConnectionDataSource;
import org.geotools.referencing.factory.epsg.TableInfo;
import org.geotools.referencing.operation.DefaultConcatenatedOperation;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.LocalName;
import org.geotools.util.NameFactory;
import org.geotools.util.ScopedName;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public abstract class DirectEpsgFactory
extends DirectAuthorityFactory
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private static final int BURSA_WOLF_MIN_CODE = 9603;
    private static final int BURSA_WOLF_MAX_CODE = 9607;
    private static final int ROTATION_FRAME_CODE = 9607;
    private static final int DUMMY_OPERATION = 1;
    private static final TableInfo[] TABLES_INFO = new TableInfo[]{new TableInfo(CoordinateReferenceSystem.class, "[Coordinate Reference System]", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME", "COORD_REF_SYS_KIND", new Class[]{ProjectedCRS.class, GeographicCRS.class, GeocentricCRS.class}, new String[]{"projected", "geographic", "geocentric"}), new TableInfo(CoordinateSystem.class, "[Coordinate System]", "COORD_SYS_CODE", "COORD_SYS_NAME", "COORD_SYS_TYPE", new Class[]{CartesianCS.class, EllipsoidalCS.class, SphericalCS.class, VerticalCS.class}, new String[]{"Cartesian", "ellipsoidal", "spherical", "vertical"}), new TableInfo(CoordinateSystemAxis.class, "[Coordinate Axis] AS CA INNER JOIN [Coordinate Axis Name] AS CAN ON CA.COORD_AXIS_NAME_CODE=CAN.COORD_AXIS_NAME_CODE", "COORD_AXIS_CODE", "COORD_AXIS_NAME"), new TableInfo(Datum.class, "[Datum]", "DATUM_CODE", "DATUM_NAME", "DATUM_TYPE", new Class[]{GeodeticDatum.class, VerticalDatum.class, EngineeringDatum.class}, new String[]{"geodetic", "vertical", "engineering"}), new TableInfo(Ellipsoid.class, "[Ellipsoid]", "ELLIPSOID_CODE", "ELLIPSOID_NAME"), new TableInfo(PrimeMeridian.class, "[Prime Meridian]", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME"), new TableInfo(CoordinateOperation.class, "[Coordinate_Operation]", "COORD_OP_CODE", "COORD_OP_NAME", "COORD_OP_TYPE", new Class[]{Projection.class, Conversion.class, Transformation.class}, new String[]{"conversion", "conversion", "transformation"}), new TableInfo(OperationMethod.class, "[Coordinate_Operation Method]", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME"), new TableInfo(ParameterDescriptor.class, "[Coordinate_Operation Parameter]", "PARAMETER_CODE", "PARAMETER_NAME"), new TableInfo(Unit.class, "[Unit of Measure]", "UOM_CODE", "UNIT_OF_MEAS_NAME")};
    private static final InternationalString TRANSFORMATION_ACCURACY = Vocabulary.formatInternational(223);
    static final String SHUTDOWN_THREAD = "EPSG factory shutdown";
    private volatile transient Citation authority;
    private int lastObjectType = -1;
    private transient String lastTableForName;
    private final Calendar calendar = Calendar.getInstance();
    private final Map<String, PreparedStatement> statements = new IdentityHashMap<String, PreparedStatement>();
    private final Map<Class<?>, Reference<AuthorityCodes>> authorityCodes = new HashMap();
    private final Map<String, AxisName> axisNames = new HashMap<String, AxisName>();
    private final Map<String, Short> axisCounts = new HashMap<String, Short>();
    private final Map<String, Boolean> codeProjection = new HashMap<String, Boolean>();
    private final Map<String, LocalName> scopes = new HashMap<String, LocalName>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<String> safetyGuard = new HashSet<String>();
    AbstractAuthorityFactory buffered = this;
    private Connection connection;
    private DataSource dataSource;
    private String validationQuery;

    private static Unit<?> getUnit(int code) {
        switch (code) {
            case 9001: {
                return SI.METER;
            }
            case 9002: {
                return NonSI.FOOT;
            }
            case 9030: {
                return NonSI.NAUTICAL_MILE;
            }
            case 9036: {
                return SI.KILO(SI.METER);
            }
            case 9101: {
                return SI.RADIAN;
            }
            case 9102: 
            case 9122: {
                return NonSI.DEGREE_ANGLE;
            }
            case 9103: {
                return NonSI.MINUTE_ANGLE;
            }
            case 9104: {
                return NonSI.SECOND_ANGLE;
            }
            case 9105: {
                return NonSI.GRADE;
            }
            case 9107: {
                return Units.DEGREE_MINUTE_SECOND;
            }
            case 9108: {
                return Units.DEGREE_MINUTE_SECOND;
            }
            case 9109: {
                return SI.MICRO(SI.RADIAN);
            }
            case 9110: {
                return Units.SEXAGESIMAL_DMS;
            }
            case 9201: 
            case 9203: {
                return Unit.ONE;
            }
            case 9202: {
                return Units.PPM;
            }
        }
        return null;
    }

    private static void setBursaWolfParameter(BursaWolfParameters parameters, int code, double value, Unit<?> unit) throws FactoryException {
        Unit<Object> target = unit;
        if (code >= 8605) {
            if (code <= 8607) {
                target = SI.METER;
            } else if (code == 8611) {
                target = Units.PPM;
            } else if (code <= 8710) {
                target = NonSI.SECOND_ANGLE;
            }
        }
        if (target != unit) {
            value = unit.getConverterTo(target).convert(value);
        }
        switch (code) {
            case 8605: {
                parameters.dx = value;
                break;
            }
            case 8606: {
                parameters.dy = value;
                break;
            }
            case 8607: {
                parameters.dz = value;
                break;
            }
            case 8608: {
                parameters.ex = value;
                break;
            }
            case 8609: {
                parameters.ey = value;
                break;
            }
            case 8610: {
                parameters.ez = value;
                break;
            }
            case 8611: {
                parameters.ppm = value;
                break;
            }
            default: {
                throw new FactoryException(Errors.format(176, code));
            }
        }
    }

    public DirectEpsgFactory(Hints userHints, Connection connection) {
        this(userHints, new SingleConnectionDataSource(connection));
    }

    public DirectEpsgFactory(Hints userHints, DataSource dataSource) {
        super(userHints, 80);
        this.hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        this.hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
        this.dataSource = dataSource;
        DirectEpsgFactory.ensureNonNull("dataSource", dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Citation getAuthority() {
        if (this.authority == null) {
            try {
                DirectEpsgFactory directEpsgFactory = this;
                synchronized (directEpsgFactory) {
                    if (this.authority == null) {
                        String query = this.adaptSQL("SELECT VERSION_NUMBER, VERSION_DATE FROM [Version History] ORDER BY VERSION_DATE DESC, VERSION_NUMBER DESC");
                        DatabaseMetaData metadata = this.getConnection().getMetaData();
                        Statement statement = this.getConnection().createStatement();
                        ResultSet result = statement.executeQuery(query);
                        if (result.next()) {
                            String version = result.getString(1);
                            Date date = result.getDate(2);
                            String engine = metadata.getDatabaseProductName();
                            CitationImpl c = new CitationImpl(Citations.EPSG);
                            c.getAlternateTitles().add(Vocabulary.formatInternational(37, "EPSG", version, engine));
                            c.setEdition(new SimpleInternationalString(version));
                            c.setEditionDate(date);
                            this.authority = (Citation)((Object)c.unmodifiable());
                            this.hints.put(Hints.VERSION, new Version(version));
                        } else {
                            this.authority = Citations.EPSG;
                        }
                        result.close();
                        statement.close();
                    }
                }
            }
            catch (SQLException exception) {
                Logging.unexpectedException(LOGGER, DirectEpsgFactory.class, "getAuthority", (Throwable)exception);
                return Citations.EPSG;
            }
        }
        return this.authority;
    }

    @Override
    public synchronized String getBackingStoreDescription() throws FactoryException {
        Citation authority = this.getAuthority();
        TableWriter table = new TableWriter(null, " ");
        Vocabulary resources = Vocabulary.getResources(null);
        InternationalString cs = authority.getEdition();
        if (cs != null) {
            table.write(resources.getString(239, "EPSG"));
            table.write(58);
            table.nextColumn();
            table.write(cs.toString());
            table.nextLine();
        }
        try {
            DatabaseMetaData metadata = this.getConnection().getMetaData();
            String s = metadata.getDatabaseProductName();
            if (s != null) {
                table.write(resources.getLabel(35));
                table.nextColumn();
                table.write(s);
                s = metadata.getDatabaseProductVersion();
                if (s != null) {
                    table.write(32);
                    table.write(resources.getString(238, s));
                }
                table.nextLine();
            }
            if ((s = metadata.getURL()) != null) {
                table.write(resources.getLabel(36));
                table.nextColumn();
                table.write(s);
                table.nextLine();
            }
        }
        catch (SQLException exception) {
            throw new FactoryException(exception);
        }
        return table.toString();
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        if (this.authority == null) {
            this.getAuthority();
        }
        return super.getImplementationHints();
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        return this.getAuthorityCodes0(type);
    }

    private synchronized Set<String> getAuthorityCodes0(Class<?> type) throws FactoryException {
        AuthorityCodes candidate;
        Reference<AuthorityCodes> reference = this.authorityCodes.get(type);
        AuthorityCodes authorityCodes = candidate = reference != null ? reference.get() : null;
        if (candidate != null) {
            return candidate;
        }
        AbstractSet result = Collections.emptySet();
        for (int i = 0; i < TABLES_INFO.length; ++i) {
            boolean cache;
            TableInfo table = TABLES_INFO[i];
            if (!table.type.isAssignableFrom(type) && !type.isAssignableFrom(table.type)) continue;
            AuthorityCodes codes = new AuthorityCodes(TABLES_INFO[i], type, this);
            reference = this.authorityCodes.get(codes.type);
            AuthorityCodes authorityCodes2 = candidate = reference != null ? reference.get() : null;
            if (candidate == null) {
                candidate = codes;
                cache = true;
            } else {
                assert (candidate.sqlAll.equals(codes.sqlAll)) : codes.type;
                boolean bl = cache = !(reference instanceof SoftReference);
            }
            if (cache) {
                reference = new SoftReference<AuthorityCodes>(candidate);
                this.authorityCodes.put(codes.type, reference);
            }
            if (result.isEmpty()) {
                result = candidate;
                continue;
            }
            if (result instanceof AuthorityCodes) {
                result = new LinkedHashSet<String>(result);
            }
            result.addAll(candidate);
        }
        return result;
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        String primaryKey = this.trimAuthority(code);
        for (int i = 0; i < TABLES_INFO.length; ++i) {
            String text;
            Set<String> codes = this.getAuthorityCodes0(DirectEpsgFactory.TABLES_INFO[i].type);
            if (!(codes instanceof AuthorityCodes) || (text = ((AuthorityCodes)codes).asMap().get(primaryKey)) == null) continue;
            return new SimpleInternationalString(text);
        }
        ReferenceIdentifier identifier = this.createObject(code).getName();
        if (identifier instanceof GenericName) {
            return ((GenericName)((Object)identifier)).toInternationalString();
        }
        return new SimpleInternationalString(identifier.getCode());
    }

    private PreparedStatement prepareStatement(String key, String sql) throws SQLException {
        assert (Thread.holdsLock(this));
        PreparedStatement stmt = this.statements.get(key);
        Connection conn = null;
        if (stmt != null) {
            try {
                conn = stmt.getConnection();
            }
            catch (SQLException sqle) {
                stmt = null;
            }
        }
        if (conn != null && !this.isConnectionValid(conn)) {
            stmt = null;
        }
        if (stmt == null) {
            stmt = this.getConnection().prepareStatement(this.adaptSQL(sql));
            this.statements.put(key, stmt);
        }
        return stmt;
    }

    private static String getString(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        String value = result.getString(columnIndex);
        DirectEpsgFactory.ensureNonNull(result, columnIndex, code);
        return value.trim();
    }

    private static String getString(ResultSet result, int columnIndex, String code, int columnFault) throws SQLException, FactoryException {
        String str = result.getString(columnIndex);
        if (result.wasNull()) {
            ResultSetMetaData metadata = result.getMetaData();
            String column = metadata.getColumnName(columnFault);
            String table = metadata.getTableName(columnFault);
            result.close();
            throw new FactoryException(Errors.format(147, code, column, table));
        }
        return str.trim();
    }

    private static double getDouble(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        double value = result.getDouble(columnIndex);
        DirectEpsgFactory.ensureNonNull(result, columnIndex, code);
        return value;
    }

    private static int getInt(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        int value = result.getInt(columnIndex);
        DirectEpsgFactory.ensureNonNull(result, columnIndex, code);
        return value;
    }

    private static void ensureNonNull(ResultSet result, int columnIndex, String code) throws SQLException, FactoryException {
        if (result.wasNull()) {
            ResultSetMetaData metadata = result.getMetaData();
            String column = metadata.getColumnName(columnIndex);
            String table = metadata.getTableName(columnIndex);
            result.close();
            throw new FactoryException(Errors.format(147, code, column, table));
        }
    }

    private String toPrimaryKey(Class type, String code, String table, String codeColumn, String nameColumn) throws SQLException, FactoryException {
        assert (Thread.holdsLock(this));
        String identifier = this.trimAuthority(code);
        if (!this.isPrimaryKey(identifier)) {
            String KEY = "NumericalIdentifier";
            PreparedStatement statement = this.statements.get("NumericalIdentifier");
            if (statement != null && !table.equals(this.lastTableForName)) {
                this.statements.remove("NumericalIdentifier");
                statement.close();
                statement = null;
                this.lastTableForName = null;
            }
            if (statement == null) {
                String query = "SELECT " + codeColumn + " FROM " + table + " WHERE " + nameColumn + " = ?";
                statement = this.connection.prepareStatement(this.adaptSQL(query));
                this.statements.put("NumericalIdentifier", statement);
            }
            statement.setString(1, identifier);
            identifier = null;
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                identifier = DirectEpsgFactory.ensureSingleton(result.getString(1), identifier, code);
            }
            result.close();
            if (identifier == null) {
                throw this.noSuchAuthorityCode(type, code);
            }
        }
        return identifier;
    }

    private static <T> T ensureSingleton(T newValue, T oldValue, String code) throws FactoryException {
        if (oldValue == null) {
            return newValue;
        }
        if (oldValue.equals(newValue)) {
            return oldValue;
        }
        throw new FactoryException(Errors.format(44, code));
    }

    private Map<String, Object> createProperties(String name, String code, String remarks) throws SQLException, FactoryException {
        this.properties.clear();
        Citation authority = this.getAuthority();
        if (name != null) {
            this.properties.put("name", new NamedIdentifier(authority, name.trim()));
        }
        if (code != null) {
            InternationalString edition = authority.getEdition();
            String version = edition != null ? edition.toString() : null;
            this.properties.put("identifiers", new NamedIdentifier(authority, code.trim(), version));
        }
        if (remarks != null && (remarks = remarks.trim()).length() != 0) {
            this.properties.put("remarks", remarks);
        }
        ArrayList<LocalName> alias = null;
        PreparedStatement stmt = this.prepareStatement("Alias", "SELECT NAMING_SYSTEM_NAME, ALIAS FROM [Alias] INNER JOIN [Naming System] ON [Alias].NAMING_SYSTEM_CODE = [Naming System].NAMING_SYSTEM_CODE WHERE OBJECT_CODE = ?");
        stmt.setString(1, code);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            org.geotools.util.GenericName generic;
            String scope = result.getString(1);
            String local = DirectEpsgFactory.getString(result, 2, code);
            if (scope == null) {
                generic = new LocalName(local);
            } else {
                LocalName cached = this.scopes.get(scope);
                if (cached == null) {
                    cached = new LocalName(scope);
                    this.scopes.put(scope, cached);
                }
                generic = new ScopedName(cached, local);
            }
            if (alias == null) {
                alias = new ArrayList<LocalName>();
            }
            alias.add((LocalName)generic);
        }
        result.close();
        if (alias != null) {
            this.properties.put("alias", alias.toArray(new GenericName[alias.size()]));
        }
        return this.properties;
    }

    private Map<String, Object> createProperties(String name, String code, String area, String scope, String remarks) throws SQLException, FactoryException {
        Map<String, Object> properties = this.createProperties(name, code, remarks);
        if (area != null && (area = area.trim()).length() != 0) {
            Extent extent = this.buffered.createExtent(area);
            properties.put("domainOfValidity", extent);
        }
        if (scope != null && (scope = scope.trim()).length() != 0) {
            properties.put("scope", scope);
        }
        return properties;
    }

    @Override
    public synchronized IdentifiedObject createObject(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        String KEY = "IdentifiedObject";
        PreparedStatement stmt = this.statements.get("IdentifiedObject");
        StringBuilder query = null;
        String epsg = this.trimAuthority(code);
        boolean isPrimaryKey = this.isPrimaryKey(epsg);
        int tupleToSkip = isPrimaryKey ? this.lastObjectType : -1;
        int index = -1;
        for (int i = -1; i < TABLES_INFO.length; ++i) {
            if (i == tupleToSkip) continue;
            try {
                if (i >= 0) {
                    String column;
                    TableInfo table = TABLES_INFO[i];
                    String string = column = isPrimaryKey ? table.codeColumn : table.nameColumn;
                    if (column == null) continue;
                    if (query == null) {
                        query = new StringBuilder("SELECT ");
                    }
                    query.setLength(7);
                    query.append(table.codeColumn);
                    query.append(" FROM ");
                    query.append(table.table);
                    query.append(" WHERE ");
                    query.append(column);
                    query.append(" = ?");
                    if (isPrimaryKey) {
                        assert (!this.statements.containsKey("IdentifiedObject")) : table;
                        stmt = this.prepareStatement("IdentifiedObject", query.toString());
                    } else {
                        stmt = this.connection.prepareStatement(this.adaptSQL(query.toString()));
                    }
                }
                stmt.setString(1, epsg);
                ResultSet result = stmt.executeQuery();
                boolean present = result.next();
                result.close();
                if (present) {
                    if (index >= 0) {
                        throw new FactoryException(Errors.format(44, code));
                    }
                    int n = index = i < 0 ? this.lastObjectType : i;
                    if (isPrimaryKey) break;
                }
                if (isPrimaryKey && this.statements.remove("IdentifiedObject") == null) {
                    throw new AssertionError((Object)code);
                }
                stmt.close();
                continue;
            }
            catch (SQLException exception) {
                throw DirectEpsgFactory.databaseFailure(IdentifiedObject.class, code, exception);
            }
        }
        if (isPrimaryKey) {
            this.lastObjectType = index;
        }
        if (index >= 0) {
            switch (index) {
                case 0: {
                    return this.buffered.createCoordinateReferenceSystem(code);
                }
                case 1: {
                    return this.buffered.createCoordinateSystem(code);
                }
                case 2: {
                    return this.buffered.createCoordinateSystemAxis(code);
                }
                case 3: {
                    return this.buffered.createDatum(code);
                }
                case 4: {
                    return this.buffered.createEllipsoid(code);
                }
                case 5: {
                    return this.buffered.createPrimeMeridian(code);
                }
                case 6: {
                    return this.buffered.createCoordinateOperation(code);
                }
                case 7: {
                    return this.buffered.createOperationMethod(code);
                }
                case 8: {
                    return this.buffered.createParameterDescriptor(code);
                }
                case 9: {
                    break;
                }
                default: {
                    throw new AssertionError(index);
                }
            }
        }
        return super.createObject(code);
    }

    @Override
    public synchronized Unit<?> createUnit(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        Unit returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(Unit.class, code, "[Unit of Measure]", "UOM_CODE", "UNIT_OF_MEAS_NAME");
            PreparedStatement stmt = this.prepareStatement("Unit", "SELECT UOM_CODE, FACTOR_B, FACTOR_C, TARGET_UOM_CODE FROM [Unit of Measure] WHERE UOM_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                int source = DirectEpsgFactory.getInt(result, 1, code);
                double b = result.getDouble(2);
                double c = result.getDouble(3);
                int target = DirectEpsgFactory.getInt(result, 4, code);
                Unit<?> base = DirectEpsgFactory.getUnit(target);
                if (base == null) {
                    throw this.noSuchAuthorityCode(Unit.class, String.valueOf(target));
                }
                Unit<?> unit = DirectEpsgFactory.getUnit(source);
                if (unit == null) {
                    if (b != 0.0 && c != 0.0) {
                        unit = b == c ? base : base.times(b / c);
                    } else {
                        throw new FactoryException("Unsupported unit: " + code);
                    }
                }
                returnValue = DirectEpsgFactory.ensureSingleton(unit, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(Unit.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Unit.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized Ellipsoid createEllipsoid(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        Ellipsoid returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(Ellipsoid.class, code, "[Ellipsoid]", "ELLIPSOID_CODE", "ELLIPSOID_NAME");
            PreparedStatement stmt = this.prepareStatement("Ellipsoid", "SELECT ELLIPSOID_CODE, ELLIPSOID_NAME, SEMI_MAJOR_AXIS, INV_FLATTENING, SEMI_MINOR_AXIS, UOM_CODE, REMARKS FROM [Ellipsoid] WHERE ELLIPSOID_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                Ellipsoid ellipsoid;
                String epsg = DirectEpsgFactory.getString(result, 1, code);
                String name = DirectEpsgFactory.getString(result, 2, code);
                double semiMajorAxis = DirectEpsgFactory.getDouble(result, 3, code);
                double inverseFlattening = result.getDouble(4);
                double semiMinorAxis = result.getDouble(5);
                String unitCode = DirectEpsgFactory.getString(result, 6, code);
                String remarks = result.getString(7);
                Unit<Length> unit = this.buffered.createUnit(unitCode);
                Map<String, Object> properties = this.createProperties(name, epsg, remarks);
                if (inverseFlattening == 0.0) {
                    if (semiMinorAxis == 0.0) {
                        String column = result.getMetaData().getColumnName(3);
                        result.close();
                        throw new FactoryException(Errors.format(147, code, column));
                    }
                    ellipsoid = this.factories.getDatumFactory().createEllipsoid(properties, semiMajorAxis, semiMinorAxis, unit);
                } else {
                    if (semiMinorAxis != 0.0) {
                        LogRecord record = Loggings.format(Level.WARNING, 1, code);
                        record.setLoggerName(LOGGER.getName());
                        LOGGER.log(record);
                    }
                    ellipsoid = this.factories.getDatumFactory().createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, unit);
                }
                returnValue = DirectEpsgFactory.ensureSingleton(ellipsoid, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(Ellipsoid.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Ellipsoid.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        PrimeMeridian returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(PrimeMeridian.class, code, "[Prime Meridian]", "PRIME_MERIDIAN_CODE", "PRIME_MERIDIAN_NAME");
            PreparedStatement stmt = this.prepareStatement("PrimeMeridian", "SELECT PRIME_MERIDIAN_CODE, PRIME_MERIDIAN_NAME, GREENWICH_LONGITUDE, UOM_CODE, REMARKS FROM [Prime Meridian] WHERE PRIME_MERIDIAN_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String epsg = DirectEpsgFactory.getString(result, 1, code);
                String name = DirectEpsgFactory.getString(result, 2, code);
                double longitude = DirectEpsgFactory.getDouble(result, 3, code);
                String unit_code = DirectEpsgFactory.getString(result, 4, code);
                String remarks = result.getString(5);
                Unit<Angle> unit = this.buffered.createUnit(unit_code);
                Map<String, Object> properties = this.createProperties(name, epsg, remarks);
                PrimeMeridian primeMeridian = this.factories.getDatumFactory().createPrimeMeridian(properties, longitude, unit);
                returnValue = DirectEpsgFactory.ensureSingleton(primeMeridian, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(PrimeMeridian.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(PrimeMeridian.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized Extent createExtent(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        Extent returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(Extent.class, code, "[Area]", "AREA_CODE", "AREA_NAME");
            PreparedStatement stmt = this.prepareStatement("Area", "SELECT AREA_OF_USE, AREA_SOUTH_BOUND_LAT, AREA_NORTH_BOUND_LAT, AREA_WEST_BOUND_LON, AREA_EAST_BOUND_LON FROM [Area] WHERE AREA_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                ExtentImpl extent = null;
                String description = result.getString(1);
                if (description != null) {
                    extent = new ExtentImpl();
                    extent.setDescription(new SimpleInternationalString(description));
                }
                double ymin = result.getDouble(2);
                if (!result.wasNull()) {
                    double ymax = result.getDouble(3);
                    if (!result.wasNull()) {
                        double xmin = result.getDouble(4);
                        if (!result.wasNull()) {
                            double xmax = result.getDouble(5);
                            if (!result.wasNull()) {
                                if (extent == null) {
                                    extent = new ExtentImpl();
                                }
                                extent.setGeographicElements(Collections.singleton(new GeographicBoundingBoxImpl(xmin, xmax, ymin, ymax)));
                            }
                        }
                    }
                }
                if (extent == null) continue;
                returnValue = DirectEpsgFactory.ensureSingleton(extent.unmodifiable(), returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(Extent.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Extent.class, code);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BursaWolfParameters[] createBursaWolfParameters(String code, ResultSet toClose) throws SQLException, FactoryException {
        if (this.safetyGuard.contains(code)) {
            return null;
        }
        PreparedStatement stmt = this.prepareStatement("BursaWolfParametersSet", "SELECT CO.COORD_OP_CODE, CO.COORD_OP_METHOD_CODE, CRS2.DATUM_CODE FROM [Coordinate_Operation] AS CO INNER JOIN [Coordinate Reference System] AS CRS2 ON CO.TARGET_CRS_CODE = CRS2.COORD_REF_SYS_CODE LEFT JOIN [Area] AS AREA on CO.AREA_OF_USE_CODE = AREA.AREA_CODE WHERE CO.COORD_OP_METHOD_CODE >= 9603 AND CO.COORD_OP_METHOD_CODE <= 9607 AND CO.COORD_OP_CODE <> 1 AND CO.SOURCE_CRS_CODE IN ( SELECT CRS1.COORD_REF_SYS_CODE  FROM [Coordinate Reference System] AS CRS1  WHERE CRS1.DATUM_CODE = ?) ORDER BY CRS2.DATUM_CODE, ABS(CO.DEPRECATED), CO.COORD_OP_ACCURACY, (AREA_NORTH_BOUND_LAT - AREA_SOUTH_BOUND_LAT) * (CASE WHEN AREA_EAST_BOUND_LON > AREA_WEST_BOUND_LON      THEN (AREA_EAST_BOUND_LON - AREA_WEST_BOUND_LON)      ELSE (360 - AREA_WEST_BOUND_LON - AREA_EAST_BOUND_LON) END) DESC, CO.COORD_OP_CODE DESC");
        stmt.setInt(1, Integer.parseInt(code));
        ResultSet result = stmt.executeQuery();
        ArrayList<BursaWolfInfo> bwInfos = null;
        while (result.next()) {
            String operation = DirectEpsgFactory.getString(result, 1, code);
            int method = DirectEpsgFactory.getInt(result, 2, code);
            String datum = DirectEpsgFactory.getString(result, 3, code);
            if (bwInfos == null) {
                bwInfos = new ArrayList<BursaWolfInfo>();
            }
            bwInfos.add(new BursaWolfInfo(operation, method, datum));
        }
        result.close();
        if (bwInfos == null) {
            return null;
        }
        toClose.close();
        int size = bwInfos.size();
        if (size > 1) {
            Object[] codes = bwInfos.toArray(new BursaWolfInfo[size]);
            this.sort(codes);
            bwInfos.clear();
            HashSet<String> added = new HashSet<String>();
            for (int i = 0; i < codes.length; ++i) {
                Object candidate = codes[i];
                if (!added.add(((BursaWolfInfo)candidate).target)) continue;
                bwInfos.add((BursaWolfInfo)candidate);
            }
            size = bwInfos.size();
        }
        stmt = this.prepareStatement("BursaWolfParameters", "SELECT PARAMETER_CODE, PARAMETER_VALUE, UOM_CODE FROM [Coordinate_Operation Parameter Value] WHERE COORD_OP_CODE = ? AND COORD_OP_METHOD_CODE = ?");
        for (int i = 0; i < size; ++i) {
            GeodeticDatum datum;
            BursaWolfInfo info = (BursaWolfInfo)bwInfos.get(i);
            try {
                this.safetyGuard.add(code);
                datum = this.buffered.createGeodeticDatum(info.target);
            }
            finally {
                this.safetyGuard.remove(code);
            }
            BursaWolfParameters parameters = new BursaWolfParameters(datum);
            stmt.setInt(1, Integer.parseInt(info.operation));
            stmt.setInt(2, info.method);
            result = stmt.executeQuery();
            while (result.next()) {
                DirectEpsgFactory.setBursaWolfParameter(parameters, DirectEpsgFactory.getInt(result, 1, info.operation), DirectEpsgFactory.getDouble(result, 2, info.operation), this.buffered.createUnit(DirectEpsgFactory.getString(result, 3, info.operation)));
            }
            result.close();
            if (info.method == 9607) {
                parameters.ex = -parameters.ex;
                parameters.ey = -parameters.ey;
                parameters.ey = -parameters.ey;
            }
            bwInfos.set(i, (BursaWolfInfo)((Object)parameters));
        }
        return bwInfos.toArray(new BursaWolfParameters[size]);
    }

    @Override
    public synchronized Datum createDatum(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        Datum returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(Datum.class, code, "[Datum]", "DATUM_CODE", "DATUM_NAME");
            PreparedStatement stmt = this.prepareStatement("Datum", "SELECT DATUM_CODE, DATUM_NAME, DATUM_TYPE, ORIGIN_DESCRIPTION, REALIZATION_EPOCH, AREA_OF_USE_CODE, DATUM_SCOPE, REMARKS, ELLIPSOID_CODE, PRIME_MERIDIAN_CODE FROM [Datum] WHERE DATUM_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                Datum datum;
                String epsg = DirectEpsgFactory.getString(result, 1, code);
                String name = DirectEpsgFactory.getString(result, 2, code);
                String type = DirectEpsgFactory.getString(result, 3, code).trim().toLowerCase();
                String anchor = result.getString(4);
                String epoch = result.getString(5);
                String area = result.getString(6);
                String scope = result.getString(7);
                String remarks = result.getString(8);
                Map<String, Object> properties = this.createProperties(name, epsg, area, scope, remarks);
                if (anchor != null) {
                    properties.put("anchorPoint", anchor);
                }
                if (epoch != null && epoch.length() != 0) {
                    try {
                        this.calendar.clear();
                        this.calendar.set(Integer.parseInt(epoch), 0, 1);
                        properties.put("realizationEpoch", this.calendar.getTime());
                    }
                    catch (NumberFormatException exception) {
                        Logging.unexpectedException(LOGGER, DirectEpsgFactory.class, "createDatum", (Throwable)exception);
                    }
                }
                DatumFactory factory = this.factories.getDatumFactory();
                if (type.equals("geodetic")) {
                    properties = new HashMap<String, Object>(properties);
                    Ellipsoid ellipsoid = this.buffered.createEllipsoid(DirectEpsgFactory.getString(result, 9, code));
                    PrimeMeridian meridian = this.buffered.createPrimeMeridian(DirectEpsgFactory.getString(result, 10, code));
                    BursaWolfParameters[] param = this.createBursaWolfParameters(primaryKey, result);
                    if (param != null) {
                        result = null;
                        properties.put("bursaWolf", param);
                    }
                    datum = factory.createGeodeticDatum(properties, ellipsoid, meridian);
                } else if (type.equals("vertical")) {
                    datum = factory.createVerticalDatum(properties, VerticalDatumType.GEOIDAL);
                } else if (type.equals("engineering")) {
                    datum = factory.createEngineeringDatum(properties);
                } else {
                    result.close();
                    throw new FactoryException(Errors.format(187, type));
                }
                returnValue = DirectEpsgFactory.ensureSingleton(datum, returnValue, code);
                if (result != null) continue;
                return returnValue;
            }
            result.close();
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(Datum.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(Datum.class, code);
        }
        return returnValue;
    }

    private AxisName getAxisName(String code) throws FactoryException {
        assert (Thread.holdsLock(this));
        AxisName returnValue = this.axisNames.get(code);
        if (returnValue == null) {
            try {
                PreparedStatement stmt = this.prepareStatement("AxisName", "SELECT COORD_AXIS_NAME, DESCRIPTION, REMARKS FROM [Coordinate Axis Name] WHERE COORD_AXIS_NAME_CODE = ?");
                stmt.setInt(1, Integer.parseInt(code));
                ResultSet result = stmt.executeQuery();
                while (result.next()) {
                    String name = DirectEpsgFactory.getString(result, 1, code);
                    String description = result.getString(2);
                    String remarks = result.getString(3);
                    if (description == null) {
                        description = remarks;
                    } else if (remarks != null) {
                        description = description + System.getProperty("line.separator", "\n") + remarks;
                    }
                    AxisName axis = new AxisName(name, description);
                    returnValue = DirectEpsgFactory.ensureSingleton(axis, returnValue, code);
                }
                result.close();
                if (returnValue == null) {
                    throw this.noSuchAuthorityCode(AxisName.class, code);
                }
                this.axisNames.put(code, returnValue);
            }
            catch (SQLException exception) {
                throw DirectEpsgFactory.databaseFailure(AxisName.class, code, exception);
            }
        }
        return returnValue;
    }

    @Override
    public synchronized CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        CoordinateSystemAxis returnValue = null;
        try {
            String primaryKey = this.trimAuthority(code);
            PreparedStatement stmt = this.prepareStatement("Axis", "SELECT COORD_AXIS_CODE, COORD_AXIS_NAME_CODE, COORD_AXIS_ORIENTATION, COORD_AXIS_ABBREVIATION, UOM_CODE FROM [Coordinate Axis] WHERE COORD_AXIS_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                AxisDirection direction;
                String epsg = DirectEpsgFactory.getString(result, 1, code);
                String nameCode = DirectEpsgFactory.getString(result, 2, code);
                String orientation = DirectEpsgFactory.getString(result, 3, code);
                String abbreviation = DirectEpsgFactory.getString(result, 4, code);
                String unit = DirectEpsgFactory.getString(result, 5, code);
                try {
                    direction = DefaultCoordinateSystemAxis.getDirection(orientation);
                }
                catch (NoSuchElementException exception) {
                    if (orientation.equalsIgnoreCase("Geocentre > equator/PM")) {
                        direction = AxisDirection.OTHER;
                    }
                    if (orientation.equalsIgnoreCase("Geocentre > equator/90dE") || orientation.equalsIgnoreCase("Geocentre > equator/90\u00b0E")) {
                        direction = AxisDirection.GEOCENTRIC_Y;
                    }
                    if (orientation.equalsIgnoreCase("Geocentre > equator/0dE") || orientation.equalsIgnoreCase("Geocentre > equator/0\u00b0E")) {
                        direction = AxisDirection.GEOCENTRIC_X;
                    }
                    if (orientation.equalsIgnoreCase("Geocentre > north pole")) {
                        direction = AxisDirection.GEOCENTRIC_Z;
                    }
                    throw new FactoryException(exception);
                }
                AxisName an = this.getAxisName(nameCode);
                Map<String, Object> properties = this.createProperties(an.name, epsg, an.description);
                CSFactory factory = this.factories.getCSFactory();
                CoordinateSystemAxis axis = factory.createCoordinateSystemAxis(properties, abbreviation, direction, this.buffered.createUnit(unit));
                returnValue = DirectEpsgFactory.ensureSingleton(axis, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(CoordinateSystemAxis.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateSystemAxis.class, code);
        }
        return returnValue;
    }

    private CoordinateSystemAxis[] createAxesForCoordinateSystem(String code, int dimension) throws SQLException, FactoryException {
        assert (Thread.holdsLock(this));
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[dimension];
        PreparedStatement stmt = this.prepareStatement("AxisOrder", "SELECT COORD_AXIS_CODE FROM [Coordinate Axis] WHERE COORD_SYS_CODE = ? ORDER BY [ORDER]");
        stmt.setInt(1, Integer.parseInt(code));
        ResultSet result = stmt.executeQuery();
        int i = 0;
        while (result.next()) {
            String axisCode = DirectEpsgFactory.getString(result, 1, code);
            if (i < axis.length) {
                axis[i] = this.buffered.createCoordinateSystemAxis(axisCode);
            }
            ++i;
        }
        result.close();
        if (i != axis.length) {
            throw new FactoryException(Errors.format(93, axis.length, i));
        }
        return axis;
    }

    @Override
    public synchronized CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        CoordinateSystem returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(CoordinateSystem.class, code, "[Coordinate System]", "COORD_SYS_CODE", "COORD_SYS_NAME");
            PreparedStatement stmt = this.prepareStatement("CoordinateSystem", "SELECT COORD_SYS_CODE, COORD_SYS_NAME, COORD_SYS_TYPE, DIMENSION, REMARKS FROM [Coordinate System] WHERE COORD_SYS_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String epsg = DirectEpsgFactory.getString(result, 1, code);
                String name = DirectEpsgFactory.getString(result, 2, code);
                String type = DirectEpsgFactory.getString(result, 3, code).trim().toLowerCase();
                int dimension = DirectEpsgFactory.getInt(result, 4, code);
                String remarks = result.getString(5);
                CoordinateSystemAxis[] axis = this.createAxesForCoordinateSystem(primaryKey, dimension);
                Map<String, Object> properties = this.createProperties(name, epsg, remarks);
                CSFactory factory = this.factories.getCSFactory();
                CoordinateSystem cs = null;
                if (type.equals("ellipsoidal")) {
                    switch (dimension) {
                        case 2: {
                            cs = factory.createEllipsoidalCS(properties, axis[0], axis[1]);
                            break;
                        }
                        case 3: {
                            cs = factory.createEllipsoidalCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else if (type.equals("cartesian")) {
                    switch (dimension) {
                        case 2: {
                            cs = factory.createCartesianCS(properties, axis[0], axis[1]);
                            break;
                        }
                        case 3: {
                            cs = factory.createCartesianCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else if (type.equals("spherical")) {
                    switch (dimension) {
                        case 3: {
                            cs = factory.createSphericalCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else if (type.equals("vertical") || type.equals("gravity-related")) {
                    switch (dimension) {
                        case 1: {
                            cs = factory.createVerticalCS(properties, axis[0]);
                        }
                    }
                } else if (type.equals("linear")) {
                    switch (dimension) {
                        case 1: {
                            cs = factory.createLinearCS(properties, axis[0]);
                        }
                    }
                } else if (type.equals("polar")) {
                    switch (dimension) {
                        case 2: {
                            cs = factory.createPolarCS(properties, axis[0], axis[1]);
                        }
                    }
                } else if (type.equals("cylindrical")) {
                    switch (dimension) {
                        case 3: {
                            cs = factory.createCylindricalCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else if (type.equals("affine")) {
                    switch (dimension) {
                        case 2: {
                            cs = factory.createAffineCS(properties, axis[0], axis[1]);
                            break;
                        }
                        case 3: {
                            cs = factory.createAffineCS(properties, axis[0], axis[1], axis[2]);
                        }
                    }
                } else {
                    result.close();
                    throw new FactoryException(Errors.format(187, type));
                }
                if (cs == null) {
                    result.close();
                    throw new FactoryException(Errors.format(173, type));
                }
                returnValue = DirectEpsgFactory.ensureSingleton(cs, returnValue, code);
            }
            result.close();
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(CoordinateSystem.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateSystem.class, code);
        }
        return returnValue;
    }

    private String toPrimaryKeyCRS(String code) throws SQLException, FactoryException {
        return this.toPrimaryKey(CoordinateReferenceSystem.class, code, "[Coordinate Reference System]", "COORD_REF_SYS_CODE", "COORD_REF_SYS_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        CoordinateReferenceSystem returnValue = null;
        try {
            String primaryKey = this.toPrimaryKeyCRS(code);
            PreparedStatement stmt = this.prepareStatement("CoordinateReferenceSystem", "SELECT COORD_REF_SYS_CODE, COORD_REF_SYS_NAME, AREA_OF_USE_CODE, CRS_SCOPE, REMARKS, COORD_REF_SYS_KIND, COORD_SYS_CODE, DATUM_CODE, SOURCE_GEOGCRS_CODE, PROJECTION_CONV_CODE, CMPD_HORIZCRS_CODE, CMPD_VERTCRS_CODE FROM [Coordinate Reference System] WHERE COORD_REF_SYS_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                void var13_14;
                Map<String, Object> properties;
                CoordinateSystem cs;
                String dmCode;
                String csCode;
                String epsg = DirectEpsgFactory.getString(result, 1, code);
                String name = DirectEpsgFactory.getString(result, 2, code);
                String area = result.getString(3);
                String scope = result.getString(4);
                String remarks = result.getString(5);
                String type = DirectEpsgFactory.getString(result, 6, code);
                CRSFactory factory = this.factories.getCRSFactory();
                if (type.equalsIgnoreCase("geographic 2D") || type.equalsIgnoreCase("geographic 3D")) {
                    void var17_29;
                    csCode = DirectEpsgFactory.getString(result, 7, code);
                    dmCode = result.getString(8);
                    cs = this.buffered.createEllipsoidalCS(csCode);
                    if (dmCode != null) {
                        GeodeticDatum geodeticDatum = this.buffered.createGeodeticDatum(dmCode);
                    } else {
                        String geoCode = DirectEpsgFactory.getString(result, 9, code, 8);
                        result.close();
                        result = null;
                        GeographicCRS baseCRS = this.buffered.createGeographicCRS(geoCode);
                        GeodeticDatum geodeticDatum = baseCRS.getDatum();
                    }
                    properties = this.createProperties(name, epsg, area, scope, remarks);
                    GeographicCRS geographicCRS = factory.createGeographicCRS(properties, (GeodeticDatum)var17_29, (EllipsoidalCS)cs);
                } else if (type.equalsIgnoreCase("projected")) {
                    csCode = DirectEpsgFactory.getString(result, 7, code);
                    String geoCode = DirectEpsgFactory.getString(result, 9, code);
                    String opCode = DirectEpsgFactory.getString(result, 10, code);
                    result.close();
                    result = null;
                    CartesianCS cartesianCS = this.buffered.createCartesianCS(csCode);
                    GeographicCRS baseCRS = this.buffered.createGeographicCRS(geoCode);
                    CoordinateOperation op = this.buffered.createCoordinateOperation(opCode);
                    if (!(op instanceof Conversion)) {
                        throw this.noSuchAuthorityCode(Projection.class, opCode);
                    }
                    Map<String, Object> properties2 = this.createProperties(name, epsg, area, scope, remarks);
                    ProjectedCRS projectedCRS = factory.createProjectedCRS(properties2, baseCRS, (Conversion)op, cartesianCS);
                } else if (type.equalsIgnoreCase("vertical")) {
                    csCode = DirectEpsgFactory.getString(result, 7, code);
                    dmCode = DirectEpsgFactory.getString(result, 8, code);
                    cs = this.buffered.createVerticalCS(csCode);
                    VerticalDatum verticalDatum = this.buffered.createVerticalDatum(dmCode);
                    properties = this.createProperties(name, epsg, area, scope, remarks);
                    VerticalCRS verticalCRS = factory.createVerticalCRS(properties, verticalDatum, (VerticalCS)cs);
                } else if (type.equalsIgnoreCase("compound")) {
                    CoordinateReferenceSystem coordinateReferenceSystem;
                    CoordinateReferenceSystem crs1;
                    String code1 = DirectEpsgFactory.getString(result, 11, code);
                    String code2 = DirectEpsgFactory.getString(result, 12, code);
                    result.close();
                    result = null;
                    if (!this.safetyGuard.add(epsg)) {
                        throw DirectEpsgFactory.recursiveCall(CompoundCRS.class, epsg);
                    }
                    try {
                        crs1 = this.buffered.createCoordinateReferenceSystem(code1);
                        coordinateReferenceSystem = this.buffered.createCoordinateReferenceSystem(code2);
                    }
                    finally {
                        this.safetyGuard.remove(epsg);
                    }
                    properties = this.createProperties(name, epsg, area, scope, remarks);
                    CompoundCRS compoundCRS = factory.createCompoundCRS(properties, new CoordinateReferenceSystem[]{crs1, coordinateReferenceSystem});
                } else if (type.equalsIgnoreCase("geocentric")) {
                    csCode = DirectEpsgFactory.getString(result, 7, code);
                    dmCode = DirectEpsgFactory.getString(result, 8, code);
                    cs = this.buffered.createCoordinateSystem(csCode);
                    GeodeticDatum geodeticDatum = this.buffered.createGeodeticDatum(dmCode);
                    properties = this.createProperties(name, epsg, area, scope, remarks);
                    if (cs instanceof CartesianCS) {
                        GeocentricCRS geocentricCRS = factory.createGeocentricCRS(properties, geodeticDatum, (CartesianCS)cs);
                    } else {
                        if (!(cs instanceof SphericalCS)) {
                            result.close();
                            throw new FactoryException(Errors.format(63, cs.getClass(), GeocentricCRS.class));
                        }
                        GeocentricCRS geocentricCRS = factory.createGeocentricCRS(properties, geodeticDatum, (SphericalCS)cs);
                    }
                } else {
                    if (!type.equalsIgnoreCase("engineering")) {
                        result.close();
                        throw new FactoryException(Errors.format(187, type));
                    }
                    csCode = DirectEpsgFactory.getString(result, 7, code);
                    dmCode = DirectEpsgFactory.getString(result, 8, code);
                    cs = this.buffered.createCoordinateSystem(csCode);
                    EngineeringDatum engineeringDatum = this.buffered.createEngineeringDatum(dmCode);
                    properties = this.createProperties(name, epsg, area, scope, remarks);
                    EngineeringCRS engineeringCRS = factory.createEngineeringCRS(properties, engineeringDatum, cs);
                }
                returnValue = DirectEpsgFactory.ensureSingleton(var13_14, returnValue, code);
                if (result != null) continue;
                return returnValue;
            }
            result.close();
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(CoordinateReferenceSystem.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateReferenceSystem.class, code);
        }
        return returnValue;
    }

    @Override
    public synchronized ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        ParameterDescriptor returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(ParameterDescriptor.class, code, "[Coordinate_Operation Parameter]", "PARAMETER_CODE", "PARAMETER_NAME");
            PreparedStatement stmt = this.prepareStatement("ParameterDescriptor", "SELECT PARAMETER_CODE, PARAMETER_NAME, DESCRIPTION FROM [Coordinate_Operation Parameter] WHERE PARAMETER_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                Class<Double> type;
                Unit<?> unit;
                String epsg = DirectEpsgFactory.getString(result, 1, code);
                String name = DirectEpsgFactory.getString(result, 2, code);
                String remarks = result.getString(3);
                PreparedStatement units = this.prepareStatement("ParameterUnit", "SELECT MIN(UOM_CODE) AS UOM, MIN(PARAM_VALUE_FILE_REF) AS FILEREF FROM [Coordinate_Operation Parameter Value] WHERE (PARAMETER_CODE = ?) GROUP BY UOM_CODE ORDER BY COUNT(UOM_CODE) DESC");
                units.setInt(1, Integer.parseInt(epsg));
                ResultSet resultUnits = units.executeQuery();
                if (resultUnits.next()) {
                    String element = resultUnits.getString(1);
                    unit = element != null ? this.buffered.createUnit(element) : null;
                    element = resultUnits.getString(2);
                    type = element != null && element.trim().length() != 0 ? URI.class : Double.TYPE;
                } else {
                    unit = null;
                    type = Double.TYPE;
                }
                resultUnits.close();
                Map<String, Object> properties = this.createProperties(name, epsg, remarks);
                DefaultParameterDescriptor<Object> descriptor = new DefaultParameterDescriptor<Object>(properties, type, null, null, null, null, unit, true);
                returnValue = DirectEpsgFactory.ensureSingleton(descriptor, returnValue, code);
            }
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(OperationMethod.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code);
        }
        return returnValue;
    }

    private ParameterDescriptor[] createParameterDescriptors(String method) throws FactoryException, SQLException {
        PreparedStatement stmt = this.prepareStatement("ParameterDescriptors", "SELECT PARAMETER_CODE FROM [Coordinate_Operation Parameter Usage] WHERE COORD_OP_METHOD_CODE = ? ORDER BY SORT_ORDER");
        stmt.setInt(1, Integer.parseInt(method));
        ResultSet results = stmt.executeQuery();
        ArrayList<ParameterDescriptor> descriptors = new ArrayList<ParameterDescriptor>();
        while (results.next()) {
            String param = DirectEpsgFactory.getString(results, 1, method);
            descriptors.add(this.buffered.createParameterDescriptor(param));
        }
        results.close();
        return descriptors.toArray(new ParameterDescriptor[descriptors.size()]);
    }

    private void fillParameterValues(String method, String operation, ParameterValueGroup parameters) throws FactoryException, SQLException {
        PreparedStatement stmt = this.prepareStatement("ParameterValues", "SELECT CP.PARAMETER_NAME, CV.PARAMETER_VALUE, CV.PARAM_VALUE_FILE_REF, CV.UOM_CODE FROM ([Coordinate_Operation Parameter Value] AS CV INNER JOIN [Coordinate_Operation Parameter] AS CP ON CV.PARAMETER_CODE = CP.PARAMETER_CODE) INNER JOIN [Coordinate_Operation Parameter Usage] AS CU ON (CP.PARAMETER_CODE = CU.PARAMETER_CODE) AND (CV.COORD_OP_METHOD_CODE = CU.COORD_OP_METHOD_CODE) WHERE CV.COORD_OP_METHOD_CODE = ? AND CV.COORD_OP_CODE = ? ORDER BY CU.SORT_ORDER");
        stmt.setInt(1, Integer.parseInt(method));
        stmt.setInt(2, Integer.parseInt(operation));
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            ParameterValue<?> param;
            Unit<?> unit;
            Object reference;
            String name = DirectEpsgFactory.getString(result, 1, operation);
            double value = result.getDouble(2);
            if (result.wasNull()) {
                reference = DirectEpsgFactory.getString(result, 3, operation);
                try {
                    reference = new URI((String)reference);
                }
                catch (URISyntaxException exception) {
                    reference = new File((String)reference);
                }
                unit = null;
            } else {
                reference = null;
                String unitCode = result.getString(4);
                unit = unitCode != null ? this.buffered.createUnit(unitCode) : null;
            }
            try {
                param = parameters.parameter(name);
            }
            catch (ParameterNotFoundException exception) {
                NoSuchIdentifierException e = new NoSuchIdentifierException(Errors.format(32, name), name);
                e.initCause(exception);
                throw e;
            }
            try {
                if (reference != null) {
                    param.setValue(reference);
                    continue;
                }
                if (unit != null) {
                    param.setValue(value, unit);
                    continue;
                }
                param.setValue(value);
            }
            catch (InvalidParameterValueException exception) {
                throw new FactoryException(Errors.format(32, name), exception);
            }
        }
        result.close();
    }

    @Override
    public synchronized OperationMethod createOperationMethod(String code) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("code", code);
        OperationMethod returnValue = null;
        try {
            String primaryKey = this.toPrimaryKey(OperationMethod.class, code, "[Coordinate_Operation Method]", "COORD_OP_METHOD_CODE", "COORD_OP_METHOD_NAME");
            PreparedStatement stmt = this.prepareStatement("OperationMethod", "SELECT COORD_OP_METHOD_CODE, COORD_OP_METHOD_NAME, FORMULA, REMARKS FROM [Coordinate_Operation Method] WHERE COORD_OP_METHOD_CODE = ?");
            stmt.setInt(1, Integer.parseInt(primaryKey));
            ResultSet result = stmt.executeQuery();
            DefaultOperationMethod method = null;
            while (result.next()) {
                String epsg = DirectEpsgFactory.getString(result, 1, code);
                String name = DirectEpsgFactory.getString(result, 2, code);
                String formula = result.getString(3);
                String remarks = result.getString(4);
                int encoded = this.getDimensionsForMethod(epsg);
                int sourceDimensions = encoded >>> 16;
                int targetDimensions = encoded & 0xFFFF;
                GeneralParameterDescriptor[] descriptors = this.createParameterDescriptors(epsg);
                GenericName[] aliases = null;
                try {
                    ParameterValueGroup pvg = this.factories.getMathTransformFactory().getDefaultParameters(name);
                    if (pvg != null && pvg.getDescriptor() != null && pvg.getDescriptor().getAlias() != null) {
                        aliases = pvg.getDescriptor().getAlias().toArray(new GenericName[pvg.getDescriptor().getAlias().size()]);
                    }
                }
                catch (NoSuchIdentifierException pvg) {
                    // empty catch block
                }
                Map<String, Object> properties = this.addAliases(this.createProperties(name, epsg, remarks), aliases);
                if (formula != null) {
                    properties.put("formula", formula);
                }
                method = new DefaultOperationMethod(properties, sourceDimensions, targetDimensions, new DefaultParameterDescriptorGroup(properties, descriptors));
                returnValue = DirectEpsgFactory.ensureSingleton(method, returnValue, code);
            }
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(OperationMethod.class, code, exception);
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(OperationMethod.class, code);
        }
        return returnValue;
    }

    private Map<String, Object> addAliases(Map<String, Object> properties, GenericName[] aliases) {
        DirectEpsgFactory.ensureNonNull("properties", properties);
        Object value = properties.get("name");
        DirectEpsgFactory.ensureNonNull("name", value);
        if (value instanceof Identifier) {
            ((Identifier)value).getCode();
        } else {
            value.toString();
        }
        if (aliases != null && aliases.length > 0) {
            int count = aliases.length;
            value = properties.get("alias");
            if (value != null) {
                LinkedHashMap<String, GenericName> merged = new LinkedHashMap<String, GenericName>();
                DirectEpsgFactory.putAll(NameFactory.toArray(value), merged);
                count -= DirectEpsgFactory.putAll(aliases, merged);
                Collection c = merged.values();
                aliases = c.toArray(new GenericName[c.size()]);
            }
            if (count > 0) {
                HashMap<String, Object> copy = new HashMap<String, Object>(properties);
                copy.put("alias", aliases);
                properties = copy;
            }
        }
        return properties;
    }

    private static final int putAll(GenericName[] names, Map<String, GenericName> map) {
        int ignored = 0;
        for (int i = 0; i < names.length; ++i) {
            GenericName name = names[i];
            GenericName scoped = name.toFullyQualifiedName();
            String key = DirectEpsgFactory.toCaseless(scoped.toString());
            GenericName old = map.put(key, name);
            if (!(old instanceof ScopedName)) continue;
            map.put(key, old);
            ++ignored;
        }
        return ignored;
    }

    private static String toCaseless(String key) {
        return key.replace('_', ' ').trim().toLowerCase();
    }

    private int getDimensionsForMethod(String code) throws SQLException {
        Dimensions temp;
        PreparedStatement stmt = this.prepareStatement("MethodDimensions", "SELECT SOURCE_CRS_CODE, TARGET_CRS_CODE FROM [Coordinate_Operation] WHERE COORD_OP_METHOD_CODE = ? AND SOURCE_CRS_CODE IS NOT NULL AND TARGET_CRS_CODE IS NOT NULL");
        stmt.setInt(1, Integer.parseInt(code));
        ResultSet result = stmt.executeQuery();
        HashMap<Dimensions, Dimensions> dimensions = new HashMap<Dimensions, Dimensions>();
        Dimensions max = temp = new Dimensions(131074);
        while (result.next()) {
            short sourceDimensions = this.getDimensionForCRS(result.getString(1));
            short targetDimensions = this.getDimensionForCRS(result.getString(2));
            temp.encoded = sourceDimensions << 16 | targetDimensions;
            Dimensions candidate = (Dimensions)dimensions.get(temp);
            if (candidate == null) {
                candidate = new Dimensions(temp.encoded);
                dimensions.put(candidate, candidate);
            }
            if (++candidate.occurences <= max.occurences) continue;
            max = candidate;
        }
        result.close();
        return max.encoded;
    }

    private short getDimensionForCRS(String code) throws SQLException {
        short dimension;
        Short cached = this.axisCounts.get(code);
        if (cached == null) {
            PreparedStatement stmt = this.prepareStatement("Dimension", "  SELECT COUNT(COORD_AXIS_CODE) FROM [Coordinate Axis] WHERE COORD_SYS_CODE = (SELECT COORD_SYS_CODE  FROM [Coordinate Reference System] WHERE COORD_REF_SYS_CODE = ?)");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            dimension = result.next() ? (short)result.getShort(1) : (short)2;
            this.axisCounts.put(code, dimension);
            result.close();
        } else {
            dimension = cached;
        }
        return dimension;
    }

    final boolean isProjection(String code) throws SQLException {
        Boolean projection = this.codeProjection.get(code);
        if (projection == null) {
            PreparedStatement stmt = this.prepareStatement("isProjection", "SELECT COORD_REF_SYS_CODE FROM [Coordinate Reference System] WHERE PROJECTION_CONV_CODE = ? AND COORD_REF_SYS_KIND LIKE 'projected%'");
            stmt.setString(1, code);
            ResultSet result = stmt.executeQuery();
            boolean found = result.next();
            result.close();
            projection = found;
            this.codeProjection.put(code, projection);
        }
        return projection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        CoordinateOperation returnValue;
        block50: {
            CoordinateOperation operation;
            Map<String, Object> properties;
            ParameterValueGroup parameters;
            OperationMethod method;
            CoordinateReferenceSystem targetCRS;
            CoordinateReferenceSystem sourceCRS;
            boolean isConversion;
            boolean isTransformation;
            String type;
            DirectEpsgFactory.ensureNonNull("code", code);
            returnValue = null;
            ResultSet result = null;
            try {
                String primaryKey = this.toPrimaryKey(CoordinateOperation.class, code, "[Coordinate_Operation]", "COORD_OP_CODE", "COORD_OP_NAME");
                PreparedStatement stmt = this.prepareStatement("CoordinateOperation", "SELECT COORD_OP_CODE, COORD_OP_NAME, COORD_OP_TYPE, SOURCE_CRS_CODE, TARGET_CRS_CODE, COORD_OP_METHOD_CODE, COORD_TFM_VERSION, COORD_OP_ACCURACY, AREA_OF_USE_CODE, COORD_OP_SCOPE, REMARKS FROM [Coordinate_Operation] WHERE COORD_OP_CODE = ?");
                stmt.setInt(1, Integer.parseInt(primaryKey));
                result = stmt.executeQuery();
                while (this.hasNext(result)) {
                    boolean isBursaWolf;
                    int targetDimensions;
                    int sourceDimensions;
                    String targetCode;
                    String sourceCode;
                    String epsg = DirectEpsgFactory.getString(result, 1, code);
                    String name = DirectEpsgFactory.getString(result, 2, code);
                    type = DirectEpsgFactory.getString(result, 3, code).trim().toLowerCase();
                    isTransformation = type.equals("transformation");
                    isConversion = type.equals("conversion");
                    boolean isConcatenated = type.equals("concatenated operation");
                    if (isConversion) {
                        sourceCode = result.getString(4);
                        targetCode = result.getString(5);
                    } else {
                        sourceCode = DirectEpsgFactory.getString(result, 4, code);
                        targetCode = DirectEpsgFactory.getString(result, 5, code);
                    }
                    String methodCode = isConcatenated ? result.getString(6) : DirectEpsgFactory.getString(result, 6, code);
                    String version = result.getString(7);
                    double accuracy = result.getDouble(8);
                    if (result.wasNull()) {
                        accuracy = Double.NaN;
                    }
                    String area = result.getString(9);
                    String scope = result.getString(10);
                    String remarks = result.getString(11);
                    if (sourceCode != null) {
                        sourceCRS = this.buffered.createCoordinateReferenceSystem(sourceCode);
                        sourceDimensions = sourceCRS.getCoordinateSystem().getDimension();
                    } else {
                        sourceCRS = null;
                        sourceDimensions = 2;
                    }
                    if (targetCode != null) {
                        targetCRS = this.buffered.createCoordinateReferenceSystem(targetCode);
                        targetDimensions = targetCRS.getCoordinateSystem().getDimension();
                    } else {
                        targetCRS = null;
                        targetDimensions = 2;
                    }
                    if (methodCode == null) {
                        isBursaWolf = false;
                        method = null;
                        parameters = null;
                    } else {
                        int num;
                        try {
                            num = Integer.parseInt(methodCode);
                        }
                        catch (NumberFormatException exception) {
                            throw new FactoryException(exception);
                        }
                        isBursaWolf = num >= 9603 && num <= 9607;
                        method = this.buffered.createOperationMethod(methodCode);
                        if (method.getSourceDimensions() != sourceDimensions || method.getTargetDimensions() != targetDimensions) {
                            method = new DefaultOperationMethod(method, sourceDimensions, targetDimensions);
                        }
                        String classe = method.getName().getCode();
                        parameters = this.factories.getMathTransformFactory().getDefaultParameters(classe);
                        this.fillParameterValues(methodCode, epsg, parameters);
                    }
                    properties = this.createProperties(name, epsg, area, scope, remarks);
                    if (version != null && (version = version.trim()).length() != 0) {
                        properties.put("operationVersion", version);
                    }
                    if (!Double.isNaN(accuracy)) {
                        QuantitativeResultImpl accuracyResult = new QuantitativeResultImpl(new double[]{accuracy});
                        accuracyResult.setValueUnit(SI.METER);
                        AbsoluteExternalPositionalAccuracyImpl accuracyElement = new AbsoluteExternalPositionalAccuracyImpl(accuracyResult);
                        accuracyElement.setMeasureDescription(TRANSFORMATION_ACCURACY);
                        accuracyElement.setEvaluationMethodType(EvaluationMethodType.DIRECT_EXTERNAL);
                        properties.put("coordinateOperationAccuracy", new PositionalAccuracy[]{(PositionalAccuracy)((Object)accuracyElement.unmodifiable())});
                    }
                    if (isConversion && (sourceCRS == null || targetCRS == null)) {
                        operation = new DefiningConversion(properties, method, parameters);
                        break block47;
                    }
                    if (isConcatenated) {
                        result = null;
                        PreparedStatement cstmt = this.prepareStatement("ConcatenatedOperation", "SELECT SINGLE_OPERATION_CODE FROM [Coordinate_Operation Path] WHERE (CONCAT_OPERATION_CODE = ?) ORDER BY OP_PATH_STEP");
                        cstmt.setString(1, epsg);
                        ResultSet cr = cstmt.executeQuery();
                        ArrayList<String> codes = new ArrayList<String>();
                        while (cr.next()) {
                            codes.add(cr.getString(1));
                        }
                        cr.close();
                        CoordinateOperation[] operations = new CoordinateOperation[codes.size()];
                        if (!this.safetyGuard.add(epsg)) {
                            throw DirectEpsgFactory.recursiveCall(ConcatenatedOperation.class, epsg);
                        }
                        try {
                            for (int i = 0; i < operations.length; ++i) {
                                operations[i] = this.buffered.createCoordinateOperation((String)codes.get(i));
                            }
                        }
                        finally {
                            this.safetyGuard.remove(epsg);
                        }
                        try {
                            DefaultConcatenatedOperation i = new DefaultConcatenatedOperation(properties, operations);
                            return i;
                        }
                        catch (IllegalArgumentException exception) {
                            throw new FactoryException(exception);
                        }
                    }
                    if (!isBursaWolf) break block49;
                }
                break block50;
            }
            catch (SQLException exception) {
                throw DirectEpsgFactory.databaseFailure(CoordinateOperation.class, code, exception);
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception exception) {}
                }
            }
            {
                block47: {
                    Class expected;
                    block49: {
                        try {
                            Unit<Length> axisUnit;
                            Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(sourceCRS);
                            if (ellipsoid != null) {
                                axisUnit = ellipsoid.getAxisUnit();
                                parameters.parameter("src_semi_major").setValue(ellipsoid.getSemiMajorAxis(), axisUnit);
                                parameters.parameter("src_semi_minor").setValue(ellipsoid.getSemiMinorAxis(), axisUnit);
                                parameters.parameter("src_dim").setValue(sourceCRS.getCoordinateSystem().getDimension());
                            }
                            if ((ellipsoid = CRSUtilities.getHeadGeoEllipsoid(targetCRS)) != null) {
                                axisUnit = ellipsoid.getAxisUnit();
                                parameters.parameter("tgt_semi_major").setValue(ellipsoid.getSemiMajorAxis(), axisUnit);
                                parameters.parameter("tgt_semi_minor").setValue(ellipsoid.getSemiMinorAxis(), axisUnit);
                                parameters.parameter("tgt_dim").setValue(targetCRS.getCoordinateSystem().getDimension());
                            }
                        }
                        catch (ParameterNotFoundException exception) {
                            throw new FactoryException(Errors.format(52, method.getName().getCode(), exception));
                        }
                    }
                    if (isTransformation) {
                        expected = Transformation.class;
                    } else if (isConversion) {
                        expected = Conversion.class;
                    } else {
                        throw new FactoryException(Errors.format(187, type));
                    }
                    MathTransform mt = this.factories.getMathTransformFactory().createBaseToDerived(sourceCRS, parameters, targetCRS.getCoordinateSystem());
                    operation = DefaultOperation.create(properties, sourceCRS, targetCRS, mt, method, expected);
                }
                returnValue = DirectEpsgFactory.ensureSingleton(operation, returnValue, code);
                continue;
                break;
            }
        }
        if (returnValue == null) {
            throw this.noSuchAuthorityCode(CoordinateOperation.class, code);
        }
        return returnValue;
    }

    private boolean hasNext(ResultSet result) throws SQLException {
        try {
            return result.next();
        }
        catch (SQLException e) {
            if (result.isClosed()) {
                return false;
            }
            throw e;
        }
    }

    public synchronized Set createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        DirectEpsgFactory.ensureNonNull("sourceCode", sourceCode);
        DirectEpsgFactory.ensureNonNull("targetCode", targetCode);
        String pair = sourceCode + " \u21e8 " + targetCode;
        CoordinateOperationSet set = new CoordinateOperationSet(this.buffered);
        try {
            String sourceKey = this.toPrimaryKeyCRS(sourceCode);
            String targetKey = this.toPrimaryKeyCRS(targetCode);
            boolean searchTransformations = false;
            do {
                String sql;
                String key;
                if (searchTransformations) {
                    key = "TransformationFromCRS";
                    sql = "SELECT COORD_OP_CODE FROM [Coordinate_Operation] left join [Area] on [Coordinate_Operation].area_of_use_code = [Area].area_code WHERE SOURCE_CRS_CODE = ? AND TARGET_CRS_CODE = ? ORDER BY ABS([Coordinate_Operation].DEPRECATED), COORD_OP_ACCURACY,\t(AREA_NORTH_BOUND_LAT - AREA_SOUTH_BOUND_LAT) *  (CASE WHEN AREA_EAST_BOUND_LON > AREA_WEST_BOUND_LON      THEN (AREA_EAST_BOUND_LON - AREA_WEST_BOUND_LON)      ELSE (360 - AREA_WEST_BOUND_LON - AREA_EAST_BOUND_LON) END) DESC, COORD_OP_CODE DESC";
                } else {
                    key = "ConversionFromCRS";
                    sql = "SELECT PROJECTION_CONV_CODE FROM [Coordinate Reference System] WHERE SOURCE_GEOGCRS_CODE = ? AND COORD_REF_SYS_CODE = ?";
                }
                PreparedStatement stmt = this.prepareStatement(key, sql);
                stmt.setString(1, sourceKey);
                stmt.setString(2, targetKey);
                ResultSet result = stmt.executeQuery();
                while (result.next()) {
                    String code = DirectEpsgFactory.getString(result, 1, pair);
                    set.addAuthorityCode(code, searchTransformations ? null : targetKey);
                }
                result.close();
            } while (searchTransformations = !searchTransformations);
            Object[] codes = set.getAuthorityCodes();
            this.sort(codes);
            set.setAuthorityCodes((String[])codes);
        }
        catch (SQLException exception) {
            throw DirectEpsgFactory.databaseFailure(CoordinateOperation.class, pair, exception);
        }
        set.resolve(1);
        return set;
    }

    private void sort(Object[] codes) throws SQLException, FactoryException {
        if (codes.length <= 1) {
            return;
        }
        PreparedStatement stmt = this.prepareStatement("Supersession", "SELECT SUPERSEDED_BY FROM [Supersession] WHERE OBJECT_CODE = ? ORDER BY SUPERSESSION_YEAR DESC");
        int maxIterations = 15;
        do {
            boolean changed = false;
            for (int i = 0; i < codes.length; ++i) {
                String code = codes[i].toString();
                stmt.setInt(1, Integer.parseInt(code));
                ResultSet result = stmt.executeQuery();
                while (result.next()) {
                    String replacement = DirectEpsgFactory.getString(result, 1, code);
                    for (int j = i + 1; j < codes.length; ++j) {
                        Object candidate = codes[j];
                        if (!replacement.equals(candidate.toString())) continue;
                        System.arraycopy(codes, i, codes, i + 1, j - i);
                        codes[i++] = candidate;
                        changed = true;
                    }
                }
                result.close();
            }
            if (changed) continue;
            return;
        } while (--maxIterations != 0);
        LOGGER.finer("Possible recursivity in supersessions.");
    }

    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class type) throws FactoryException {
        return new Finder(this.buffered, type);
    }

    private static FactoryException recursiveCall(Class type, String code) {
        return new FactoryException(Errors.format(164, type, code));
    }

    private static FactoryException databaseFailure(Class type, String code, SQLException cause) {
        return new FactoryException(Errors.format(38, type, code), cause);
    }

    protected abstract String adaptSQL(String var1);

    protected boolean isPrimaryKey(String code) throws FactoryException {
        int length = code.length();
        for (int i = 0; i < length; ++i) {
            char c = code.charAt(i);
            if (Character.isDigit(c) || Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    final synchronized boolean canDispose() {
        boolean can = true;
        IdentityHashMap<SoftReference, WeakReference<AuthorityCodes>> pool = null;
        Iterator<Map.Entry<Class<?>, Reference<AuthorityCodes>>> it = this.authorityCodes.entrySet().iterator();
        while (it.hasNext()) {
            WeakReference<AuthorityCodes> weak;
            Map.Entry<Class<?>, Reference<AuthorityCodes>> entry = it.next();
            Reference<AuthorityCodes> reference = entry.getValue();
            AuthorityCodes codes = reference.get();
            if (codes == null) {
                it.remove();
                continue;
            }
            can = false;
            if (!(reference instanceof SoftReference)) continue;
            if (pool == null) {
                pool = new IdentityHashMap<SoftReference, WeakReference<AuthorityCodes>>();
            }
            if ((weak = (WeakReference<AuthorityCodes>)pool.get(reference)) == null) {
                weak = new WeakReference<AuthorityCodes>(codes);
                pool.put((SoftReference)reference, weak);
            }
            entry.setValue((Reference<AuthorityCodes>)weak);
        }
        return can;
    }

    @Override
    public synchronized void dispose() throws FactoryException {
        boolean isClosed;
        try {
            Connection connection = this.getConnection();
            isClosed = connection.isClosed();
            Iterator<Object> it = this.authorityCodes.values().iterator();
            while (it.hasNext()) {
                AuthorityCodes set = it.next().get();
                if (set != null) {
                    set.finalize();
                }
                it.remove();
            }
            it = this.statements.values().iterator();
            while (it.hasNext()) {
                ((PreparedStatement)it.next()).close();
                it.remove();
            }
            this.shutdown(true);
            connection.close();
            this.dataSource = null;
        }
        catch (SQLException exception) {
            throw new FactoryException(exception);
        }
        super.dispose();
        try {
            this.shutdown(false);
        }
        catch (SQLException exception) {
            throw new FactoryException(exception);
        }
        if (!isClosed) {
            LogRecord record = Loggings.format(Level.FINE, 12);
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
    }

    protected void shutdown(boolean active) throws SQLException {
    }

    protected final void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    protected synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        } else if (this.connection.isClosed() || !this.isConnectionValid(this.connection)) {
            this.statements.clear();
            try {
                this.connection.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, "Error occurred while closing an invalid connection", e);
            }
            this.connection = this.dataSource.getConnection();
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnectionValid(Connection conn) {
        if (this.validationQuery == null) {
            return true;
        }
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute(this.validationQuery);
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return true;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    private final class Finder
    extends IdentifiedObjectFinder {
        Finder(AbstractAuthorityFactory buffered, Class type) {
            super(buffered, type);
        }

        @Override
        protected Set getCodeCandidates(IdentifiedObject object) throws FactoryException {
            String code;
            String where;
            String select = "COORD_REF_SYS_CODE";
            String from = "[Coordinate Reference System]";
            if (object instanceof Ellipsoid) {
                select = "ELLIPSOID_CODE";
                from = "[Ellipsoid]";
                where = "SEMI_MAJOR_AXIS";
                code = Double.toString(((Ellipsoid)object).getSemiMajorAxis());
            } else {
                IdentifiedObject dependency;
                if (object instanceof GeneralDerivedCRS) {
                    dependency = ((GeneralDerivedCRS)object).getBaseCRS();
                    where = "SOURCE_GEOGCRS_CODE";
                } else if (object instanceof SingleCRS) {
                    dependency = ((SingleCRS)object).getDatum();
                    where = "DATUM_CODE";
                } else if (object instanceof GeodeticDatum) {
                    dependency = ((GeodeticDatum)object).getEllipsoid();
                    select = "DATUM_CODE";
                    from = "[Datum]";
                    where = "ELLIPSOID_CODE";
                } else {
                    return super.getCodeCandidates(object);
                }
                dependency = DirectEpsgFactory.this.buffered.getIdentifiedObjectFinder(dependency.getClass()).find(dependency);
                ReferenceIdentifier id = AbstractIdentifiedObject.getIdentifier(dependency, this.getAuthority());
                if (id == null || (code = id.getCode()) == null) {
                    return super.getCodeCandidates(object);
                }
            }
            String sql = "SELECT " + select + " FROM " + from + " WHERE " + where + "='" + code + '\'';
            sql = DirectEpsgFactory.this.adaptSQL(sql);
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            try {
                Statement s = DirectEpsgFactory.this.getConnection().createStatement();
                ResultSet r = s.executeQuery(sql);
                while (r.next()) {
                    result.add(r.getString(1));
                }
                r.close();
                s.close();
            }
            catch (SQLException exception) {
                throw DirectEpsgFactory.databaseFailure(Identifier.class, code, exception);
            }
            return result;
        }
    }

    private static final class Dimensions {
        int encoded;
        int occurences;

        Dimensions(int e) {
            this.encoded = e;
        }

        public int hashCode() {
            return this.encoded;
        }

        public boolean equals(Object object) {
            return object instanceof Dimensions && ((Dimensions)object).encoded == this.encoded;
        }

        public String toString() {
            return "[(" + (this.encoded >>> 16) + ',' + (this.encoded & 0xFFFF) + ")\u00d7" + this.occurences + ']';
        }
    }
}

