/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.RenderedOp;
import javax.media.jai.registry.RIFRegistry;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.BaseStatisticsOperationJAI;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.util.logging.Logging;
import org.jaitools.media.jai.zonalstats.ZonalStatsDescriptor;
import org.jaitools.media.jai.zonalstats.ZonalStatsRIF;
import org.jaitools.numeric.Statistic;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class ZonalStats
extends BaseStatisticsOperationJAI {
    private static final long serialVersionUID = -2027327652181137851L;
    public static final Logger LOGGER;
    public static final String GT_SYNTHETIC_PROPERTY_MIN;
    public static final String GT_SYNTHETIC_PROPERTY_MAX;
    public static final String GT_SYNTHETIC_PROPERTY_MEAN;
    public static final String GT_SYNTHETIC_PROPERTY_VAR;
    public static final String GT_SYNTHETIC_PROPERTY_SDEV;
    public static final String GT_SYNTHETIC_PROPERTY_RANGE;
    public static final String GT_SYNTHETIC_PROPERTY_MEDIAN;
    public static final String GT_SYNTHETIC_PROPERTY_APPROX_MEDIAN;
    public static final String GT_SYNTHETIC_PROPERTY_SUM;

    public ZonalStats() throws OperationNotFoundException {
        super(ZonalStats.getOperationDescriptor("ZonalStats"));
    }

    @Override
    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform toCRS, GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        if (data instanceof RenderedOp) {
            double[] sum;
            double[] approx_median;
            double[] median;
            double[] range;
            double[] sdev;
            double[] var;
            double[] means;
            double[] maximums;
            RenderedOp result = (RenderedOp)data;
            HashMap<String, double[]> synthProp = new HashMap<String, double[]>();
            double[] minimums = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_MIN);
            if (minimums != null) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_MIN, minimums);
            }
            if ((maximums = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_MAX)) != null) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_MAX, maximums);
            }
            if ((means = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_MEAN)) != null) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_MEAN, means);
            }
            if ((var = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_VAR)) != null) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_VAR, var);
            }
            if ((sdev = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_SDEV)) != null) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_SDEV, sdev);
            }
            if ((range = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_RANGE)) != null) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_RANGE, range);
            }
            if ((median = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_MEDIAN)) != null) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_MEDIAN, median);
            }
            if ((approx_median = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_APPROX_MEDIAN)) != null) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_APPROX_MEDIAN, approx_median);
            }
            if ((sum = (double[])result.getProperty(GT_SYNTHETIC_PROPERTY_SUM)) != null) {
                synthProp.put(GT_SYNTHETIC_PROPERTY_SUM, sum);
            }
            return Collections.unmodifiableMap(synthProp);
        }
        return super.getProperties(data, crs, name, toCRS, sources, parameters);
    }

    static {
        try {
            OperationRegistry or = JAI.getDefaultInstance().getOperationRegistry();
            or.registerDescriptor(new ZonalStatsDescriptor());
            ZonalStatsRIF rif = new ZonalStatsRIF();
            RIFRegistry.register(or, "ZonalStats", "org.jaitools.media.jai", rif);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER = Logging.getLogger("org.geotools.coverage.processing.operation");
        GT_SYNTHETIC_PROPERTY_MIN = Statistic.MIN.toString();
        GT_SYNTHETIC_PROPERTY_MAX = Statistic.MAX.toString();
        GT_SYNTHETIC_PROPERTY_MEAN = Statistic.MEAN.toString();
        GT_SYNTHETIC_PROPERTY_VAR = Statistic.VARIANCE.toString();
        GT_SYNTHETIC_PROPERTY_SDEV = Statistic.SDEV.toString();
        GT_SYNTHETIC_PROPERTY_RANGE = Statistic.RANGE.toString();
        GT_SYNTHETIC_PROPERTY_MEDIAN = Statistic.MEDIAN.toString();
        GT_SYNTHETIC_PROPERTY_APPROX_MEDIAN = Statistic.APPROX_MEDIAN.toString();
        GT_SYNTHETIC_PROPERTY_SUM = Statistic.SUM.toString();
    }
}

