/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import it.geosolutions.jaiext.JAIExt;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import javax.media.jai.Interpolation;
import javax.media.jai.Warp;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.factory.Hints;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class Operations {
    public static final Operations DEFAULT = new Operations(null);
    private CoverageProcessor processor;

    public Operations(RenderingHints hints) {
        this.processor = hints != null && !hints.isEmpty() ? CoverageProcessor.getInstance(new Hints(hints)) : CoverageProcessor.getInstance();
    }

    public Coverage add(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("AddConst", source, "constants", constants);
    }

    public Coverage add(Coverage source0, Coverage source1) throws CoverageProcessingException {
        return this.doOperation("Add", source0, source1);
    }

    public Coverage multiply(Coverage source0, Coverage source1) throws CoverageProcessingException {
        return this.doOperation("Multiply", source0, source1);
    }

    public Coverage subtract(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("SubtractConst", source, "constants", constants);
    }

    public Coverage subtractFrom(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("SubtractFromConst", source, "constants", constants);
    }

    public Coverage multiply(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("MultiplyConst", source, "constants", constants);
    }

    public Coverage divideBy(Coverage source, double[] constants) throws CoverageProcessingException {
        return this.doOperation("DivideByConst", source, "constants", constants);
    }

    public Coverage rescale(Coverage source, double[] constants, double[] offsets) throws CoverageProcessingException {
        return this.doOperation("Rescale", source, "constants", constants, "offsets", offsets);
    }

    public Coverage invert(Coverage source) throws CoverageProcessingException {
        return this.doOperation("Invert", source);
    }

    public Coverage absolute(Coverage source) throws CoverageProcessingException {
        return this.doOperation("Absolute", source);
    }

    public Coverage log(Coverage source) throws CoverageProcessingException {
        return this.doOperation("Log", source);
    }

    public Coverage exp(Coverage source) throws CoverageProcessingException {
        return this.doOperation("Exp", source);
    }

    public Coverage extrema(Coverage source) throws CoverageProcessingException {
        return this.doOperation("Extrema", source);
    }

    public GridCoverage nodataFilter(GridCoverage source) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("NodataFilter", source);
    }

    public GridCoverage nodataFilter(GridCoverage source, int padding, int validityThreshold) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("NodataFilter", source, "padding", padding, "validityThreshold", validityThreshold);
    }

    public GridCoverage interpolate(GridCoverage source, String type) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Interpolate", source, "Type", type);
    }

    public GridCoverage interpolate(GridCoverage source, Interpolation type) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Interpolate", source, "Type", type);
    }

    public GridCoverage interpolate(GridCoverage source, Interpolation[] types) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Interpolate", source, "Type", types);
    }

    public Coverage selectSampleDimension(Coverage source, int[] sampleDimensions) throws CoverageProcessingException {
        return this.doOperation("SelectSampleDimension", source, "SampleDimensions", sampleDimensions);
    }

    public Coverage resample(Coverage source, CoordinateReferenceSystem crs) throws CoverageProcessingException {
        return this.doOperation("Resample", source, "CoordinateReferenceSystem", crs);
    }

    public Coverage resample(GridCoverage source, Envelope envelope, Interpolation interpolationType) throws CoverageProcessingException {
        GridGeometry gridGeometry;
        try {
            gridGeometry = Resample.computeGridGeometry(source, envelope);
        }
        catch (TransformException exception) {
            throw new CoverageProcessingException(exception);
        }
        return this.doOperation("Resample", source, "CoordinateReferenceSystem", envelope.getCoordinateReferenceSystem(), "GridGeometry", gridGeometry, "InterpolationType", interpolationType);
    }

    public Coverage resample(GridCoverage source, CoordinateReferenceSystem crs, GridGeometry gridGeometry, Interpolation interpolationType) throws CoverageProcessingException {
        return this.doOperation("Resample", source, "CoordinateReferenceSystem", crs, "GridGeometry", gridGeometry, "InterpolationType", interpolationType);
    }

    public Coverage resample(GridCoverage source, CoordinateReferenceSystem crs, GridGeometry gridGeometry, Interpolation interpolationType, double[] backgroundValues) throws CoverageProcessingException {
        return this.doOperation("Resample", source, "CoordinateReferenceSystem", crs, "GridGeometry", gridGeometry, "InterpolationType", interpolationType, "BackgroundValues", backgroundValues);
    }

    public Coverage crop(Coverage Source2, Envelope envelope) throws CoverageProcessingException {
        return this.doOperation("CoverageCrop", Source2, "Envelope", envelope);
    }

    public GridCoverage scale(GridCoverage source, double xScale, double yScale, double xTrans, double yTrans) throws CoverageProcessingException {
        return this.scale(source, xScale, yScale, xTrans, yTrans, Interpolation.getInstance(0));
    }

    public GridCoverage warp(GridCoverage source, Warp warp) throws CoverageProcessingException {
        return this.warp(source, warp, Interpolation.getInstance(0));
    }

    public GridCoverage affine(GridCoverage source, AffineTransform transform, Interpolation interpolation, double[] noDataValues) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Affine", source, "transform", transform, "Interpolation", interpolation, "backgroundValues", noDataValues);
    }

    public GridCoverage scale(GridCoverage source, double xScale, double yScale, double xTrans, double yTrans, Interpolation interpolation) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Scale", source, "xScale", Float.valueOf((float)xScale), "yScale", Float.valueOf((float)yScale), "xTrans", Float.valueOf((float)xTrans), "yTrans", Float.valueOf((float)yTrans), "Interpolation", interpolation);
    }

    public GridCoverage warp(GridCoverage source, Warp warp, Interpolation interpolation) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("Warp", source, "warp", warp, "interpolation", interpolation);
    }

    public GridCoverage subsampleAverage(GridCoverage source, double scaleX, double scaleY) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("SubsampleAverage", source, "scaleX", scaleX, "scaleY", scaleY);
    }

    public GridCoverage filteredSubsample(GridCoverage source) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("FilteredSubsample", source);
    }

    public GridCoverage filteredSubsample(GridCoverage source, int scaleX, int scaleY, float[] qsFilter) throws CoverageProcessingException {
        return this.filteredSubsample(source, scaleX, scaleY, qsFilter, Interpolation.getInstance(0));
    }

    public GridCoverage filteredSubsample(GridCoverage source, int scaleX, int scaleY, float[] qsFilter, Interpolation interpolation) throws CoverageProcessingException {
        return (GridCoverage)this.doOperation("FilteredSubsample", source, "scaleX", scaleX, "scaleY", scaleY, "qsFilterArray", qsFilter, "Interpolation", interpolation);
    }

    protected final Coverage doOperation(String operationName, Coverage source) throws OperationNotFoundException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        this.addSources(operationName, parameters, source);
        return this.processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source0, Coverage source1) throws OperationNotFoundException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        this.addSources(operationName, parameters, source0, source1);
        return this.processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        this.addSources(operationName, parameters, source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        return this.processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        this.addSources(operationName, parameters, source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        return this.processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2, String argumentName3, Object argumentValue3) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        this.addSources(operationName, parameters, source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        Operations.setParameterValue(parameters, argumentName3, argumentValue3);
        return this.processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2, String argumentName3, Object argumentValue3, String argumentName4, Object argumentValue4) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        this.addSources(operationName, parameters, source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        Operations.setParameterValue(parameters, argumentName3, argumentValue3);
        Operations.setParameterValue(parameters, argumentName4, argumentValue4);
        return this.processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2, String argumentName3, Object argumentValue3, String argumentName4, Object argumentValue4, String argumentName5, Object argumentValue5) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        this.addSources(operationName, parameters, source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        Operations.setParameterValue(parameters, argumentName3, argumentValue3);
        Operations.setParameterValue(parameters, argumentName4, argumentValue4);
        Operations.setParameterValue(parameters, argumentName5, argumentValue5);
        return this.processor.doOperation(parameters);
    }

    protected final Coverage doOperation(String operationName, Coverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2, String argumentName3, Object argumentValue3, String argumentName4, Object argumentValue4, String argumentName5, Object argumentValue5, String argumentName6, Object argumentValue6) throws OperationNotFoundException, InvalidParameterNameException, CoverageProcessingException {
        Operation operation = this.processor.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        this.addSources(operationName, parameters, source);
        Operations.setParameterValue(parameters, argumentName1, argumentValue1);
        Operations.setParameterValue(parameters, argumentName2, argumentValue2);
        Operations.setParameterValue(parameters, argumentName3, argumentValue3);
        Operations.setParameterValue(parameters, argumentName4, argumentValue4);
        Operations.setParameterValue(parameters, argumentName5, argumentValue5);
        Operations.setParameterValue(parameters, argumentName6, argumentValue6);
        return this.processor.doOperation(parameters);
    }

    private void addSources(String operationName, ParameterValueGroup parameters, Coverage ... sources) {
        if (JAIExt.getOperationName(operationName).equalsIgnoreCase("algebric")) {
            ArrayList<Coverage> sourceList = new ArrayList<Coverage>();
            sourceList.addAll(Arrays.asList(sources));
            parameters.parameter("Sources").setValue(sourceList);
        } else if (sources.length == 1) {
            parameters.parameter("Source").setValue(sources[0]);
        } else {
            for (int i = 0; i < sources.length; ++i) {
                parameters.parameter("Source" + i).setValue(sources[i]);
            }
        }
    }

    private static void setParameterValue(ParameterValueGroup parameters, String name, Object value) throws InvalidParameterNameException {
        if (value != null) {
            try {
                parameters.parameter(name).setValue(value);
            }
            catch (ParameterNotFoundException cause) {
                InvalidParameterNameException exception = new InvalidParameterNameException(Errors.format(185, name), name);
                exception.initCause(cause);
                throw exception;
            }
        }
    }
}

