/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import javax.measure.unit.NonSI;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.MatrixParameterDescriptors;
import org.geotools.parameter.MatrixParameters;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.SingularMatrixException;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.operation.transform.ProjectiveTransform2D;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public class ProjectiveTransform
extends AbstractMathTransform
implements LinearTransform,
Serializable {
    private static final long serialVersionUID = -2104496465933824935L;
    private final int numRow;
    private final int numCol;
    private final double[] elt;
    private transient ProjectiveTransform inverse;

    protected ProjectiveTransform(Matrix matrix) {
        this.numRow = matrix.getNumRow();
        this.numCol = matrix.getNumCol();
        this.elt = new double[this.numRow * this.numCol];
        int index = 0;
        for (int j = 0; j < this.numRow; ++j) {
            for (int i = 0; i < this.numCol; ++i) {
                this.elt[index++] = matrix.getElement(j, i);
            }
        }
    }

    public static LinearTransform create(Matrix matrix) {
        int dimension = matrix.getNumRow() - 1;
        if (dimension == matrix.getNumCol() - 1) {
            if (matrix.isIdentity()) {
                return IdentityTransform.create(dimension);
            }
            GeneralMatrix m = ProjectiveTransform.toGMatrix(matrix);
            if (m.isAffine()) {
                switch (dimension) {
                    case 1: {
                        return LinearTransform1D.create(m.getElement(0, 0), m.getElement(0, 1));
                    }
                    case 2: {
                        return ProjectiveTransform.create(m.toAffineTransform2D());
                    }
                }
            }
        }
        switch (dimension) {
            case 2: {
                return new ProjectiveTransform2D(matrix);
            }
        }
        return new ProjectiveTransform(matrix);
    }

    public static LinearTransform create(AffineTransform matrix) {
        if (matrix.isIdentity()) {
            return IdentityTransform.create(2);
        }
        return new AffineTransform2D(matrix);
    }

    public static LinearTransform createScale(int dimension, double scale) {
        if (scale == 1.0) {
            return IdentityTransform.create(dimension);
        }
        GeneralMatrix matrix = new GeneralMatrix(dimension + 1);
        for (int i = 0; i < dimension; ++i) {
            matrix.setElement(i, i, scale);
        }
        return ProjectiveTransform.create(matrix);
    }

    public static LinearTransform createTranslation(int dimension, double offset) {
        if (offset == 0.0) {
            return IdentityTransform.create(dimension);
        }
        GeneralMatrix matrix = new GeneralMatrix(dimension + 1);
        for (int i = 0; i < dimension; ++i) {
            matrix.setElement(i, dimension, offset);
        }
        return ProjectiveTransform.create(matrix);
    }

    public static Matrix createSelectMatrix(int sourceDim, int[] toKeep) throws IndexOutOfBoundsException {
        int targetDim = toKeep.length;
        XMatrix matrix = MatrixFactory.create(targetDim + 1, sourceDim + 1);
        matrix.setZero();
        for (int j = 0; j < targetDim; ++j) {
            matrix.setElement(j, toKeep[j], 1.0);
        }
        matrix.setElement(targetDim, sourceDim, 1.0);
        return matrix;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return ProviderAffine.PARAMETERS;
    }

    static ParameterValueGroup getParameterValues(Matrix matrix) {
        MatrixParameters values = (MatrixParameters)ProviderAffine.PARAMETERS.createValue();
        values.setMatrix(matrix);
        return values;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int upperSrc;
        int inputDimension = this.numCol - 1;
        int outputDimension = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        if (srcPts == dstPts && (upperSrc = srcOff + numPts * inputDimension) > dstOff && (inputDimension >= outputDimension ? dstOff > srcOff : dstOff + numPts * outputDimension > upperSrc)) {
            srcPts = new float[numPts * inputDimension];
            System.arraycopy(dstPts, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + inputDimension];
                for (int i = 0; i < inputDimension; ++i) {
                    sum += (double)srcPts[srcOff + i] * this.elt[mix++];
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[outputDimension];
            for (int j = 0; j < outputDimension; ++j) {
                dstPts[dstOff++] = (float)(buffer[j] / w);
            }
            srcOff += inputDimension;
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int upperSrc;
        int inputDimension = this.numCol - 1;
        int outputDimension = this.numRow - 1;
        double[] buffer = new double[this.numRow];
        if (srcPts == dstPts && (upperSrc = srcOff + numPts * inputDimension) > dstOff && (inputDimension >= outputDimension ? dstOff > srcOff : dstOff + numPts * outputDimension > upperSrc)) {
            srcPts = new double[numPts * inputDimension];
            System.arraycopy(dstPts, srcOff, srcPts, 0, srcPts.length);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            int mix = 0;
            for (int j = 0; j < this.numRow; ++j) {
                double sum = this.elt[mix + inputDimension];
                for (int i = 0; i < inputDimension; ++i) {
                    sum += srcPts[srcOff + i] * this.elt[mix++];
                }
                buffer[j] = sum;
                ++mix;
            }
            double w = buffer[outputDimension];
            for (int j = 0; j < outputDimension; ++j) {
                dstPts[dstOff++] = buffer[j] / w;
            }
            srcOff += inputDimension;
        }
    }

    @Override
    public Matrix derivative(Point2D point) {
        return this.derivative((DirectPosition)null);
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        GeneralMatrix matrix = this.getGeneralMatrix();
        matrix.setSize(this.numRow - 1, this.numCol - 1);
        return matrix;
    }

    @Override
    public Matrix getMatrix() {
        return this.getGeneralMatrix();
    }

    private GeneralMatrix getGeneralMatrix() {
        return new GeneralMatrix(this.numRow, this.numCol, this.elt);
    }

    @Override
    public int getSourceDimensions() {
        return this.numCol - 1;
    }

    @Override
    public int getTargetDimensions() {
        return this.numRow - 1;
    }

    @Override
    public boolean isIdentity() {
        if (this.numRow != this.numCol) {
            return false;
        }
        int index = 0;
        for (int j = 0; j < this.numRow; ++j) {
            for (int i = 0; i < this.numCol; ++i) {
                if (this.elt[index++] == (double)(i == j ? 1 : 0)) continue;
                return false;
            }
        }
        assert (this.isIdentity(0.0));
        return true;
    }

    @Override
    public boolean isIdentity(double tolerance) {
        tolerance = Math.abs(tolerance);
        if (this.numRow != this.numCol) {
            return false;
        }
        int index = 0;
        for (int j = 0; j < this.numRow; ++j) {
            for (int i = 0; i < this.numCol; ++i) {
                double e = this.elt[index++];
                if (i == j) {
                    e -= 1.0;
                }
                if (Math.abs(e) <= tolerance) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else {
                GeneralMatrix matrix = this.getGeneralMatrix();
                try {
                    matrix.invert();
                }
                catch (IllegalArgumentException | SingularMatrixException exception) {
                    throw new NoninvertibleTransformException(Errors.format(105), (Throwable)exception);
                }
                this.inverse = this.createInverse(matrix);
                this.inverse.inverse = this;
            }
        }
        return this.inverse;
    }

    ProjectiveTransform createInverse(Matrix matrix) {
        return new ProjectiveTransform(matrix);
    }

    @Override
    public int hashCode() {
        long code = -2104496465933824935L;
        int i = this.elt.length;
        while (--i >= 0) {
            code = code * 37L + Double.doubleToLongBits(this.elt[i]);
        }
        return (int)(code >>> 32) ^ (int)code;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ProjectiveTransform that = (ProjectiveTransform)object;
            return this.numRow == that.numRow && this.numCol == that.numCol && Arrays.equals(this.elt, that.elt);
        }
        return false;
    }

    public static final class ProviderLongitudeRotation
    extends MathTransformProvider {
        private static final long serialVersionUID = -2104496465933824935L;
        public static final ParameterDescriptor OFFSET = ProviderLongitudeRotation.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Longitude offset")}, Double.NaN, -180.0, 180.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = ProviderLongitudeRotation.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Longitude rotation"), new NamedIdentifier(Citations.EPSG, "9601")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{OFFSET});

        public ProviderLongitudeRotation() {
            super(2, 2, PARAMETERS);
        }

        public Class<Conversion> getOperationType() {
            return Conversion.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            double offset = ProviderLongitudeRotation.doubleValue(OFFSET, values);
            return ProjectiveTransform.create(AffineTransform.getTranslateInstance(offset, 0.0));
        }
    }

    public static final class ProviderAffine
    extends MathTransformProvider {
        private static final long serialVersionUID = 649555815622129472L;
        private static final ProviderAffine[] methods = new ProviderAffine[8];
        static final ParameterDescriptorGroup PARAMETERS;

        public ProviderAffine() {
            this(2, 2);
            ProviderAffine.methods[1] = this;
        }

        private ProviderAffine(int sourceDimensions, int targetDimensions) {
            super(sourceDimensions, targetDimensions, PARAMETERS);
        }

        public Class<Conversion> getOperationType() {
            return Conversion.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            LinearTransform transform = ProjectiveTransform.create(((MatrixParameterDescriptors)this.getParameters()).getMatrix(values));
            return new MathTransformProvider.Delegate(transform, ProviderAffine.getProvider(transform.getSourceDimensions(), transform.getTargetDimensions()));
        }

        public static ProviderAffine getProvider(int sourceDimensions, int targetDimensions) {
            int i;
            if (sourceDimensions == targetDimensions && (i = sourceDimensions - 1) >= 0 && i < methods.length) {
                ProviderAffine method = methods[i];
                if (method == null) {
                    ProviderAffine.methods[i] = method = new ProviderAffine(sourceDimensions, targetDimensions);
                }
                return method;
            }
            return new ProviderAffine(sourceDimensions, targetDimensions);
        }

        static {
            NamedIdentifier name = new NamedIdentifier(Citations.OGC, "Affine");
            HashMap<String, Object> properties = new HashMap<String, Object>(4, 0.8f);
            properties.put("name", name);
            properties.put("identifiers", name);
            properties.put("alias", new NamedIdentifier[]{name, new NamedIdentifier(Citations.EPSG, "Affine general parametric transformation"), new NamedIdentifier(Citations.EPSG, "9624"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(2))});
            PARAMETERS = new MatrixParameterDescriptors(properties);
        }
    }
}

