/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Locale;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public abstract class OdUtils {
    private static final String TEMP_DIR_PREFIX = "josm_opendata_temp_";

    public static final boolean isMultipolygon(OsmPrimitive p) {
        return p instanceof Relation && ((Relation)p).isMultipolygon();
    }

    public static final String[] stripQuotesAndExtraChars(String[] split, String sep) {
        ArrayList<String> result = new ArrayList<String>();
        boolean append = false;
        for (int i = 0; i < split.length; ++i) {
            if (append) {
                int index = result.size() - 1;
                if (split[i].endsWith("\"") && StringUtils.countMatches((CharSequence)split[i], (CharSequence)"\"") % 2 == 1) {
                    append = false;
                }
                result.set(index, (String)result.get(index) + sep + split[i].replaceAll("\"", ""));
                continue;
            }
            if (split[i].startsWith("\"")) {
                if (!split[i].endsWith("\"") || StringUtils.countMatches((CharSequence)split[i], (CharSequence)"\"") % 2 != 0) {
                    append = true;
                }
                result.add(split[i].replaceAll("\"", ""));
                continue;
            }
            result.add(split[i]);
        }
        ListIterator<String> it = result.listIterator();
        while (it.hasNext()) {
            it.set(Utils.strip((String)((String)it.next())));
        }
        return result.toArray(new String[0]);
    }

    public static final ImageIcon getImageIcon(String iconName) {
        return OdUtils.getImageIcon(iconName, false);
    }

    public static final ImageIcon getImageIcon(String iconName, boolean optional) {
        return OdUtils.getImageProvider(iconName, optional).get();
    }

    public static final ImageProvider getImageProvider(String iconName) {
        return OdUtils.getImageProvider(iconName, false);
    }

    public static final ImageProvider getImageProvider(String iconName, boolean optional) {
        return new ImageProvider(iconName).setOptional(optional).setAdditionalClassLoaders(ModuleHandler.getResourceClassLoaders());
    }

    public static final String getJosmLanguage() {
        String lang = Main.pref.get("language");
        if (lang == null || lang.isEmpty()) {
            lang = Locale.getDefault().toString();
        }
        return lang;
    }

    public static final double convertMinuteSecond(double minute, double second) {
        return minute / 60.0 + second / 3600.0;
    }

    public static final double convertDegreeMinuteSecond(double degree, double minute, double second) {
        return degree + OdUtils.convertMinuteSecond(minute, second);
    }

    public static final File createTempDir() throws IOException {
        return Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]).toFile();
    }

    public static final void deleteDir(File dir) {
        for (File file : dir.listFiles()) {
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        if (!dir.delete()) {
            dir.deleteOnExit();
        }
    }

    public static final void deletePreviousTempDirs() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (tmpDir.exists() && tmpDir.isDirectory()) {
            for (File dir : tmpDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(OdUtils.TEMP_DIR_PREFIX);
                }
            })) {
                OdUtils.deleteDir(dir);
            }
        }
    }
}

