/*
 * Decompiled with CFR 0.152.
 */
package s57;

import java.io.FileInputStream;
import java.io.IOException;
import s57.S57dat;
import s57.S57map;

public class S57dec {
    public static void decodeChart(FileInputStream in, S57map map) throws IOException {
        S57dat.rnum = 0;
        byte[] leader = new byte[24];
        byte[] record = new byte[]{};
        boolean ddr = false;
        int length = 0;
        int fields = 0;
        boolean inFeature = false;
        double comf = 1.0;
        double somf = 1.0;
        long name = 0L;
        S57map.Nflag nflag = S57map.Nflag.ANON;
        S57map.Pflag pflag = S57map.Pflag.NOSP;
        long objl = 0L;
        while (in.read(leader) == 24) {
            try {
                length = Integer.parseInt(new String(leader, 0, 5)) - 24;
                record = new byte[length];
                ddr = leader[6] == 76;
                fields = Integer.parseInt(new String(leader, 12, 5)) - 24;
            }
            catch (Exception e) {
                System.err.println("Invalid file format - Encrypted/compressed ENC file?");
                System.exit(-1);
            }
            int mapfl = leader[20] - 48;
            int mapfp = leader[21] - 48;
            int mapts = leader[23] - 48;
            int entry = mapfl + mapfp + mapts;
            if (in.read(record) != length) break;
            for (int idx = 0; idx < fields - 1; idx += entry) {
                String tag = new String(record, idx, mapts);
                int len = Integer.parseInt(new String(record, idx + mapts, mapfl));
                int pos = Integer.parseInt(new String(record, idx + mapts + mapfl, mapfp));
                if (!ddr) {
                    switch (tag.toString()) {
                        case "0001": {
                            int i8rn = ((Long)S57dat.decSubf(record, fields + pos, S57dat.S57field.I8RI, S57dat.S57subf.I8RN)).intValue();
                            break;
                        }
                        case "DSSI": {
                            S57dat.decSubf(record, fields + pos, S57dat.S57field.DSSI, S57dat.S57subf.AALL);
                            S57dat.decSubf(S57dat.S57subf.NALL);
                            break;
                        }
                        case "DSPM": {
                            comf = ((Long)S57dat.decSubf(record, fields + pos, S57dat.S57field.DSPM, S57dat.S57subf.COMF)).longValue();
                            somf = ((Long)S57dat.decSubf(S57dat.S57subf.SOMF)).longValue();
                            break;
                        }
                        case "FRID": {
                            inFeature = true;
                            switch (((Long)S57dat.decSubf(record, fields + pos, S57dat.S57field.FRID, S57dat.S57subf.PRIM)).intValue()) {
                                case 1: {
                                    pflag = S57map.Pflag.POINT;
                                    break;
                                }
                                case 2: {
                                    pflag = S57map.Pflag.LINE;
                                    break;
                                }
                                case 3: {
                                    pflag = S57map.Pflag.AREA;
                                    break;
                                }
                                default: {
                                    pflag = S57map.Pflag.NOSP;
                                }
                            }
                            objl = (Long)S57dat.decSubf(S57dat.S57subf.OBJL);
                            break;
                        }
                        case "FOID": {
                            name = (Long)S57dat.decSubf(record, fields + pos, S57dat.S57field.LNAM, S57dat.S57subf.LNAM);
                            map.newFeature(name, pflag, objl);
                            break;
                        }
                        case "ATTF": {
                            S57dat.setField(record, fields + pos, S57dat.S57field.ATTF, len);
                            do {
                                long attl = (Long)S57dat.decSubf(S57dat.S57subf.ATTL);
                                String atvl = ((String)S57dat.decSubf(S57dat.S57subf.ATVL)).trim();
                                if (atvl.isEmpty()) continue;
                                map.newAtt(attl, atvl);
                            } while (S57dat.more());
                            break;
                        }
                        case "FFPT": {
                            S57dat.setField(record, fields + pos, S57dat.S57field.FFPT, len);
                            do {
                                name = (Long)S57dat.decSubf(S57dat.S57subf.LNAM);
                                int rind = ((Long)S57dat.decSubf(S57dat.S57subf.RIND)).intValue();
                                S57dat.decSubf(S57dat.S57subf.COMT);
                                map.refObj(name, rind);
                            } while (S57dat.more());
                            break;
                        }
                        case "FSPT": {
                            S57dat.setField(record, fields + pos, S57dat.S57field.FSPT, len);
                            do {
                                name = (Long)S57dat.decSubf(S57dat.S57subf.NAME) << 16;
                                map.newPrim(name, (Long)S57dat.decSubf(S57dat.S57subf.ORNT), (Long)S57dat.decSubf(S57dat.S57subf.USAG));
                                S57dat.decSubf(S57dat.S57subf.MASK);
                            } while (S57dat.more());
                            break;
                        }
                        case "VRID": {
                            inFeature = false;
                            name = (Long)S57dat.decSubf(record, fields + pos, S57dat.S57field.VRID, S57dat.S57subf.RCNM);
                            switch ((int)name) {
                                case 110: {
                                    nflag = S57map.Nflag.ISOL;
                                    break;
                                }
                                case 120: {
                                    nflag = S57map.Nflag.CONN;
                                    break;
                                }
                                default: {
                                    nflag = S57map.Nflag.ANON;
                                }
                            }
                            name <<= 32;
                            name += ((Long)S57dat.decSubf(S57dat.S57subf.RCID)).longValue();
                            name <<= 16;
                            if (nflag != S57map.Nflag.ANON) break;
                            map.newEdge(name);
                            break;
                        }
                        case "VRPT": {
                            S57dat.setField(record, fields + pos, S57dat.S57field.VRPT, len);
                            do {
                                long conn = (Long)S57dat.decSubf(S57dat.S57subf.NAME) << 16;
                                int topi = ((Long)S57dat.decSubf(S57dat.S57subf.TOPI)).intValue();
                                map.addConn(conn, topi);
                                S57dat.decSubf(S57dat.S57subf.MASK);
                            } while (S57dat.more());
                            break;
                        }
                        case "SG2D": {
                            S57dat.setField(record, fields + pos, S57dat.S57field.SG2D, len);
                            do {
                                double lat = (double)((Long)S57dat.decSubf(S57dat.S57subf.YCOO)).longValue() / comf;
                                double lon = (double)((Long)S57dat.decSubf(S57dat.S57subf.XCOO)).longValue() / comf;
                                if (nflag == S57map.Nflag.ANON) {
                                    map.newNode(++name, lat, lon, nflag);
                                } else {
                                    map.newNode(name, lat, lon, nflag);
                                }
                                lat = Math.toRadians(lat);
                                lon = Math.toRadians(lon);
                                if (lat < map.bounds.minlat) {
                                    map.bounds.minlat = lat;
                                }
                                if (lat > map.bounds.maxlat) {
                                    map.bounds.maxlat = lat;
                                }
                                if (lon < map.bounds.minlon) {
                                    map.bounds.minlon = lon;
                                }
                                if (!(lon > map.bounds.maxlon)) continue;
                                map.bounds.maxlon = lon;
                            } while (S57dat.more());
                            break;
                        }
                        case "SG3D": {
                            S57dat.setField(record, fields + pos, S57dat.S57field.SG3D, len);
                            do {
                                double lat = (double)((Long)S57dat.decSubf(S57dat.S57subf.YCOO)).longValue() / comf;
                                double lon = (double)((Long)S57dat.decSubf(S57dat.S57subf.XCOO)).longValue() / comf;
                                double depth = (double)((Long)S57dat.decSubf(S57dat.S57subf.VE3D)).longValue() / somf;
                                map.newNode(name++, lat, lon, depth);
                                lat = Math.toRadians(lat);
                                lon = Math.toRadians(lon);
                                if (lat < map.bounds.minlat) {
                                    map.bounds.minlat = lat;
                                }
                                if (lat > map.bounds.maxlat) {
                                    map.bounds.maxlat = lat;
                                }
                                if (lon < map.bounds.minlon) {
                                    map.bounds.minlon = lon;
                                }
                                if (!(lon > map.bounds.maxlon)) continue;
                                map.bounds.maxlon = lon;
                            } while (S57dat.more());
                            break;
                        }
                    }
                }
                if (!inFeature) continue;
                map.endFeature();
                inFeature = false;
            }
        }
        map.endFile();
        in.close();
    }
}

