/*
 * Decompiled with CFR 0.152.
 */
package render;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import render.Renderer;
import render.Rules;
import s57.S57att;
import s57.S57map;
import s57.S57obj;
import s57.S57val;
import symbols.Beacons;
import symbols.Symbols;
import symbols.Topmarks;

public class Signals
extends Rules {
    static final EnumMap<S57val.ColCOL, Color> LightColours = new EnumMap(S57val.ColCOL.class);
    static final EnumMap<S57val.ColCOL, String> LightLetters;
    static final EnumMap<S57val.LitCHR, String> LightCharacters;
    static final EnumMap<S57val.CatFOG, String> fogSignals;
    static final DecimalFormat df;

    public static void addSignals() {
        if (Signals.feature.objs.containsKey((Object)S57obj.Obj.RADRFL)) {
            Signals.reflectors();
        }
        if (Signals.feature.objs.containsKey((Object)S57obj.Obj.FOGSIG)) {
            Signals.fogSignals();
        }
        if (Signals.feature.objs.containsKey((Object)S57obj.Obj.RTPBCN)) {
            Signals.radarStations();
        }
        if (Signals.feature.objs.containsKey((Object)S57obj.Obj.RADSTA)) {
            Signals.radarStations();
        }
        if (Signals.feature.objs.containsKey((Object)S57obj.Obj.RDOSTA)) {
            Signals.radioStations();
        }
        if (Signals.feature.objs.containsKey((Object)S57obj.Obj.LIGHTS)) {
            Signals.lights();
        }
    }

    public static void reflectors() {
        if (Renderer.zoom >= 14) {
            switch (Signals.feature.type) {
                case BCNLAT: 
                case BCNCAR: 
                case BCNISD: 
                case BCNSAW: 
                case BCNSPP: {
                    if (Signals.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR) || Signals.feature.objs.containsKey((Object)S57obj.Obj.DAYMAR)) {
                        Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -140.0)));
                        break;
                    }
                    Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -80.0)));
                    break;
                }
                case LITFLT: 
                case LITVES: 
                case BOYINB: {
                    if (Signals.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR) || Signals.feature.objs.containsKey((Object)S57obj.Obj.DAYMAR)) {
                        Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -110.0)));
                        break;
                    }
                    Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -60.0)));
                    break;
                }
                case LITMAJ: 
                case LITMIN: {
                    if (Signals.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR) || Signals.feature.objs.containsKey((Object)S57obj.Obj.DAYMAR)) {
                        Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -90.0)));
                        break;
                    }
                    Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -30.0)));
                    break;
                }
                case BOYLAT: 
                case BOYCAR: 
                case BOYISD: 
                case BOYSAW: 
                case BOYSPP: {
                    if (Signals.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR) || Signals.feature.objs.containsKey((Object)S57obj.Obj.DAYMAR)) {
                        if (Signals.testAttribute(Signals.feature.type, S57att.Att.BOYSHP, (Object)S57val.BoySHP.BOY_PILR) || Signals.testAttribute(Signals.feature.type, S57att.Att.BOYSHP, (Object)S57val.BoySHP.BOY_SPAR)) {
                            Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(50.0, -160.0)));
                            break;
                        }
                        Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(25.0, -80.0)));
                        break;
                    }
                    if (Signals.testAttribute(Signals.feature.type, S57att.Att.BOYSHP, (Object)S57val.BoySHP.BOY_PILR) || Signals.testAttribute(Signals.feature.type, S57att.Att.BOYSHP, (Object)S57val.BoySHP.BOY_SPAR)) {
                        Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(30.0, -100.0)));
                        break;
                    }
                    Renderer.symbol(Topmarks.RadarReflector, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(10.0, -50.0)));
                    break;
                }
            }
        }
    }

    public static void fogSignals() {
        S57map.AttMap atts;
        if (Renderer.zoom >= 11) {
            Renderer.symbol(Beacons.FogSignal);
        }
        if (Renderer.zoom >= 15 && (atts = (S57map.AttMap)((S57map.ObjTab)Signals.feature.objs.get((Object)S57obj.Obj.FOGSIG)).get(0)) != null) {
            String str = "";
            if (atts.containsKey((Object)S57att.Att.CATFOG)) {
                str = str + fogSignals.get(((ArrayList)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.CATFOG))).val).get(0));
            }
            str = atts.containsKey((Object)S57att.Att.SIGGRP) ? str + "(" + ((S57val.AttVal)atts.get((Object)((Object)S57att.Att.SIGGRP))).val + ")" : str + " ";
            if (atts.containsKey((Object)S57att.Att.SIGPER)) {
                str = str + df.format(((S57val.AttVal)atts.get((Object)((Object)S57att.Att.SIGPER))).val) + "s";
            }
            if (atts.containsKey((Object)S57att.Att.VALMXR)) {
                str = str + df.format(((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VALMXR))).val) + "M";
            }
            if (!str.isEmpty()) {
                Renderer.labelText(str, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-60.0, -30.0)));
            }
        }
    }

    public static void radarStations() {
        if (Renderer.zoom >= 11) {
            Renderer.symbol(Beacons.RadarStation);
        }
        if (Renderer.zoom >= 15) {
            String bstr = "";
            S57val.CatRTB cat = (S57val.CatRTB)Signals.getAttEnum(S57obj.Obj.RTPBCN, S57att.Att.CATRTB);
            String wal = Signals.getAttStr(S57obj.Obj.RTPBCN, S57att.Att.RADWAL);
            switch (cat) {
                case RTB_RAMK: {
                    bstr = bstr + " Ramark";
                    break;
                }
                case RTB_RACN: {
                    bstr = bstr + " Racon";
                    String astr = Signals.getAttStr(S57obj.Obj.RTPBCN, S57att.Att.SIGGRP);
                    if (!astr.isEmpty()) {
                        bstr = bstr + "(" + astr + ")";
                    }
                    Double per = (Double)Signals.getAttVal(S57obj.Obj.RTPBCN, S57att.Att.SIGPER);
                    Double mxr = (Double)Signals.getAttVal(S57obj.Obj.RTPBCN, S57att.Att.VALMXR);
                    if (per == null && mxr == null) break;
                    bstr = bstr + (astr.isEmpty() ? " " : "");
                    if (per != null) {
                        bstr = bstr + (per != 0.0 ? per.toString() + "s" : "");
                    }
                    if (mxr == null) break;
                    bstr = bstr + (mxr != 0.0 ? mxr.toString() + "M" : "");
                    break;
                }
            }
            if (!wal.isEmpty()) {
                switch (wal) {
                    case "0.03-X": {
                        bstr = bstr + "(3cm)";
                        break;
                    }
                    case "0.10-S": {
                        bstr = bstr + "(10cm)";
                    }
                }
            }
            if (!bstr.isEmpty()) {
                Renderer.labelText(bstr, new Font("Arial", 0, 40), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-30.0, -70.0)));
            }
        }
    }

    public static void radioStations() {
        boolean vais = false;
        String bstr = "";
        if (Renderer.zoom >= 11) {
            ArrayList<S57val.CatROS> cats = Signals.getAttList(S57obj.Obj.RDOSTA, S57att.Att.CATROS);
            for (S57val.CatROS ros : cats) {
                switch (ros) {
                    case ROS_OMNI: {
                        bstr = bstr + " RC";
                        break;
                    }
                    case ROS_DIRL: {
                        bstr = bstr + " RD";
                        break;
                    }
                    case ROS_ROTP: {
                        bstr = bstr + " RW";
                        break;
                    }
                    case ROS_CNSL: {
                        bstr = bstr + " Consol";
                        break;
                    }
                    case ROS_RDF: {
                        bstr = bstr + " RG";
                        break;
                    }
                    case ROS_QTA: {
                        bstr = bstr + " R";
                        break;
                    }
                    case ROS_AERO: {
                        bstr = bstr + " AeroRC";
                        break;
                    }
                    case ROS_DECA: {
                        bstr = bstr + " Decca";
                        break;
                    }
                    case ROS_LORN: {
                        bstr = bstr + " Loran";
                        break;
                    }
                    case ROS_DGPS: {
                        bstr = bstr + " DGPS";
                        break;
                    }
                    case ROS_TORN: {
                        bstr = bstr + " Toran";
                        break;
                    }
                    case ROS_OMGA: {
                        bstr = bstr + " Omega";
                        break;
                    }
                    case ROS_SYLD: {
                        bstr = bstr + " Syledis";
                        break;
                    }
                    case ROS_CHKA: {
                        bstr = bstr + " Chiaka";
                        break;
                    }
                    case ROS_PCOM: 
                    case ROS_COMB: 
                    case ROS_FACS: 
                    case ROS_TIME: {
                        break;
                    }
                    case ROS_PAIS: 
                    case ROS_SAIS: {
                        bstr = bstr + " AIS";
                        break;
                    }
                    case ROS_VAIS: {
                        vais = true;
                        break;
                    }
                    case ROS_VANC: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopNorth, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case ROS_VASC: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopSouth, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case ROS_VAEC: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopEast, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case ROS_VAWC: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopWest, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case ROS_VAPL: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopCan, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case ROS_VASL: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopCone, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case ROS_VAID: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopIsol, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case ROS_VASW: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopSphere, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case ROS_VASP: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopX, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case ROS_VAWK: {
                        vais = true;
                        Renderer.symbol(Topmarks.TopCross, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                }
            }
            if (!vais) {
                Renderer.symbol(Beacons.RadarStation);
            }
        }
        if (Renderer.zoom >= 15) {
            if (vais) {
                Renderer.labelText("V-AIS", new Font("Arial", 0, 40), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, 70.0)));
            }
            if (!bstr.isEmpty()) {
                Renderer.labelText(bstr, new Font("Arial", 0, 40), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-30.0, -110.0)));
            }
        }
    }

    public static void lights() {
        Enum col = null;
        Enum tcol = null;
        S57map.ObjTab lights = (S57map.ObjTab)Signals.feature.objs.get((Object)S57obj.Obj.LIGHTS);
        for (Object atts : lights.values()) {
            if (!((HashMap)atts).containsKey((Object)S57att.Att.COLOUR)) continue;
            ArrayList cols = (ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.COLOUR))).val;
            if (cols.size() == 1) {
                tcol = (Enum)cols.get(0);
                if (col == null) {
                    col = tcol;
                    continue;
                }
                if (tcol == col) continue;
                col = S57val.ColCOL.COL_MAG;
                break;
            }
            col = S57val.ColCOL.COL_MAG;
            break;
        }
        Renderer.symbol(Beacons.LightFlare, new Symbols.Scheme(LightColours.get(col)), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getRotateInstance(Math.toRadians(120.0))));
        if (Renderer.zoom >= 12) {
            String str = "";
            if (lights.get(1) != null) {
                for (Object atts : lights.values()) {
                    ArrayList cats;
                    Enum col1 = null;
                    Enum col2 = null;
                    double radius = 0.2;
                    double s1 = 361.0;
                    double s2 = 361.0;
                    Double dir = null;
                    if (!((HashMap)atts).containsKey((Object)S57att.Att.COLOUR)) continue;
                    ArrayList cols = (ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.COLOUR))).val;
                    col1 = (Enum)cols.get(0);
                    if (cols.size() > 1) {
                        col2 = (Enum)cols.get(1);
                    }
                    if (((HashMap)atts).containsKey((Object)S57att.Att.LITRAD)) {
                        radius = (Double)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.LITRAD))).val;
                    }
                    if (((HashMap)atts).containsKey((Object)S57att.Att.CATLIT) && (cats = (ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.CATLIT))).val).contains((Object)S57val.CatLIT.LIT_DIR) && ((HashMap)atts).containsKey((Object)S57att.Att.ORIENT)) {
                        dir = (Double)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.ORIENT))).val;
                        s1 = (dir - 4.0 + 360.0) % 360.0;
                        s2 = (dir + 4.0) % 360.0;
                        for (S57map.AttMap satts : lights.values()) {
                            ArrayList scats;
                            double srad = 0.2;
                            double ss1 = 361.0;
                            double ss2 = 361.0;
                            Double sdir = null;
                            if (satts == atts) continue;
                            if (satts.containsKey((Object)S57att.Att.LITRAD)) {
                                srad = (Double)((S57val.AttVal)satts.get((Object)((Object)S57att.Att.LITRAD))).val;
                            }
                            if (srad != radius) continue;
                            ArrayList arrayList = scats = satts.containsKey((Object)S57att.Att.CATLIT) ? (ArrayList)((S57val.AttVal)satts.get((Object)((Object)S57att.Att.CATLIT))).val : new ArrayList();
                            if (scats.contains((Object)S57val.CatLIT.LIT_DIR)) {
                                if (satts.containsKey((Object)S57att.Att.ORIENT)) {
                                    sdir = (Double)((S57val.AttVal)satts.get((Object)((Object)S57att.Att.ORIENT))).val;
                                    ss1 = sdir;
                                    ss2 = sdir;
                                }
                            } else {
                                if (satts.containsKey((Object)S57att.Att.SECTR1)) {
                                    ss1 = (Double)((S57val.AttVal)satts.get((Object)((Object)S57att.Att.SECTR1))).val;
                                }
                                if (satts.containsKey((Object)S57att.Att.SECTR2)) {
                                    ss2 = (Double)((S57val.AttVal)satts.get((Object)((Object)S57att.Att.SECTR2))).val;
                                }
                            }
                            if (ss1 > 360.0 || ss2 > 360.0) continue;
                            if (sdir != null) {
                                if ((dir - sdir + 360.0) % 360.0 < 8.0) {
                                    s1 = ((double)(sdir > dir ? 360 : 0) + sdir + dir) / 2.0 % 360.0;
                                }
                                if (!((sdir - dir + 360.0) % 360.0 < 8.0)) continue;
                                s2 = ((double)(dir > sdir ? 360 : 0) + sdir + dir) / 2.0 % 360.0;
                                continue;
                            }
                            if ((dir - ss2 + 360.0) % 360.0 < 4.0) {
                                s1 = ss2;
                            }
                            if (!((ss1 - dir + 360.0) % 360.0 < 4.0)) continue;
                            s2 = ss1;
                        }
                    }
                    if (s1 > 360.0 && ((HashMap)atts).containsKey((Object)S57att.Att.SECTR1)) {
                        s1 = (Double)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.SECTR1))).val;
                    } else if (dir == null) continue;
                    if (s2 > 360.0 && ((HashMap)atts).containsKey((Object)S57att.Att.SECTR2)) {
                        s2 = (Double)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.SECTR2))).val;
                    } else if (dir == null) continue;
                    str = "";
                    if (((HashMap)atts).containsKey((Object)S57att.Att.LITCHR)) {
                        str = str + LightCharacters.get(((ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.LITCHR))).val).get(0));
                    }
                    if (((HashMap)atts).containsKey((Object)S57att.Att.SIGGRP)) {
                        str = str + "(" + ((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.SIGGRP))).val + ")";
                    } else if (!str.isEmpty()) {
                        str = str + ".";
                    }
                    if (((HashMap)atts).containsKey((Object)S57att.Att.COLOUR)) {
                        cols = (ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.COLOUR))).val;
                        str = str + LightLetters.get(cols.get(0));
                        if (cols.size() > 1) {
                            str = str + LightLetters.get(cols.get(1));
                        }
                    }
                    if (((HashMap)atts).containsKey((Object)S57att.Att.SIGPER)) {
                        str = str + "." + df.format(((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.SIGPER))).val) + "s";
                    }
                    if (!(s1 <= 360.0) || !(s2 <= 360.0) || s1 == s2) continue;
                    Renderer.lightSector(LightColours.get(col1), LightColours.get(col2), radius, s1, s2, dir, Renderer.zoom >= 15 ? str : "");
                }
                if (Renderer.zoom >= 15) {
                    class LitSect {
                        boolean dir;
                        S57val.LitCHR chr;
                        S57val.ColCOL col;
                        String grp;
                        double per;
                        double rng;
                        double hgt;

                        LitSect() {
                        }
                    }
                    ArrayList<LitSect> litatts = new ArrayList<LitSect>();
                    for (Object atts : lights.values()) {
                        LitSect sect = new LitSect();
                        sect.dir = ((HashMap)atts).containsKey((Object)S57att.Att.CATLIT) && ((ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.CATLIT))).val).contains((Object)S57val.CatLIT.LIT_DIR);
                        sect.chr = ((HashMap)atts).containsKey((Object)S57att.Att.LITCHR) ? (S57val.LitCHR)((Object)((ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.LITCHR))).val).get(0)) : S57val.LitCHR.CHR_UNKN;
                        switch (sect.chr) {
                            case CHR_AL: {
                                sect.chr = S57val.LitCHR.CHR_F;
                                break;
                            }
                            case CHR_ALOC: {
                                sect.chr = S57val.LitCHR.CHR_OC;
                                break;
                            }
                            case CHR_ALLFL: {
                                sect.chr = S57val.LitCHR.CHR_LFL;
                                break;
                            }
                            case CHR_ALFL: {
                                sect.chr = S57val.LitCHR.CHR_FL;
                                break;
                            }
                            case CHR_ALFFL: {
                                sect.chr = S57val.LitCHR.CHR_FFL;
                                break;
                            }
                        }
                        sect.grp = ((HashMap)atts).containsKey((Object)S57att.Att.SIGGRP) ? (String)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.SIGGRP))).val : "";
                        sect.per = ((HashMap)atts).containsKey((Object)S57att.Att.SIGPER) ? (Double)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.SIGPER))).val : 0.0;
                        sect.rng = ((HashMap)atts).containsKey((Object)S57att.Att.VALNMR) ? (Double)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.VALNMR))).val : 0.0;
                        sect.hgt = ((HashMap)atts).containsKey((Object)S57att.Att.HEIGHT) ? (Double)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.HEIGHT))).val : 0.0;
                        ArrayList cols = ((HashMap)atts).containsKey((Object)S57att.Att.COLOUR) ? ((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.COLOUR))).val : new ArrayList();
                        S57val.ColCOL colCOL = sect.col = cols.size() > 0 ? (S57val.ColCOL)((Object)cols.get(0)) : S57val.ColCOL.COL_UNK;
                        if (sect.chr == S57val.LitCHR.CHR_UNKN || sect.col == null) continue;
                        litatts.add(sect);
                    }
                    ArrayList<ArrayList> groupings = new ArrayList<ArrayList>();
                    for (LitSect lit : litatts) {
                        boolean found = false;
                        for (ArrayList group : groupings) {
                            LitSect mem = (LitSect)group.get(0);
                            if (lit.dir != mem.dir || lit.chr != mem.chr || !lit.grp.equals(mem.grp) || lit.per != mem.per || lit.hgt != mem.hgt) continue;
                            group.add(lit);
                            found = true;
                        }
                        if (found) continue;
                        ArrayList<LitSect> tmp = new ArrayList<LitSect>();
                        tmp.add(lit);
                        groupings.add(tmp);
                    }
                    boolean moved = true;
                    while (moved) {
                        moved = false;
                        for (int i = 0; i < groupings.size() - 1; ++i) {
                            if (((ArrayList)groupings.get(i)).size() >= ((ArrayList)groupings.get(i + 1)).size()) continue;
                            ArrayList tmp = (ArrayList)groupings.remove(i);
                            groupings.add(i + 1, tmp);
                            moved = true;
                        }
                    }
                    int y = -30;
                    for (ArrayList group : groupings) {
                        class ColRng {
                            S57val.ColCOL col;
                            double rng;

                            ColRng(S57val.ColCOL c, double r) {
                                this.col = c;
                                this.rng = r;
                            }
                        }
                        ArrayList<ColRng> colrng = new ArrayList<ColRng>();
                        for (LitSect lit : group) {
                            boolean found = false;
                            for (ColRng cr : colrng) {
                                if (cr.col != lit.col) continue;
                                if (lit.rng > cr.rng) {
                                    cr.rng = lit.rng;
                                }
                                found = true;
                            }
                            if (found) continue;
                            colrng.add(new ColRng(lit.col, lit.rng));
                        }
                        boolean moved2 = true;
                        while (moved2) {
                            moved2 = false;
                            for (int i = 0; i < colrng.size() - 1; ++i) {
                                if (!(((ColRng)colrng.get((int)i)).rng < ((ColRng)colrng.get((int)(i + 1))).rng)) continue;
                                ColRng tmp = (ColRng)colrng.remove(i);
                                colrng.add(i + 1, tmp);
                                moved2 = true;
                            }
                        }
                        LitSect tmp = (LitSect)group.get(0);
                        str = tmp.dir ? "Dir" : "";
                        str = str + LightCharacters.get((Object)tmp.chr);
                        str = !tmp.grp.isEmpty() ? str + "(" + tmp.grp + ")" : str + ".";
                        for (ColRng cr : colrng) {
                            str = str + LightLetters.get((Object)cr.col);
                        }
                        if (tmp.per > 0.0 || tmp.hgt > 0.0 || ((ColRng)colrng.get((int)0)).rng > 0.0) {
                            str = str + ".";
                        }
                        if (tmp.per > 0.0) {
                            str = str + df.format(tmp.per) + "s";
                        }
                        if (tmp.hgt > 0.0) {
                            str = str + df.format(tmp.hgt) + "m";
                        }
                        if (((ColRng)colrng.get((int)0)).rng > 0.0) {
                            str = str + df.format(((ColRng)colrng.get((int)0)).rng) + (colrng.size() > 1 ? (colrng.size() > 2 ? "-" + df.format(((ColRng)colrng.get((int)(colrng.size() - 1))).rng) : "/" + df.format(((ColRng)colrng.get((int)1)).rng)) : "") + "M";
                        }
                        Renderer.labelText(str, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(60.0, y)));
                        y += 40;
                        str = "";
                    }
                }
            } else if (Renderer.zoom >= 15) {
                ArrayList cols;
                Object atts;
                atts = (S57map.AttMap)lights.get(0);
                ArrayList cats = new ArrayList();
                if (((HashMap)atts).containsKey((Object)S57att.Att.CATLIT)) {
                    cats = (ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.CATLIT))).val;
                }
                str = cats.contains((Object)S57val.CatLIT.LIT_DIR) ? "Dir" : "";
                str = str + (((HashMap)atts).containsKey((Object)S57att.Att.MLTYLT) ? ((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.MLTYLT))).val : "");
                if (((HashMap)atts).containsKey((Object)S57att.Att.LITCHR)) {
                    S57val.LitCHR chr = (S57val.LitCHR)((Object)((ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.LITCHR))).val).get(0));
                    if (((HashMap)atts).containsKey((Object)S57att.Att.SIGGRP)) {
                        String grp = (String)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.SIGGRP))).val;
                        switch (chr) {
                            case CHR_QLFL: {
                                str = str + String.format("Q(%s)+LFl", grp);
                                break;
                            }
                            case CHR_VQLFL: {
                                str = str + String.format("VQ(%s)+LFl", grp);
                                break;
                            }
                            case CHR_UQLFL: {
                                str = str + String.format("UQ(%s)+LFl", grp);
                                break;
                            }
                            default: {
                                str = str + String.format("%s(%s)", LightCharacters.get((Object)chr), grp);
                                break;
                            }
                        }
                    } else {
                        str = str + LightCharacters.get((Object)chr);
                    }
                }
                if (((HashMap)atts).containsKey((Object)S57att.Att.COLOUR) && ((cols = (ArrayList)((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.COLOUR))).val).size() != 1 || cols.get(0) != S57val.ColCOL.COL_WHT)) {
                    if (!str.isEmpty() && !str.endsWith(")")) {
                        str = str + ".";
                    }
                    for (S57val.ColCOL acol : cols) {
                        str = str + LightLetters.get((Object)acol);
                    }
                }
                str = str + (cats.contains((Object)S57val.CatLIT.LIT_VERT) ? "(vert)" : "");
                str = str + (cats.contains((Object)S57val.CatLIT.LIT_HORI) ? "(hor)" : "");
                str = str + (!str.isEmpty() && (((HashMap)atts).containsKey((Object)S57att.Att.SIGPER) || ((HashMap)atts).containsKey((Object)S57att.Att.HEIGHT) || ((HashMap)atts).containsKey((Object)S57att.Att.VALMXR)) && !str.endsWith(")") ? "." : "");
                str = str + (((HashMap)atts).containsKey((Object)S57att.Att.SIGPER) ? df.format(((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.SIGPER))).val) + "s" : "");
                str = str + (((HashMap)atts).containsKey((Object)S57att.Att.HEIGHT) ? df.format(((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.HEIGHT))).val) + "m" : "");
                str = str + (((HashMap)atts).containsKey((Object)S57att.Att.VALNMR) ? df.format(((S57val.AttVal)((HashMap)atts).get((Object)((Object)S57att.Att.VALNMR))).val) + "M" : "");
                str = str + (cats.contains((Object)S57val.CatLIT.LIT_FRNT) ? "(Front)" : "");
                str = str + (cats.contains((Object)S57val.CatLIT.LIT_REAR) ? "(Rear)" : "");
                str = str + (cats.contains((Object)S57val.CatLIT.LIT_UPPR) ? "(Upper)" : "");
                str = str + (cats.contains((Object)S57val.CatLIT.LIT_LOWR) ? "(Lower)" : "");
                Renderer.labelText(str, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(60.0, -30.0)));
            }
        }
    }

    static {
        LightColours.put(S57val.ColCOL.COL_WHT, new Color(0xFFFF00));
        LightColours.put(S57val.ColCOL.COL_RED, new Color(0xFF0000));
        LightColours.put(S57val.ColCOL.COL_GRN, new Color(65280));
        LightColours.put(S57val.ColCOL.COL_BLU, new Color(255));
        LightColours.put(S57val.ColCOL.COL_YEL, new Color(0xFFFF00));
        LightColours.put(S57val.ColCOL.COL_AMB, new Color(16761344));
        LightColours.put(S57val.ColCOL.COL_VIO, new Color(0xEE82EE));
        LightColours.put(S57val.ColCOL.COL_ORG, Color.orange);
        LightColours.put(S57val.ColCOL.COL_MAG, Color.magenta);
        LightLetters = new EnumMap(S57val.ColCOL.class);
        LightLetters.put(S57val.ColCOL.COL_WHT, "W");
        LightLetters.put(S57val.ColCOL.COL_RED, "R");
        LightLetters.put(S57val.ColCOL.COL_GRN, "G");
        LightLetters.put(S57val.ColCOL.COL_BLU, "Bu");
        LightLetters.put(S57val.ColCOL.COL_YEL, "Y");
        LightLetters.put(S57val.ColCOL.COL_AMB, "Am");
        LightLetters.put(S57val.ColCOL.COL_VIO, "Vi");
        LightLetters.put(S57val.ColCOL.COL_ORG, "Or");
        LightCharacters = new EnumMap(S57val.LitCHR.class);
        LightCharacters.put(S57val.LitCHR.CHR_F, "F");
        LightCharacters.put(S57val.LitCHR.CHR_FL, "Fl");
        LightCharacters.put(S57val.LitCHR.CHR_LFL, "LFl");
        LightCharacters.put(S57val.LitCHR.CHR_Q, "Q");
        LightCharacters.put(S57val.LitCHR.CHR_VQ, "VQ");
        LightCharacters.put(S57val.LitCHR.CHR_UQ, "UQ");
        LightCharacters.put(S57val.LitCHR.CHR_ISO, "Iso");
        LightCharacters.put(S57val.LitCHR.CHR_OC, "Oc");
        LightCharacters.put(S57val.LitCHR.CHR_IQ, "IQ");
        LightCharacters.put(S57val.LitCHR.CHR_IVQ, "IVQ");
        LightCharacters.put(S57val.LitCHR.CHR_IUQ, "IUQ");
        LightCharacters.put(S57val.LitCHR.CHR_MO, "Mo");
        LightCharacters.put(S57val.LitCHR.CHR_FFL, "FFl");
        LightCharacters.put(S57val.LitCHR.CHR_FLLFL, "FlLFl");
        LightCharacters.put(S57val.LitCHR.CHR_OCFL, "OcFl");
        LightCharacters.put(S57val.LitCHR.CHR_FLFL, "FLFl");
        LightCharacters.put(S57val.LitCHR.CHR_ALOC, "Al.Oc");
        LightCharacters.put(S57val.LitCHR.CHR_ALLFL, "Al.LFl");
        LightCharacters.put(S57val.LitCHR.CHR_ALFL, "Al.Fl");
        LightCharacters.put(S57val.LitCHR.CHR_ALGR, "Al.Gr");
        LightCharacters.put(S57val.LitCHR.CHR_QLFL, "Q+LFl");
        LightCharacters.put(S57val.LitCHR.CHR_VQLFL, "VQ+LFl");
        LightCharacters.put(S57val.LitCHR.CHR_UQLFL, "UQ+LFl");
        LightCharacters.put(S57val.LitCHR.CHR_AL, "Al");
        LightCharacters.put(S57val.LitCHR.CHR_ALFFL, "Al.FFl");
        fogSignals = new EnumMap(S57val.CatFOG.class);
        fogSignals.put(S57val.CatFOG.FOG_EXPL, "Explos");
        fogSignals.put(S57val.CatFOG.FOG_DIA, "Dia");
        fogSignals.put(S57val.CatFOG.FOG_SIRN, "Siren");
        fogSignals.put(S57val.CatFOG.FOG_NAUT, "Horn");
        fogSignals.put(S57val.CatFOG.FOG_REED, "Horn");
        fogSignals.put(S57val.CatFOG.FOG_TYPH, "Horn");
        fogSignals.put(S57val.CatFOG.FOG_BELL, "Bell");
        fogSignals.put(S57val.CatFOG.FOG_WHIS, "Whis");
        fogSignals.put(S57val.CatFOG.FOG_GONG, "Gong");
        fogSignals.put(S57val.CatFOG.FOG_HORN, "Horn");
        df = new DecimalFormat("#.#");
    }

    class Sect {
        int dir;
        S57val.LitCHR chr;
        S57val.ColCOL col;
        S57val.ColCOL alt;
        String grp;
        double per;
        double rng;

        Sect() {
        }
    }
}

