/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public enum DigitalBase2SizeUnit {
    BITS("b", "bit"){

        @Override
        public long convert(long l, DigitalBase2SizeUnit digitalBase2SizeUnit) {
            return digitalBase2SizeUnit.toBytes(l);
        }

        @Override
        public long toBits(long l) {
            return l;
        }

        @Override
        public long toBytes(long l) {
            return l / 1024L;
        }

        @Override
        public long toGigabytes(long l) {
            return l / 0x10000000000L;
        }

        @Override
        public long toKilobytes(long l) {
            return l / 0x100000L;
        }

        @Override
        public long toMegabytes(long l) {
            return l / 0x40000000L;
        }

        @Override
        public long toTerabytes(long l) {
            return l / 0x4000000000000L;
        }
    }
    ,
    BYTES("B", "byte"){

        @Override
        public long convert(long l, DigitalBase2SizeUnit digitalBase2SizeUnit) {
            return digitalBase2SizeUnit.toBytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase2SizeUnit.x(l, 8L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long l) {
            return l;
        }

        @Override
        public long toGigabytes(long l) {
            return l / 0x40000000L;
        }

        @Override
        public long toKilobytes(long l) {
            return l / 1024L;
        }

        @Override
        public long toMegabytes(long l) {
            return l / 0x100000L;
        }

        @Override
        public long toTerabytes(long l) {
            return l / 0x10000000000L;
        }
    }
    ,
    GIGABYTES("Gi", "gibibyte", "gigabyte", "G"){

        @Override
        public long convert(long l, DigitalBase2SizeUnit digitalBase2SizeUnit) {
            return digitalBase2SizeUnit.toGigabytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase2SizeUnit.x(l, 0x40000000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toBytes(long l) {
            return DigitalBase2SizeUnit.x(l, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toGigabytes(long l) {
            return l;
        }

        @Override
        public long toKilobytes(long l) {
            return DigitalBase2SizeUnit.x(l, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long l) {
            return DigitalBase2SizeUnit.x(l, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTerabytes(long l) {
            return l / 1024L;
        }
    }
    ,
    KILOBYTES("Ki", "kibibyte", "kilobytes", "K"){

        @Override
        public long convert(long l, DigitalBase2SizeUnit digitalBase2SizeUnit) {
            return digitalBase2SizeUnit.toKilobytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase2SizeUnit.x(l, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long l) {
            return DigitalBase2SizeUnit.x(l, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGigabytes(long l) {
            return l / 0x100000L;
        }

        @Override
        public long toKilobytes(long l) {
            return l;
        }

        @Override
        public long toMegabytes(long l) {
            return l / 1024L;
        }

        @Override
        public long toTerabytes(long l) {
            return l / 0x40000000L;
        }
    }
    ,
    MEGABYTES("Mi", "mebibyte", "megabytes", "M"){

        @Override
        public long convert(long l, DigitalBase2SizeUnit digitalBase2SizeUnit) {
            return digitalBase2SizeUnit.toMegabytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase2SizeUnit.x(l, 0x100000L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toBytes(long l) {
            return DigitalBase2SizeUnit.x(l, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGigabytes(long l) {
            return l / 1024L;
        }

        @Override
        public long toKilobytes(long l) {
            return DigitalBase2SizeUnit.x(l, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long l) {
            return l;
        }

        @Override
        public long toTerabytes(long l) {
            return l / 0x100000L;
        }
    }
    ,
    TERABYTES("Ti", "tebibyte", "terabyte", "T"){

        @Override
        public long convert(long l, DigitalBase2SizeUnit digitalBase2SizeUnit) {
            return digitalBase2SizeUnit.toTerabytes(l);
        }

        @Override
        public long toBits(long l) {
            return DigitalBase2SizeUnit.x(l, 0x10000000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toBytes(long l) {
            return DigitalBase2SizeUnit.x(l, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toGigabytes(long l) {
            return DigitalBase2SizeUnit.x(l, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long l) {
            return DigitalBase2SizeUnit.x(l, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMegabytes(long l) {
            return DigitalBase2SizeUnit.x(l, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toTerabytes(long l) {
            return l;
        }
    };

    private static final long MULB = 8L;
    private static final long MULK = 1024L;
    private static final long K0 = 1L;
    private static final long K1 = 1024L;
    private static final long K2 = 0x100000L;
    private static final long K3 = 0x40000000L;
    private static final long K4 = 0x10000000000L;
    private static final long K5 = 0x4000000000000L;
    private final String name;
    private final String symbol;
    private final String customarySymbol;
    private final String customaryName;

    private static long x(long l, long l2, long l3) {
        if (l > l3) {
            return Long.MAX_VALUE;
        }
        if (l < -l3) {
            return Long.MIN_VALUE;
        }
        return l * l2;
    }

    private DigitalBase2SizeUnit(String string2, String string3) {
        this.name = string3;
        this.symbol = string3;
        this.customarySymbol = string2;
        this.customaryName = string3;
    }

    private DigitalBase2SizeUnit(String string2, String string3, String string4, String string5) {
        this.name = string3;
        this.symbol = string3;
        this.customarySymbol = string4;
        this.customaryName = string5;
    }

    protected abstract long convert(long var1, DigitalBase2SizeUnit var3);

    public String getCustomaryName() {
        return this.customaryName;
    }

    public String getCustomarySymbol() {
        return this.customarySymbol;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public abstract long toBits(long var1);

    public abstract long toBytes(long var1);

    public abstract long toGigabytes(long var1);

    public abstract long toKilobytes(long var1);

    public abstract long toMegabytes(long var1);

    public abstract long toTerabytes(long var1);
}

