/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class StopChecker
extends Checker {
    Set<OsmPrimitive> members;

    protected StopChecker(Relation relation, Test test) {
        super(relation, test);
        this.members = relation.getMemberPrimitives();
    }

    protected void performStopAreaStopPositionTest() {
        for (OsmPrimitive member : this.members) {
            if (!StopUtils.verifyStopAreaStopPosition(member)) continue;
            return;
        }
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop area relation has no stop position", (Object[])new Object[0]), 3765, primitives);
        this.errors.add(e);
    }

    protected void performStopAreaMultiStopPositionTest() {
        int countStopPosition = 0;
        for (OsmPrimitive member : this.members) {
            if (!StopUtils.verifyStopAreaStopPosition(member)) continue;
            ++countStopPosition;
        }
        if (countStopPosition <= 1) {
            return;
        }
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop area relation has several stop positions", (Object[])new Object[0]), 3765, primitives);
        this.errors.add(e);
    }

    protected void performStopAreaPlatformTest() {
        for (OsmPrimitive member : this.members) {
            if (!StopUtils.verifyStopAreaPlatform(member)) continue;
            return;
        }
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop area relation has no platform", (Object[])new Object[0]), 3766, primitives);
        this.errors.add(e);
    }

    protected void performStopAreaMultiPlatformTest() {
        int countPlatform = 0;
        for (OsmPrimitive member : this.members) {
            if (!StopUtils.verifyStopAreaPlatform(member)) continue;
            ++countPlatform;
        }
        if (countPlatform <= 1) {
            return;
        }
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(this.relation);
        TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Stop area relation has several platforms", (Object[])new Object[0]), 3767, primitives);
        this.errors.add(e);
    }
}

