/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources.image;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.MultiBandsIndexColorModel;

public final class ColorUtilities {
    private static final double EPS = 1.0E-6;
    public static final ComponentColorModel GRAY_CM = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
    public static final ComponentColorModel GRAY_ALPHA_CM = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 0);
    public static final ComponentColorModel RGB_CM = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
    public static final ComponentColorModel RGB_ALPHA_CM = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);

    private ColorUtilities() {
    }

    public static int getIntFromColor(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static Color[] subarray(Color[] palette, int lower, int upper) {
        if (palette != null) {
            if ((lower = Math.max(lower, 0)) >= (upper = Math.min(upper, palette.length))) {
                return null;
            }
            if (lower != 0 || upper != palette.length) {
                Color[] sub = new Color[upper - lower];
                System.arraycopy(palette, lower, sub, 0, sub.length);
                return sub;
            }
        }
        return palette;
    }

    public static void expand(Color[] colors, int[] ARGB, int lower, int upper) {
        switch (colors.length) {
            case 1: {
                Arrays.fill(ARGB, lower, upper, colors[0].getRGB());
            }
            case 0: {
                return;
            }
        }
        switch (upper - lower) {
            case 1: {
                ARGB[lower] = colors[0].getRGB();
            }
            case 0: {
                return;
            }
        }
        double scale = (double)(colors.length - 1) / (double)(upper - 1 - lower);
        int maxBase = colors.length - 2;
        double index = 0.0;
        int base = 0;
        int i = lower;
        while (true) {
            int C0 = colors[base + 0].getRGB();
            int C1 = colors[base + 1].getRGB();
            int A0 = C0 >>> 24 & 0xFF;
            int A1 = (C1 >>> 24 & 0xFF) - A0;
            int R0 = C0 >>> 16 & 0xFF;
            int R1 = (C1 >>> 16 & 0xFF) - R0;
            int G0 = C0 >>> 8 & 0xFF;
            int G1 = (C1 >>> 8 & 0xFF) - G0;
            int B0 = C0 & 0xFF;
            int B1 = (C1 & 0xFF) - B0;
            int oldBase = base;
            do {
                double delta = index - (double)base;
                ARGB[i] = ColorUtilities.roundByte((double)A0 + delta * (double)A1) << 24 | ColorUtilities.roundByte((double)R0 + delta * (double)R1) << 16 | ColorUtilities.roundByte((double)G0 + delta * (double)G1) << 8 | ColorUtilities.roundByte((double)B0 + delta * (double)B1);
                if (++i != upper) continue;
                return;
            } while ((base = Math.min(maxBase, (int)((index = (double)(i - lower) * scale) + 1.0E-6))) == oldBase);
        }
    }

    public static int roundByte(double value) {
        return (int)Math.min(Math.max(Math.round(value), 0L), 255L);
    }

    public static IndexColorModel getIndexColorModel(int[] ARGB) {
        return ColorUtilities.getIndexColorModel(ARGB, 1, 0);
    }

    public static IndexColorModel getIndexColorModel(int[] ARGB, int numBands, int visibleBand) {
        boolean hasAlpha = false;
        int transparent = -1;
        int length = ARGB.length;
        for (int i = 0; i < length; ++i) {
            int alpha = ARGB[i] & 0xFF000000;
            if (alpha == -16777216) continue;
            if (alpha == 0 && transparent < 0) {
                transparent = i;
                continue;
            }
            hasAlpha = true;
            break;
        }
        int bits = ColorUtilities.getBitCount(length);
        int type = ColorUtilities.getTransferType(length);
        if (numBands == 1) {
            return new IndexColorModel(bits, length, ARGB, 0, hasAlpha, transparent, type);
        }
        return new MultiBandsIndexColorModel(bits, length, ARGB, 0, hasAlpha, transparent, type, numBands, visibleBand);
    }

    public static int getBitCount(int mapSize) {
        int max = mapSize - 1;
        if (max <= 1) {
            return 1;
        }
        int count = 0;
        do {
            ++count;
        } while ((max >>= 1) != 0);
        assert (1 << count >= mapSize) : mapSize;
        assert (1 << count - 1 < mapSize) : mapSize;
        return count;
    }

    public static int getTransferType(int mapSize) {
        return mapSize <= 256 ? 0 : 1;
    }

    public static float[] XYZtoLAB(float[] color) {
        color[0] = (float)((double)color[0] / 0.9642);
        color[1] = (float)((double)color[1] / 1.0);
        color[2] = (float)((double)color[2] / 0.8249);
        for (int i = 0; i < 3; ++i) {
            float c = color[i];
            color[i] = (float)(c > 0.008856452f ? Math.pow(c, 0.3333333333333333) : (903.2962962962963 * (double)c + 16.0) / 116.0);
        }
        float L = 116.0f * color[1] - 16.0f;
        float a = 500.0f * (color[0] - color[1]);
        float b = 200.0f * (color[1] - color[2]);
        assert (!(Float.isNaN(L) || Float.isNaN(a) || Float.isNaN(b)));
        color[0] = L;
        color[1] = a;
        color[2] = b;
        return color;
    }

    public static float colorDistance(float[] lab1, float[] lab2) {
        double sum = 0.0;
        int i = Math.min(lab1.length, lab2.length);
        while (--i >= 0) {
            double delta = lab1[i] - lab2[i];
            sum += delta * delta;
        }
        return (float)Math.sqrt(sum);
    }

    public static int getTransparentPixel(IndexColorModel colors) {
        int index = colors.getTransparentPixel();
        if (index < 0) {
            index = 0;
            int alpha = Integer.MAX_VALUE;
            float delta = Float.POSITIVE_INFINITY;
            ColorSpace space = colors.getColorSpace();
            float[] RGB2 = new float[3];
            float[] BLACK = ColorUtilities.XYZtoLAB(space.toCIEXYZ(RGB2));
            assert (BLACK != RGB2);
            int i = colors.getMapSize();
            while (--i >= 0) {
                int a = colors.getAlpha(i);
                if (a > alpha) continue;
                RGB2[0] = (float)colors.getRed(i) / 255.0f;
                RGB2[1] = (float)colors.getGreen(i) / 255.0f;
                RGB2[2] = (float)colors.getBlue(i) / 255.0f;
                float d = ColorUtilities.colorDistance(ColorUtilities.XYZtoLAB(space.toCIEXYZ(RGB2)), BLACK);
                assert (d >= 0.0f) : i;
                if (a >= alpha && !(d < delta)) continue;
                alpha = a;
                delta = d;
                index = i;
            }
        }
        return index;
    }

    public static int getColorIndex(IndexColorModel colors, Color color, int exclude) {
        ColorSpace space = colors.getColorSpace();
        float[] RGB2 = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        float[] REF = ColorUtilities.XYZtoLAB(space.toCIEXYZ(RGB2));
        float delta = Float.POSITIVE_INFINITY;
        int index = 0;
        assert (REF != RGB2);
        int i = colors.getMapSize();
        while (--i >= 0) {
            if (i == exclude) continue;
            RGB2[0] = (float)colors.getRed(i) / 255.0f;
            RGB2[1] = (float)colors.getGreen(i) / 255.0f;
            RGB2[2] = (float)colors.getBlue(i) / 255.0f;
            float d = ColorUtilities.colorDistance(ColorUtilities.XYZtoLAB(space.toCIEXYZ(RGB2)), REF);
            assert (d >= 0.0f) : i;
            if (!(d <= delta)) continue;
            delta = d;
            index = i;
        }
        return index;
    }

    public static int getNumBands(ColorModel model) {
        if (model instanceof IndexColorModel) {
            if (model instanceof MultiBandsIndexColorModel) {
                return ((MultiBandsIndexColorModel)model).numBands;
            }
            return 1;
        }
        return model.getNumComponents();
    }

    public static boolean isGrayPalette(IndexColorModel icm, boolean ignoreTransparents) {
        if (!icm.hasAlpha()) {
            ignoreTransparents = false;
        }
        int mapSize = icm.getMapSize();
        for (int i = 0; i < mapSize; ++i) {
            int green;
            if (ignoreTransparents && icm.getAlpha(i) == 0 || (green = icm.getGreen(i)) == icm.getRed(i) && green == icm.getBlue(i)) continue;
            return false;
        }
        return true;
    }

    public static double getMinimum(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 2: {
                return -32768.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 5: {
                return -9.223372036854776E18;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
        }
        throw new IllegalArgumentException(Errors.format(58, "DataType unknown:", dataType));
    }

    public static double getThreshold(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 3: {
                return -2.147483648E9;
            }
            case 2: {
                return -32768.0;
            }
            case 5: {
                return -1.7976931348623157E308;
            }
            case 4: {
                return -3.4028234663852886E38;
            }
        }
        return 0.0;
    }

    public static int findColorIndex(Color bgColor, IndexColorModel icm) {
        if (bgColor == null) {
            throw new NullPointerException(Errors.format(143, "bgColor"));
        }
        if (icm == null) {
            throw new NullPointerException(Errors.format(143, "icm"));
        }
        int r = bgColor.getRed();
        int g = bgColor.getGreen();
        int b = bgColor.getBlue();
        int a = bgColor.getAlpha();
        int size = icm.getMapSize();
        for (int i = 0; i < size; ++i) {
            if (r != icm.getRed(i) || g != icm.getGreen(i) || b != icm.getBlue(i) || a != icm.getAlpha(i) && icm.hasAlpha()) continue;
            return i;
        }
        return -1;
    }

    public static IndexColorModel applyBackgroundColor(IndexColorModel icm, Color bg) {
        int trasparentIdx = icm.getTransparentPixel();
        if (icm.getTransparency() == 1 && trasparentIdx == -1) {
            return icm;
        }
        int size = icm.getMapSize();
        byte[] reds = new byte[size];
        byte[] greens = new byte[size];
        byte[] blues = new byte[size];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        if (icm.getTransparency() == 1 && trasparentIdx != -1) {
            reds[trasparentIdx] = (byte)bg.getRed();
            greens[trasparentIdx] = (byte)bg.getGreen();
            blues[trasparentIdx] = (byte)bg.getBlue();
            return new IndexColorModel(icm.getPixelSize(), size, reds, greens, blues);
        }
        byte[] alphas = new byte[size];
        icm.getAlphas(alphas);
        int r = bg.getRed() & 0xFF;
        int g = bg.getGreen() & 0xFF;
        int b = bg.getBlue() & 0xFF;
        int a = bg.getAlpha() & 0xFF;
        for (int i = 0; i < size; ++i) {
            float t5;
            float t4;
            int t1 = alphas[i] & 0xFF;
            float t2 = (float)(a & 0xFF) * (1.0f - (float)t1 / 255.0f);
            float t3 = (float)t1 + t2;
            if (t3 == 0.0f) {
                t4 = 0.0f;
                t5 = 0.0f;
            } else {
                t4 = (float)t1 / t3;
                t5 = 1.0f - t4;
            }
            int ri = reds[i] & 0xFF;
            reds[i] = (byte)((float)ri * t4 + (float)r * t5);
            int gi = greens[i] & 0xFF;
            greens[i] = (byte)((float)gi * t4 + (float)g * t5);
            int bi = blues[i] & 0xFF;
            blues[i] = (byte)((float)bi * t4 + (float)b * t5);
            alphas[i] = (byte)t3;
        }
        if (a < 255) {
            return new IndexColorModel(icm.getPixelSize(), size, reds, greens, blues, alphas);
        }
        return new IndexColorModel(icm.getPixelSize(), size, reds, greens, blues);
    }

    public static double getMaximum(int dataType) {
        switch (dataType) {
            case 0: {
                return 255.0;
            }
            case 2: {
                return 32767.0;
            }
            case 1: {
                return 65535.0;
            }
            case 3: {
                return 2.147483647E9;
            }
            case 5: {
                return 9.223372036854776E18;
            }
            case 4: {
                return 3.4028234663852886E38;
            }
        }
        throw new IllegalArgumentException(Errors.format(58, "DataType unknown:", dataType));
    }
}

