/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.capability.FunctionName;
import org.opengis.util.ProgressListener;

public class JenksNaturalBreaksFunction
extends ClassificationFunction {
    ProgressListener progress;
    private static final Logger logger = Logging.getLogger("org.geotools.filter.function");
    public static FunctionName NAME = new FunctionNameImpl("Jenks", RangedClassifier.class, FunctionNameImpl.parameter("value", Double.class), FunctionNameImpl.parameter("classes", Integer.class));

    public JenksNaturalBreaksFunction() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        if (!(feature instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)feature);
    }

    private Object calculate(SimpleFeatureCollection featureCollection) {
        int i;
        SimpleFeatureIterator features = featureCollection.features();
        ArrayList<Double> data = new ArrayList<Double>();
        try {
            while (features.hasNext()) {
                Double e;
                SimpleFeature feature = (SimpleFeature)features.next();
                Object result = this.getParameters().get(0).evaluate(feature);
                logger.finest("importing " + result);
                if (result == null || (e = new Double(result.toString())).isInfinite() || e.isNaN()) continue;
                data.add(e);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        Collections.sort(data);
        int k = this.getClasses();
        int m = data.size();
        if (k == m) {
            logger.info("Number of classes (" + k + ") is equal to number of data points (" + m + ") " + "unique classification returned");
            Comparable[] localMin = new Comparable[k];
            Comparable[] localMax = new Comparable[k];
            for (int id = 0; id < k - 1; ++id) {
                localMax[id] = (Comparable)data.get(id + 1);
                localMin[id] = (Comparable)data.get(id);
            }
            localMax[k - 1] = (Comparable)data.get(k - 1);
            localMin[k - 1] = (Comparable)data.get(k - 1);
            return new RangedClassifier(localMin, localMax);
        }
        int[][] iwork = new int[m + 1][k + 1];
        double[][] work = new double[m + 1][k + 1];
        for (int j = 1; j <= k; ++j) {
            iwork[0][j] = 1;
            iwork[1][j] = 1;
            work[1][j] = 0.0;
            for (int i2 = 2; i2 <= m; ++i2) {
                work[i2][j] = Double.MAX_VALUE;
            }
        }
        for (i = 1; i <= m; ++i) {
            double s1 = 0.0;
            double s2 = 0.0;
            double var = 0.0;
            for (int ii = 1; ii <= i; ++ii) {
                int i3 = i - ii + 1;
                double val = (Double)data.get(i3 - 1);
                double s0 = ii;
                var = (s2 += val * val) - (s1 += val) * s1 / s0;
                int ik = i3 - 1;
                if (ik == 0) continue;
                for (int j = 2; j <= k; ++j) {
                    if (!(work[i][j] >= var + work[ik][j - 1])) continue;
                    iwork[i][j] = i3 - 1;
                    work[i][j] = var + work[ik][j - 1];
                }
            }
            iwork[i][1] = 1;
            work[i][1] = var;
        }
        if (logger.getLevel() == Level.FINER) {
            for (i = 0; i < m; ++i) {
                String tmp = i + ": " + data.get(i);
                for (int j = 2; j <= k; ++j) {
                    tmp = tmp + "\t" + iwork[i][j];
                }
                logger.finer(tmp);
            }
        }
        int ik = m - 1;
        Comparable[] localMin = new Comparable[k];
        Comparable[] localMax = new Comparable[k];
        localMax[k - 1] = (Comparable)data.get(ik);
        for (int j = k; j >= 2; --j) {
            logger.finest("index " + ik + ", class" + j);
            int id = iwork[ik][j] - 1;
            localMax[j - 2] = (Comparable)data.get(id);
            localMin[j - 1] = (Comparable)data.get(id);
            ik = iwork[ik][j] - 1;
        }
        localMin[0] = (Comparable)data.get(0);
        features.close();
        return new RangedClassifier(localMin, localMax);
    }
}

