/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.waypointSearch;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.waypointSearch.Engine;
import org.openstreetmap.josm.plugins.waypointSearch.SelectWaypointDialog;
import org.openstreetmap.josm.tools.I18n;

public class WaypointSearchPlugin
extends Plugin
implements LayerManager.LayerChangeListener {
    private SelectWaypointDialog waypointDialog;

    public WaypointSearchPlugin(PluginInformation info) {
        super(info);
        Main.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.waypointDialog = new SelectWaypointDialog(I18n.tr((String)"Waypoint search", (Object[])new Object[0]), "ToolbarIcon", I18n.tr((String)"Search after waypoint. Click and move the map view to the waypoint.", (Object[])new Object[0]), null, 100);
            newFrame.addToggleDialog((ToggleDialog)this.waypointDialog);
        } else {
            this.waypointDialog = null;
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        if (this.waypointDialog != null && Engine.gpxLayersExist()) {
            this.waypointDialog.updateSearchResults();
        }
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (this.waypointDialog != null && !Engine.gpxLayersExist()) {
            this.waypointDialog.updateSearchResults();
        }
    }
}

